/*
 * Decompiled with CFR 0.152.
 */
package su.litvak.chromecast.api.v2;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import su.litvak.chromecast.api.v2.Track;

public class Media {
    public static final String METADATA_TYPE = "metadataType";
    public static final String METADATA_ALBUM_ARTIST = "albumArtist";
    public static final String METADATA_ALBUM_NAME = "albumName";
    public static final String METADATA_ARTIST = "artist";
    public static final String METADATA_BROADCAST_DATE = "broadcastDate";
    public static final String METADATA_COMPOSER = "composer";
    public static final String METADATA_CREATION_DATE = "creationDate";
    public static final String METADATA_DISC_NUMBER = "discNumber";
    public static final String METADATA_EPISODE_NUMBER = "episodeNumber";
    public static final String METADATA_HEIGHT = "height";
    public static final String METADATA_IMAGES = "images";
    public static final String METADATA_LOCATION_NAME = "locationName";
    public static final String METADATA_LOCATION_LATITUDE = "locationLatitude";
    public static final String METADATA_LOCATION_LONGITUDE = "locationLongitude";
    public static final String METADATA_RELEASE_DATE = "releaseDate";
    public static final String METADATA_SEASON_NUMBER = "seasonNumber";
    public static final String METADATA_SERIES_TITLE = "seriesTitle";
    public static final String METADATA_STUDIO = "studio";
    public static final String METADATA_SUBTITLE = "subtitle";
    public static final String METADATA_TITLE = "title";
    public static final String METADATA_TRACK_NUMBER = "trackNumber";
    public static final String METADATA_WIDTH = "width";
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Map<String, Object> metadata;
    @JsonProperty(value="contentId")
    public final String url;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Double duration;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final StreamType streamType;
    @JsonProperty
    public final String contentType;
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final Map<String, Object> customData;
    @JsonIgnore
    public final Map<String, Object> textTrackStyle;
    @JsonIgnore
    public final List<Track> tracks;

    public Media(String url, String contentType) {
        this(url, contentType, null, null);
    }

    public Media(String url, String contentType, Double duration, StreamType streamType) {
        this(url, contentType, duration, streamType, null, null, null, null);
    }

    public Media(@JsonProperty(value="contentId") String url, @JsonProperty(value="contentType") String contentType, @JsonProperty(value="duration") Double duration, @JsonProperty(value="streamType") StreamType streamType, @JsonProperty(value="customData") Map<String, Object> customData, @JsonProperty(value="metadata") Map<String, Object> metadata, @JsonProperty(value="textTrackStyle") Map<String, Object> textTrackStyle, @JsonProperty(value="tracks") List<Track> tracks) {
        this.url = url;
        this.contentType = contentType;
        this.duration = duration;
        this.streamType = streamType;
        this.customData = customData == null ? null : Collections.unmodifiableMap(customData);
        this.metadata = metadata == null ? null : Collections.unmodifiableMap(metadata);
        this.textTrackStyle = textTrackStyle == null ? null : Collections.unmodifiableMap(textTrackStyle);
        this.tracks = tracks == null ? null : Collections.unmodifiableList(tracks);
    }

    @JsonIgnore
    public final MetadataType getMetadataType() {
        if (this.metadata == null || !this.metadata.containsKey(METADATA_TYPE)) {
            return MetadataType.GENERIC;
        }
        Integer ordinal = (Integer)this.metadata.get(METADATA_TYPE);
        return ordinal < MetadataType.values().length ? MetadataType.values()[ordinal] : MetadataType.GENERIC;
    }

    public final int hashCode() {
        return Arrays.hashCode(new Object[]{this.url, this.contentType, this.streamType, this.duration});
    }

    public final boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Media)) {
            return false;
        }
        Media that = (Media)obj;
        return this.url == null ? that.url == null : (this.url.equals(that.url) && this.contentType == null ? that.contentType == null : (this.contentType.equals(that.contentType) && this.streamType == null ? that.streamType == null : (this.streamType.equals((Object)that.streamType) && this.duration == null ? that.duration == null : this.duration.equals(that.duration))));
    }

    public final String toString() {
        return String.format("Media{url: %s, contentType: %s, duration: %s}", this.url, this.contentType, this.duration);
    }

    public static enum StreamType {
        BUFFERED,
        buffered,
        LIVE,
        live,
        NONE,
        none;

    }

    public static enum MetadataType {
        GENERIC,
        MOVIE,
        TV_SHOW,
        MUSIC_TRACK,
        PHOTO;

    }
}

