/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.ext;

import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;
import org.slf4j.ext.LoggerWrapper;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import org.slf4j.spi.LocationAwareLogger;

public class XLogger
extends LoggerWrapper
implements Logger {
    private static final String FQCN = XLogger.class.getName();
    static Marker FLOW_MARKER = MarkerFactory.getMarker("FLOW");
    static Marker ENTRY_MARKER = MarkerFactory.getMarker("ENTRY");
    static Marker EXIT_MARKER = MarkerFactory.getMarker("EXIT");
    static Marker EXCEPTION_MARKER = MarkerFactory.getMarker("EXCEPTION");
    static Marker THROWING_MARKER = MarkerFactory.getMarker("THROWING");
    static Marker CATCHING_MARKER = MarkerFactory.getMarker("CATCHING");
    static String EXIT_MESSAGE_0 = "exit";
    static String EXIT_MESSAGE_1 = "exit with ({})";
    static String ENTRY_MESSAGE_0 = "entry";
    static String ENTRY_MESSAGE_1 = "entry with ({})";
    static String ENTRY_MESSAGE_2 = "entry with ({}, {})";
    static String ENTRY_MESSAGE_3 = "entry with ({}, {}, {})";
    static String ENTRY_MESSAGE_4 = "entry with ({}, {}, {}, {})";
    static int ENTRY_MESSAGE_ARRAY_LEN = 5;
    static String[] ENTRY_MESSAGE_ARRAY = new String[ENTRY_MESSAGE_ARRAY_LEN];

    public XLogger(Logger logger) {
        super(logger, LoggerWrapper.class.getName());
    }

    public void entry(Object ... argArray) {
        if (this.instanceofLAL && this.logger.isTraceEnabled(ENTRY_MARKER)) {
            String messagePattern = null;
            messagePattern = argArray.length < ENTRY_MESSAGE_ARRAY_LEN ? ENTRY_MESSAGE_ARRAY[argArray.length] : XLogger.buildMessagePattern(argArray.length);
            FormattingTuple tp = MessageFormatter.arrayFormat(messagePattern, argArray);
            ((LocationAwareLogger)this.logger).log(ENTRY_MARKER, FQCN, 0, tp.getMessage(), argArray, tp.getThrowable());
        }
    }

    public void exit() {
        if (this.instanceofLAL && this.logger.isTraceEnabled(ENTRY_MARKER)) {
            ((LocationAwareLogger)this.logger).log(EXIT_MARKER, FQCN, 0, EXIT_MESSAGE_0, null, null);
        }
    }

    public <T> T exit(T result) {
        if (this.instanceofLAL && this.logger.isTraceEnabled(ENTRY_MARKER)) {
            FormattingTuple tp = MessageFormatter.format(EXIT_MESSAGE_1, result);
            ((LocationAwareLogger)this.logger).log(EXIT_MARKER, FQCN, 0, tp.getMessage(), new Object[]{result}, tp.getThrowable());
        }
        return result;
    }

    public <T extends Throwable> T throwing(T throwable) {
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(THROWING_MARKER, FQCN, 40, "throwing", null, throwable);
        }
        return throwable;
    }

    public <T extends Throwable> T throwing(Level level, T throwable) {
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(THROWING_MARKER, FQCN, level.level, "throwing", null, throwable);
        }
        return throwable;
    }

    public void catching(Throwable throwable) {
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(CATCHING_MARKER, FQCN, 40, "catching", null, throwable);
        }
    }

    public void catching(Level level, Throwable throwable) {
        if (this.instanceofLAL) {
            ((LocationAwareLogger)this.logger).log(CATCHING_MARKER, FQCN, level.level, "catching", null, throwable);
        }
    }

    private static String buildMessagePattern(int len) {
        StringBuilder sb = new StringBuilder();
        sb.append(" entry with (");
        for (int i = 0; i < len; ++i) {
            sb.append("{}");
            if (i == len - 1) continue;
            sb.append(", ");
        }
        sb.append(')');
        return sb.toString();
    }

    static {
        ENTRY_MARKER.add(FLOW_MARKER);
        EXIT_MARKER.add(FLOW_MARKER);
        THROWING_MARKER.add(EXCEPTION_MARKER);
        CATCHING_MARKER.add(EXCEPTION_MARKER);
        XLogger.ENTRY_MESSAGE_ARRAY[0] = ENTRY_MESSAGE_0;
        XLogger.ENTRY_MESSAGE_ARRAY[1] = ENTRY_MESSAGE_1;
        XLogger.ENTRY_MESSAGE_ARRAY[2] = ENTRY_MESSAGE_2;
        XLogger.ENTRY_MESSAGE_ARRAY[3] = ENTRY_MESSAGE_3;
        XLogger.ENTRY_MESSAGE_ARRAY[4] = ENTRY_MESSAGE_4;
    }

    public static enum Level {
        TRACE("TRACE", 0),
        DEBUG("DEBUG", 10),
        INFO("INFO", 20),
        WARN("WARN", 30),
        ERROR("ERROR", 40);

        private final String name;
        private final int level;

        public String toString() {
            return this.name;
        }

        public int intValue() {
            return this.level;
        }

        private Level(String name, int level) {
            this.name = name;
            this.level = level;
        }
    }
}

