/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.transport;

import java.net.BindException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.jupnp.UpnpServiceConfiguration;
import org.jupnp.model.NetworkAddress;
import org.jupnp.model.message.IncomingDatagramMessage;
import org.jupnp.model.message.OutgoingDatagramMessage;
import org.jupnp.model.message.StreamRequestMessage;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.protocol.ProtocolCreationException;
import org.jupnp.protocol.ProtocolFactory;
import org.jupnp.protocol.ReceivingAsync;
import org.jupnp.transport.DisableRouter;
import org.jupnp.transport.EnableRouter;
import org.jupnp.transport.Router;
import org.jupnp.transport.RouterException;
import org.jupnp.transport.spi.DatagramIO;
import org.jupnp.transport.spi.InitializationException;
import org.jupnp.transport.spi.MulticastReceiver;
import org.jupnp.transport.spi.NetworkAddressFactory;
import org.jupnp.transport.spi.NoNetworkException;
import org.jupnp.transport.spi.StreamClient;
import org.jupnp.transport.spi.StreamServer;
import org.jupnp.transport.spi.UpnpStream;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouterImpl
implements Router {
    private final Logger logger = LoggerFactory.getLogger(Router.class);
    protected UpnpServiceConfiguration configuration;
    protected ProtocolFactory protocolFactory;
    protected volatile boolean enabled;
    protected ReentrantReadWriteLock routerLock = new ReentrantReadWriteLock(true);
    protected Lock readLock = this.routerLock.readLock();
    protected Lock writeLock = this.routerLock.writeLock();
    protected NetworkAddressFactory networkAddressFactory;
    protected StreamClient streamClient;
    protected final Map<NetworkInterface, MulticastReceiver> multicastReceivers = new HashMap<NetworkInterface, MulticastReceiver>();
    protected final Map<InetAddress, DatagramIO> datagramIOs = new HashMap<InetAddress, DatagramIO>();
    protected final Map<InetAddress, StreamServer> streamServers = new HashMap<InetAddress, StreamServer>();

    protected RouterImpl() {
    }

    public RouterImpl(UpnpServiceConfiguration configuration, ProtocolFactory protocolFactory) {
        this.configuration = configuration;
        this.protocolFactory = protocolFactory;
    }

    public boolean enable(EnableRouter event) throws RouterException {
        return this.enable();
    }

    public boolean disable(DisableRouter event) throws RouterException {
        return this.disable();
    }

    @Override
    public UpnpServiceConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProtocolFactory getProtocolFactory() {
        return this.protocolFactory;
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean enable() throws RouterException {
        this.lock(this.writeLock);
        try {
            if (!this.enabled) {
                try {
                    this.logger.debug("Starting networking services...");
                    this.networkAddressFactory = this.getConfiguration().createNetworkAddressFactory();
                    this.startInterfaceBasedTransports(this.networkAddressFactory.getNetworkInterfaces());
                    this.startAddressBasedTransports(this.networkAddressFactory.getBindAddresses());
                    if (!this.networkAddressFactory.hasUsableNetwork()) {
                        throw new NoNetworkException("No usable network interface and/or addresses available, check the log for errors.");
                    }
                    this.streamClient = this.getConfiguration().createStreamClient();
                    this.enabled = true;
                    return true;
                }
                catch (InitializationException e) {
                    this.handleStartFailure(e);
                }
            }
            return false;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.unlock(this.writeLock);
        }
    }

    @Override
    public boolean disable() throws RouterException {
        this.lock(this.writeLock);
        try {
            if (this.enabled) {
                this.logger.debug("Disabling network services...");
                if (this.streamClient != null) {
                    this.logger.debug("Stopping stream client connection management/pool");
                    this.streamClient.stop();
                    this.streamClient = null;
                }
                for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
                    this.logger.debug("Stopping stream server on address: {}", (Object)entry.getKey());
                    entry.getValue().stop();
                }
                this.streamServers.clear();
                for (Map.Entry<Object, Runnable> entry : this.multicastReceivers.entrySet()) {
                    this.logger.debug("Stopping multicast receiver on interface: {}", (Object)((NetworkInterface)entry.getKey()).getDisplayName());
                    ((MulticastReceiver)entry.getValue()).stop();
                }
                this.multicastReceivers.clear();
                for (Map.Entry<Object, Runnable> entry : this.datagramIOs.entrySet()) {
                    this.logger.debug("Stopping datagram I/O on address: {}", entry.getKey());
                    ((DatagramIO)entry.getValue()).stop();
                }
                this.datagramIOs.clear();
                this.networkAddressFactory = null;
                this.enabled = false;
                return true;
            }
            return false;
        }
        finally {
            this.unlock(this.writeLock);
        }
    }

    @Override
    public void shutdown() throws RouterException {
        this.disable();
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public void handleStartFailure(InitializationException e) throws InitializationException {
        if (e instanceof NoNetworkException) {
            this.logger.info("Unable to initialize network router, no network found.");
        } else {
            this.logger.error("Unable to initialize network router", e);
        }
    }

    @Override
    public List<NetworkAddress> getActiveStreamServers(InetAddress preferredAddress) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled && !this.streamServers.isEmpty()) {
                StreamServer preferredServer;
                ArrayList<NetworkAddress> streamServerAddresses = new ArrayList<NetworkAddress>();
                if (preferredAddress != null && (preferredServer = this.streamServers.get(preferredAddress)) != null) {
                    streamServerAddresses.add(new NetworkAddress(preferredAddress, preferredServer.getPort(), this.networkAddressFactory.getHardwareAddress(preferredAddress)));
                    ArrayList<NetworkAddress> arrayList = streamServerAddresses;
                    return arrayList;
                }
                for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
                    byte[] hardwareAddress = this.networkAddressFactory.getHardwareAddress(entry.getKey());
                    streamServerAddresses.add(new NetworkAddress(entry.getKey(), entry.getValue().getPort(), hardwareAddress));
                }
                ArrayList<NetworkAddress> arrayList = streamServerAddresses;
                return arrayList;
            }
            List<NetworkAddress> list = List.of();
            return list;
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    @Override
    public void received(IncomingDatagramMessage msg) {
        if (!this.enabled) {
            this.logger.debug("Router disabled, ignoring incoming message: {}", (Object)msg);
            return;
        }
        try {
            ReceivingAsync protocol = this.getProtocolFactory().createReceivingAsync(msg);
            if (protocol == null) {
                this.logger.trace("No protocol, ignoring received message: {}", (Object)msg);
                return;
            }
            this.logger.debug("Received asynchronous message: {}", (Object)msg);
            this.getConfiguration().getRemoteListenerExecutor().execute(protocol);
        }
        catch (ProtocolCreationException e) {
            this.logger.warn("Handling received datagram failed", e);
        }
    }

    @Override
    public void received(UpnpStream stream) {
        if (!this.enabled) {
            this.logger.debug("Router disabled, ignoring incoming: {}", (Object)stream);
            return;
        }
        this.logger.debug("Received synchronous stream: {}", (Object)stream);
        this.getConfiguration().getSyncProtocolExecutorService().execute(stream);
    }

    @Override
    public void send(OutgoingDatagramMessage msg) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled) {
                for (DatagramIO datagramIO : this.datagramIOs.values()) {
                    datagramIO.send(msg);
                }
            } else {
                this.logger.debug("Router disabled, not sending datagram: {}", (Object)msg);
            }
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    @Override
    public StreamResponseMessage send(StreamRequestMessage msg) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled) {
                if (this.streamClient == null) {
                    this.logger.debug("No StreamClient available, not sending: {}", (Object)msg);
                    return null;
                }
                this.logger.debug("Sending via TCP unicast stream: {}", (Object)msg);
                try {
                    StreamResponseMessage streamResponseMessage = this.streamClient.sendRequest(msg);
                    return streamResponseMessage;
                }
                catch (InterruptedException e) {
                    throw new RouterException("Sending stream request was interrupted", e);
                }
            }
            this.logger.debug("Router disabled, not sending stream request: {}", (Object)msg);
            return null;
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    @Override
    public void broadcast(byte[] bytes) throws RouterException {
        this.lock(this.readLock);
        try {
            if (this.enabled) {
                for (Map.Entry<InetAddress, DatagramIO> entry : this.datagramIOs.entrySet()) {
                    InetAddress broadcast = this.networkAddressFactory.getBroadcastAddress(entry.getKey());
                    if (broadcast == null) continue;
                    this.logger.debug("Sending UDP datagram to broadcast address: {}", (Object)broadcast.getHostAddress());
                    DatagramPacket packet = new DatagramPacket(bytes, bytes.length, broadcast, 9);
                    entry.getValue().send(packet);
                }
            } else {
                this.logger.debug("Router disabled, not broadcasting bytes: {}", (Object)bytes.length);
            }
        }
        finally {
            this.unlock(this.readLock);
        }
    }

    protected void startInterfaceBasedTransports(Iterator<NetworkInterface> interfaces) throws InitializationException {
        while (interfaces.hasNext()) {
            NetworkInterface networkInterface = interfaces.next();
            MulticastReceiver multicastReceiver = this.getConfiguration().createMulticastReceiver(this.networkAddressFactory);
            if (multicastReceiver == null) {
                this.logger.info("Configuration did not create a MulticastReceiver for: {}", (Object)networkInterface);
                continue;
            }
            this.logger.debug("Init multicast receiver on interface: {}", (Object)networkInterface.getDisplayName());
            multicastReceiver.init(networkInterface, this, this.networkAddressFactory, this.getConfiguration().getDatagramProcessor());
            this.multicastReceivers.put(networkInterface, multicastReceiver);
        }
        for (Map.Entry<NetworkInterface, MulticastReceiver> entry : this.multicastReceivers.entrySet()) {
            this.logger.debug("Starting multicast receiver on interface: {}", (Object)entry.getKey().getDisplayName());
            this.getConfiguration().getMulticastReceiverExecutor().execute(entry.getValue());
        }
    }

    protected void startAddressBasedTransports(Iterator<InetAddress> addresses) throws InitializationException {
        while (addresses.hasNext()) {
            InetAddress inetAddress = addresses.next();
            StreamServer streamServer = this.getConfiguration().createStreamServer(this.networkAddressFactory);
            if (streamServer == null) {
                this.logger.info("Configuration did not create a StreamServer for: {}", (Object)inetAddress);
            } else {
                try {
                    this.logger.debug("Init stream server on address: {}", (Object)inetAddress);
                    streamServer.init(inetAddress, this);
                    this.streamServers.put(inetAddress, streamServer);
                }
                catch (InitializationException e) {
                    Throwable cause = Exceptions.unwrap(e);
                    if (cause instanceof BindException) {
                        this.logger.warn("Failed to init StreamServer. Removing unusable address: {}", (Object)inetAddress, (Object)cause);
                        addresses.remove();
                        continue;
                    }
                    throw e;
                }
            }
            DatagramIO datagramIO = this.getConfiguration().createDatagramIO(this.networkAddressFactory);
            if (datagramIO == null) {
                this.logger.info("Configuration did not create a StreamServer for: {}", (Object)inetAddress);
                continue;
            }
            this.logger.debug("Init datagram I/O on address: {}", (Object)inetAddress);
            datagramIO.init(inetAddress, this.networkAddressFactory.getMulticastResponsePort(), this, this.getConfiguration().getDatagramProcessor());
            this.datagramIOs.put(inetAddress, datagramIO);
        }
        for (Map.Entry<InetAddress, StreamServer> entry : this.streamServers.entrySet()) {
            this.logger.debug("Starting stream server on address: {}", (Object)entry.getKey());
            this.getConfiguration().getStreamServerExecutorService().execute(entry.getValue());
        }
        for (Map.Entry<InetAddress, Runnable> entry : this.datagramIOs.entrySet()) {
            this.logger.debug("Starting datagram I/O on address: {}", (Object)entry.getKey());
            this.getConfiguration().getDatagramIOExecutor().execute(entry.getValue());
        }
    }

    protected void lock(Lock lock, int timeoutMilliseconds) throws RouterException {
        try {
            this.logger.trace("Trying to obtain lock with timeout milliseconds '{}': {}", (Object)timeoutMilliseconds, (Object)lock.getClass().getSimpleName());
            if (!lock.tryLock(timeoutMilliseconds, TimeUnit.MILLISECONDS)) {
                throw new RouterException("Router wasn't available exclusively after waiting " + timeoutMilliseconds + "ms, lock failed: " + lock.getClass().getSimpleName());
            }
            this.logger.trace("Acquired router lock: {}", (Object)lock.getClass().getSimpleName());
        }
        catch (InterruptedException e) {
            throw new RouterException("Interruption while waiting for exclusive access: " + lock.getClass().getSimpleName(), e);
        }
    }

    protected void lock(Lock lock) throws RouterException {
        this.lock(lock, this.getLockTimeoutMillis());
    }

    protected void unlock(Lock lock) {
        this.logger.trace("Releasing router lock: {}", (Object)lock.getClass().getSimpleName());
        lock.unlock();
    }

    protected int getLockTimeoutMillis() {
        return 6000;
    }
}

