/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.item;

import java.util.List;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.Res;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.container.Container;
import org.jupnp.support.model.item.AudioItem;
import org.jupnp.support.model.item.Item;

public class AudioBook
extends AudioItem {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.item.audioItem.audioBook");

    public AudioBook() {
        this.setClazz(CLASS);
    }

    public AudioBook(Item other) {
        super(other);
    }

    public AudioBook(String id, Container parent, String title, String creator, Res ... resource) {
        this(id, parent.getId(), title, creator, (Person)null, (Person)null, (String)null, resource);
    }

    public AudioBook(String id, Container parent, String title, String creator, String producer, String contributor, String date, Res ... resource) {
        this(id, parent.getId(), title, creator, new Person(producer), new Person(contributor), date, resource);
    }

    public AudioBook(String id, String parentID, String title, String creator, Person producer, Person contributor, String date, Res ... resource) {
        super(id, parentID, title, creator, resource);
        this.setClazz(CLASS);
        if (producer != null) {
            this.addProperty(new DIDLObject.Property.UPNP.PRODUCER(producer));
        }
        if (contributor != null) {
            this.addProperty(new DIDLObject.Property.DC.CONTRIBUTOR(contributor));
        }
        if (date != null) {
            this.setDate(date);
        }
    }

    public StorageMedium getStorageMedium() {
        return (StorageMedium)((Object)this.getFirstPropertyValue(DIDLObject.Property.UPNP.STORAGE_MEDIUM.class));
    }

    public AudioBook setStorageMedium(StorageMedium storageMedium) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.STORAGE_MEDIUM(storageMedium));
        return this;
    }

    public Person getFirstProducer() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.UPNP.PRODUCER.class);
    }

    public Person[] getProducers() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.PRODUCER.class);
        return list.toArray(new Person[list.size()]);
    }

    public AudioBook setProducers(Person[] persons) {
        this.removeProperties(DIDLObject.Property.UPNP.PRODUCER.class);
        for (Person p : persons) {
            this.addProperty(new DIDLObject.Property.UPNP.PRODUCER(p));
        }
        return this;
    }

    public Person getFirstContributor() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.DC.CONTRIBUTOR.class);
    }

    public Person[] getContributors() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.CONTRIBUTOR.class);
        return list.toArray(new Person[list.size()]);
    }

    public AudioBook setContributors(Person[] contributors) {
        this.removeProperties(DIDLObject.Property.DC.CONTRIBUTOR.class);
        for (Person p : contributors) {
            this.addProperty(new DIDLObject.Property.DC.CONTRIBUTOR(p));
        }
        return this;
    }

    public String getDate() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DATE.class);
    }

    public AudioBook setDate(String date) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DATE(date));
        return this;
    }
}

