/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.container;

import java.util.List;
import org.jupnp.support.model.DIDLObject;
import org.jupnp.support.model.Person;
import org.jupnp.support.model.PersonWithRole;
import org.jupnp.support.model.StorageMedium;
import org.jupnp.support.model.container.Container;

public class PlaylistContainer
extends Container {
    public static final DIDLObject.Class CLASS = new DIDLObject.Class("object.container.playlistContainer");

    public PlaylistContainer() {
        this.setClazz(CLASS);
    }

    public PlaylistContainer(Container other) {
        super(other);
    }

    public PlaylistContainer(String id, Container parent, String title, String creator, Integer childCount) {
        this(id, parent.getId(), title, creator, childCount);
    }

    public PlaylistContainer(String id, String parentID, String title, String creator, Integer childCount) {
        super(id, parentID, title, creator, CLASS, childCount);
    }

    public PersonWithRole getFirstArtist() {
        return (PersonWithRole)this.getFirstPropertyValue(DIDLObject.Property.UPNP.ARTIST.class);
    }

    public PersonWithRole[] getArtists() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.ARTIST.class);
        return list.toArray(new PersonWithRole[list.size()]);
    }

    public PlaylistContainer setArtists(PersonWithRole[] artists) {
        this.removeProperties(DIDLObject.Property.UPNP.ARTIST.class);
        for (PersonWithRole artist : artists) {
            this.addProperty(new DIDLObject.Property.UPNP.ARTIST(artist));
        }
        return this;
    }

    public String getFirstGenre() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.GENRE.class);
    }

    public String[] getGenres() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.GENRE.class);
        return list.toArray(new String[list.size()]);
    }

    public PlaylistContainer setGenres(String[] genres) {
        this.removeProperties(DIDLObject.Property.UPNP.GENRE.class);
        for (String genre : genres) {
            this.addProperty(new DIDLObject.Property.UPNP.GENRE(genre));
        }
        return this;
    }

    public String getDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DESCRIPTION.class);
    }

    public PlaylistContainer setDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DESCRIPTION(description));
        return this;
    }

    public String getLongDescription() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.UPNP.LONG_DESCRIPTION.class);
    }

    public PlaylistContainer setLongDescription(String description) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.LONG_DESCRIPTION(description));
        return this;
    }

    public Person getFirstProducer() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.UPNP.PRODUCER.class);
    }

    public Person[] getProducers() {
        List list = this.getPropertyValues(DIDLObject.Property.UPNP.PRODUCER.class);
        return list.toArray(new Person[list.size()]);
    }

    public PlaylistContainer setProducers(Person[] persons) {
        this.removeProperties(DIDLObject.Property.UPNP.PRODUCER.class);
        for (Person p : persons) {
            this.addProperty(new DIDLObject.Property.UPNP.PRODUCER(p));
        }
        return this;
    }

    public StorageMedium getStorageMedium() {
        return (StorageMedium)((Object)this.getFirstPropertyValue(DIDLObject.Property.UPNP.STORAGE_MEDIUM.class));
    }

    public PlaylistContainer setStorageMedium(StorageMedium storageMedium) {
        this.replaceFirstProperty(new DIDLObject.Property.UPNP.STORAGE_MEDIUM(storageMedium));
        return this;
    }

    public String getDate() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.DATE.class);
    }

    public PlaylistContainer setDate(String date) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.DATE(date));
        return this;
    }

    public String getFirstRights() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.RIGHTS.class);
    }

    public String[] getRights() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.RIGHTS.class);
        return list.toArray(new String[list.size()]);
    }

    public PlaylistContainer setRights(String[] rights) {
        this.removeProperties(DIDLObject.Property.DC.RIGHTS.class);
        for (String right : rights) {
            this.addProperty(new DIDLObject.Property.DC.RIGHTS(right));
        }
        return this;
    }

    public Person getFirstContributor() {
        return (Person)this.getFirstPropertyValue(DIDLObject.Property.DC.CONTRIBUTOR.class);
    }

    public Person[] getContributors() {
        List list = this.getPropertyValues(DIDLObject.Property.DC.CONTRIBUTOR.class);
        return list.toArray(new Person[list.size()]);
    }

    public PlaylistContainer setContributors(Person[] contributors) {
        this.removeProperties(DIDLObject.Property.DC.CONTRIBUTOR.class);
        for (Person p : contributors) {
            this.addProperty(new DIDLObject.Property.DC.CONTRIBUTOR(p));
        }
        return this;
    }

    public String getLanguage() {
        return (String)this.getFirstPropertyValue(DIDLObject.Property.DC.LANGUAGE.class);
    }

    public PlaylistContainer setLanguage(String language) {
        this.replaceFirstProperty(new DIDLObject.Property.DC.LANGUAGE(language));
        return this;
    }
}

