/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.contentdirectory;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.binding.annotations.UpnpAction;
import org.jupnp.binding.annotations.UpnpInputArgument;
import org.jupnp.binding.annotations.UpnpOutputArgument;
import org.jupnp.binding.annotations.UpnpService;
import org.jupnp.binding.annotations.UpnpServiceId;
import org.jupnp.binding.annotations.UpnpServiceType;
import org.jupnp.binding.annotations.UpnpStateVariable;
import org.jupnp.binding.annotations.UpnpStateVariables;
import org.jupnp.internal.compat.java.beans.PropertyChangeSupport;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.model.types.UnsignedIntegerFourBytes;
import org.jupnp.model.types.csv.CSV;
import org.jupnp.model.types.csv.CSVString;
import org.jupnp.support.contentdirectory.ContentDirectoryErrorCode;
import org.jupnp.support.contentdirectory.ContentDirectoryException;
import org.jupnp.support.contentdirectory.DIDLParser;
import org.jupnp.support.model.BrowseFlag;
import org.jupnp.support.model.BrowseResult;
import org.jupnp.support.model.DIDLContent;
import org.jupnp.support.model.SortCriterion;

@UpnpService(serviceId=@UpnpServiceId(value="ContentDirectory"), serviceType=@UpnpServiceType(value="ContentDirectory", version=1))
@UpnpStateVariables(value={@UpnpStateVariable(name="A_ARG_TYPE_ObjectID", sendEvents=false, datatype="string"), @UpnpStateVariable(name="A_ARG_TYPE_Result", sendEvents=false, datatype="string"), @UpnpStateVariable(name="A_ARG_TYPE_BrowseFlag", sendEvents=false, datatype="string", allowedValuesEnum=BrowseFlag.class), @UpnpStateVariable(name="A_ARG_TYPE_Filter", sendEvents=false, datatype="string"), @UpnpStateVariable(name="A_ARG_TYPE_SortCriteria", sendEvents=false, datatype="string"), @UpnpStateVariable(name="A_ARG_TYPE_Index", sendEvents=false, datatype="ui4"), @UpnpStateVariable(name="A_ARG_TYPE_Count", sendEvents=false, datatype="ui4"), @UpnpStateVariable(name="A_ARG_TYPE_UpdateID", sendEvents=false, datatype="ui4"), @UpnpStateVariable(name="A_ARG_TYPE_URI", sendEvents=false, datatype="uri"), @UpnpStateVariable(name="A_ARG_TYPE_SearchCriteria", sendEvents=false, datatype="string")})
public abstract class AbstractContentDirectoryService {
    public static final String CAPS_WILDCARD = "*";
    @UpnpStateVariable(sendEvents=false)
    private final CSV<String> searchCapabilities;
    @UpnpStateVariable(sendEvents=false)
    private final CSV<String> sortCapabilities;
    @UpnpStateVariable(sendEvents=true, defaultValue="0", eventMaximumRateMilliseconds=200)
    private UnsignedIntegerFourBytes systemUpdateID = new UnsignedIntegerFourBytes(0L);
    protected final PropertyChangeSupport propertyChangeSupport;

    protected AbstractContentDirectoryService() {
        this(new ArrayList<String>(), new ArrayList<String>(), null);
    }

    protected AbstractContentDirectoryService(List<String> searchCapabilities, List<String> sortCapabilities) {
        this(searchCapabilities, sortCapabilities, null);
    }

    protected AbstractContentDirectoryService(List<String> searchCapabilities, List<String> sortCapabilities, PropertyChangeSupport propertyChangeSupport) {
        this.propertyChangeSupport = propertyChangeSupport != null ? propertyChangeSupport : new PropertyChangeSupport(this);
        this.searchCapabilities = new CSVString();
        this.searchCapabilities.addAll(searchCapabilities);
        this.sortCapabilities = new CSVString();
        this.sortCapabilities.addAll(sortCapabilities);
    }

    @UpnpAction(out={@UpnpOutputArgument(name="SearchCaps")})
    public CSV<String> getSearchCapabilities() {
        return this.searchCapabilities;
    }

    @UpnpAction(out={@UpnpOutputArgument(name="SortCaps")})
    public CSV<String> getSortCapabilities() {
        return this.sortCapabilities;
    }

    @UpnpAction(out={@UpnpOutputArgument(name="Id")})
    public synchronized UnsignedIntegerFourBytes getSystemUpdateID() {
        return this.systemUpdateID;
    }

    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.propertyChangeSupport;
    }

    protected synchronized void changeSystemUpdateID() {
        Long oldUpdateID = this.getSystemUpdateID().getValue();
        this.systemUpdateID.increment(true);
        this.getPropertyChangeSupport().firePropertyChange("SystemUpdateID", oldUpdateID, this.getSystemUpdateID().getValue());
    }

    @UpnpAction(out={@UpnpOutputArgument(name="Result", stateVariable="A_ARG_TYPE_Result", getterName="getResult"), @UpnpOutputArgument(name="NumberReturned", stateVariable="A_ARG_TYPE_Count", getterName="getCount"), @UpnpOutputArgument(name="TotalMatches", stateVariable="A_ARG_TYPE_Count", getterName="getTotalMatches"), @UpnpOutputArgument(name="UpdateID", stateVariable="A_ARG_TYPE_UpdateID", getterName="getContainerUpdateID")})
    public BrowseResult browse(@UpnpInputArgument(name="ObjectID", aliases={"ContainerID"}) String objectId, @UpnpInputArgument(name="BrowseFlag") String browseFlag, @UpnpInputArgument(name="Filter") String filter, @UpnpInputArgument(name="StartingIndex", stateVariable="A_ARG_TYPE_Index") UnsignedIntegerFourBytes firstResult, @UpnpInputArgument(name="RequestedCount", stateVariable="A_ARG_TYPE_Count") UnsignedIntegerFourBytes maxResults, @UpnpInputArgument(name="SortCriteria") String orderBy) throws ContentDirectoryException {
        SortCriterion[] orderByCriteria;
        try {
            orderByCriteria = SortCriterion.valueOf(orderBy);
        }
        catch (Exception e) {
            throw new ContentDirectoryException(ContentDirectoryErrorCode.UNSUPPORTED_SORT_CRITERIA, e.toString());
        }
        try {
            return this.browse(objectId, BrowseFlag.valueOrNullOf(browseFlag), filter, firstResult.getValue(), maxResults.getValue(), orderByCriteria);
        }
        catch (ContentDirectoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContentDirectoryException(ErrorCode.ACTION_FAILED, e.toString());
        }
    }

    public abstract BrowseResult browse(String var1, BrowseFlag var2, String var3, long var4, long var6, SortCriterion[] var8) throws ContentDirectoryException;

    @UpnpAction(out={@UpnpOutputArgument(name="Result", stateVariable="A_ARG_TYPE_Result", getterName="getResult"), @UpnpOutputArgument(name="NumberReturned", stateVariable="A_ARG_TYPE_Count", getterName="getCount"), @UpnpOutputArgument(name="TotalMatches", stateVariable="A_ARG_TYPE_Count", getterName="getTotalMatches"), @UpnpOutputArgument(name="UpdateID", stateVariable="A_ARG_TYPE_UpdateID", getterName="getContainerUpdateID")})
    public BrowseResult search(@UpnpInputArgument(name="ContainerID", stateVariable="A_ARG_TYPE_ObjectID") String containerId, @UpnpInputArgument(name="SearchCriteria") String searchCriteria, @UpnpInputArgument(name="Filter") String filter, @UpnpInputArgument(name="StartingIndex", stateVariable="A_ARG_TYPE_Index") UnsignedIntegerFourBytes firstResult, @UpnpInputArgument(name="RequestedCount", stateVariable="A_ARG_TYPE_Count") UnsignedIntegerFourBytes maxResults, @UpnpInputArgument(name="SortCriteria") String orderBy) throws ContentDirectoryException {
        SortCriterion[] orderByCriteria;
        try {
            orderByCriteria = SortCriterion.valueOf(orderBy);
        }
        catch (Exception e) {
            throw new ContentDirectoryException(ContentDirectoryErrorCode.UNSUPPORTED_SORT_CRITERIA, e.toString());
        }
        try {
            return this.search(containerId, searchCriteria, filter, firstResult.getValue(), maxResults.getValue(), orderByCriteria);
        }
        catch (ContentDirectoryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContentDirectoryException(ErrorCode.ACTION_FAILED, e.toString());
        }
    }

    public BrowseResult search(String containerId, String searchCriteria, String filter, long firstResult, long maxResults, SortCriterion[] orderBy) throws ContentDirectoryException {
        try {
            return new BrowseResult(new DIDLParser().generate(new DIDLContent()), 0L, 0L);
        }
        catch (Exception e) {
            throw new ContentDirectoryException(ErrorCode.ACTION_FAILED, e.toString());
        }
    }
}

