/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol.sync;

import java.net.URL;
import org.jupnp.UpnpService;
import org.jupnp.model.UnsupportedDataException;
import org.jupnp.model.action.ActionCancelledException;
import org.jupnp.model.action.ActionException;
import org.jupnp.model.action.ActionInvocation;
import org.jupnp.model.message.StreamResponseMessage;
import org.jupnp.model.message.UpnpResponse;
import org.jupnp.model.message.control.IncomingActionResponseMessage;
import org.jupnp.model.message.control.OutgoingActionRequestMessage;
import org.jupnp.model.meta.Service;
import org.jupnp.model.types.ErrorCode;
import org.jupnp.protocol.SendingSync;
import org.jupnp.transport.RouterException;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingAction
extends SendingSync<OutgoingActionRequestMessage, IncomingActionResponseMessage> {
    private final Logger logger = LoggerFactory.getLogger(SendingAction.class);
    protected final ActionInvocation actionInvocation;

    public SendingAction(UpnpService upnpService, ActionInvocation actionInvocation, URL controlURL) {
        super(upnpService, new OutgoingActionRequestMessage(actionInvocation, controlURL));
        this.actionInvocation = actionInvocation;
    }

    @Override
    protected IncomingActionResponseMessage executeSync() throws RouterException {
        return this.invokeRemote((OutgoingActionRequestMessage)this.getInputMessage());
    }

    protected IncomingActionResponseMessage invokeRemote(OutgoingActionRequestMessage requestMessage) throws RouterException {
        StreamResponseMessage streamResponse;
        IncomingActionResponseMessage responseMessage;
        block7: {
            Object device = ((Service)this.actionInvocation.getAction().getService()).getDevice();
            this.logger.trace("Sending outgoing action call '{}' to remote service of: {}", (Object)this.actionInvocation.getAction().getName(), device);
            responseMessage = null;
            try {
                streamResponse = this.sendRemoteRequest(requestMessage);
                if (streamResponse != null) break block7;
                this.logger.trace("No connection or no no response received, returning null");
                this.actionInvocation.setFailure(new ActionException(ErrorCode.ACTION_FAILED, "Connection error or no response received"));
                return null;
            }
            catch (ActionException e) {
                this.logger.trace("Remote action invocation failed, returning Internal Server Error message", e);
                this.actionInvocation.setFailure(e);
                if (responseMessage == null || !((UpnpResponse)responseMessage.getOperation()).isFailed()) {
                    return new IncomingActionResponseMessage(new UpnpResponse(UpnpResponse.Status.INTERNAL_SERVER_ERROR));
                }
                return responseMessage;
            }
        }
        responseMessage = new IncomingActionResponseMessage(streamResponse);
        if (responseMessage.isFailedNonRecoverable()) {
            this.logger.trace("Response was a non-recoverable failure: {}", (Object)responseMessage);
            throw new ActionException(ErrorCode.ACTION_FAILED, "Non-recoverable remote execution failure: " + ((UpnpResponse)responseMessage.getOperation()).getResponseDetails());
        }
        if (responseMessage.isFailedRecoverable()) {
            this.handleResponseFailure(responseMessage);
        } else {
            this.handleResponse(responseMessage);
        }
        return responseMessage;
    }

    protected StreamResponseMessage sendRemoteRequest(OutgoingActionRequestMessage requestMessage) throws ActionException, RouterException {
        try {
            this.logger.trace("Writing SOAP request body of: {}", (Object)requestMessage);
            this.getUpnpService().getConfiguration().getSoapActionProcessor().writeBody(requestMessage, this.actionInvocation);
            this.logger.trace("Sending SOAP body of message as stream to remote device");
            return this.getUpnpService().getRouter().send(requestMessage);
        }
        catch (RouterException e) {
            Throwable cause = Exceptions.unwrap(e);
            if (cause instanceof InterruptedException) {
                this.logger.trace("Sending action request message was interrupted", e);
                throw new ActionCancelledException((InterruptedException)cause);
            }
            throw e;
        }
        catch (UnsupportedDataException e) {
            this.logger.trace("Error writing SOAP body", e);
            throw new ActionException(ErrorCode.ACTION_FAILED, "Error writing request message. " + e.getMessage());
        }
    }

    protected void handleResponse(IncomingActionResponseMessage responseMsg) throws ActionException {
        try {
            this.logger.trace("Received response for outgoing call, reading SOAP response body: {}", (Object)responseMsg);
            this.getUpnpService().getConfiguration().getSoapActionProcessor().readBody(responseMsg, this.actionInvocation);
        }
        catch (UnsupportedDataException e) {
            this.logger.trace("Error reading SOAP body", e);
            throw new ActionException(ErrorCode.ACTION_FAILED, "Error reading SOAP response message. " + e.getMessage(), false);
        }
    }

    protected void handleResponseFailure(IncomingActionResponseMessage responseMsg) throws ActionException {
        try {
            this.logger.trace("Received response with Internal Server Error, reading SOAP failure message");
            this.getUpnpService().getConfiguration().getSoapActionProcessor().readBody(responseMsg, this.actionInvocation);
        }
        catch (UnsupportedDataException e) {
            this.logger.trace("Error reading SOAP body", e);
            throw new ActionException(ErrorCode.ACTION_FAILED, "Error reading SOAP response failure message. " + e.getMessage(), false);
        }
    }
}

