/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.protocol;

import org.jupnp.UpnpService;
import org.jupnp.transport.RouterException;
import org.jupnp.util.Exceptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SendingAsync
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(UpnpService.class);
    private final UpnpService upnpService;

    protected SendingAsync(UpnpService upnpService) {
        this.upnpService = upnpService;
    }

    public UpnpService getUpnpService() {
        return this.upnpService;
    }

    @Override
    public void run() {
        try {
            this.execute();
        }
        catch (Exception e) {
            Throwable cause = Exceptions.unwrap(e);
            if (cause instanceof InterruptedException) {
                this.logger.info("Interrupted protocol", e);
            }
            throw new RuntimeException("Fatal error while executing protocol '" + this.getClass().getSimpleName() + "'", e);
        }
    }

    protected abstract void execute() throws RouterException;

    public String toString() {
        return "(" + this.getClass().getSimpleName() + ")";
    }
}

