/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp;

import java.util.Map;
import org.jupnp.OSGiUpnpServiceConfiguration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(configurationPid={"org.jupnp"}, configurationPolicy=ConfigurationPolicy.REQUIRE)
public class OSGiUpnpServiceConfigurationEnabler {
    private final Logger logger = LoggerFactory.getLogger(OSGiUpnpServiceConfigurationEnabler.class);
    private static final String AUTO_ENABLE = "autoEnable";

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> config) {
        boolean autoEnable;
        Object value = config.get(AUTO_ENABLE);
        boolean bl = autoEnable = value == null || Boolean.parseBoolean(value.toString());
        if (autoEnable) {
            context.enableComponent(OSGiUpnpServiceConfiguration.class.getName());
            this.logger.info("{} enabled by {}", (Object)OSGiUpnpServiceConfiguration.class.getSimpleName(), (Object)OSGiUpnpServiceConfigurationEnabler.class);
        } else {
            this.logger.info("{} not enabled by {}", (Object)OSGiUpnpServiceConfiguration.class.getSimpleName(), (Object)OSGiUpnpServiceConfigurationEnabler.class);
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        context.disableComponent(OSGiUpnpServiceConfiguration.class.getName());
        this.logger.info("{} disabled by {}", (Object)OSGiUpnpServiceConfiguration.class.getSimpleName(), (Object)OSGiUpnpServiceConfigurationEnabler.class);
    }
}

