/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.utils.tree;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.Vector;
import org.jaudiotagger.utils.tree.MutableTreeNode;
import org.jaudiotagger.utils.tree.TreeNode;

public class DefaultMutableTreeNode<T>
implements Cloneable,
MutableTreeNode<T>,
Serializable {
    private static final long serialVersionUID = 7195119412898901913L;
    protected MutableTreeNode<T> parent = null;
    protected Vector<TreeNode<T>> children;
    protected transient T userObject;
    protected boolean allowsChildren;

    public static final <X> Enumeration<X> emptyEnumeration() {
        return new Enumeration<X>(){

            @Override
            public boolean hasMoreElements() {
                return false;
            }

            @Override
            public X nextElement() {
                throw new NoSuchElementException("No more elements");
            }
        };
    }

    public DefaultMutableTreeNode() {
        this(null);
    }

    public DefaultMutableTreeNode(T userObject) {
        this(userObject, true);
    }

    public DefaultMutableTreeNode(T userObject, boolean allowsChildren) {
        this.allowsChildren = allowsChildren;
        this.userObject = userObject;
    }

    @Override
    public void insert(MutableTreeNode<T> newChild, int childIndex) {
        if (!this.allowsChildren) {
            throw new IllegalStateException("node does not allow children");
        }
        if (newChild == null) {
            throw new IllegalArgumentException("new child is null");
        }
        if (this.isNodeAncestor(newChild)) {
            throw new IllegalArgumentException("new child is an ancestor");
        }
        MutableTreeNode oldParent = (MutableTreeNode)newChild.getParent();
        if (oldParent != null) {
            oldParent.remove(newChild);
        }
        newChild.setParent(this);
        if (this.children == null) {
            this.children = new Vector();
        }
        this.children.insertElementAt(newChild, childIndex);
    }

    @Override
    public void remove(int childIndex) {
        MutableTreeNode child = (MutableTreeNode)this.getChildAt(childIndex);
        this.children.removeElementAt(childIndex);
        child.setParent(null);
    }

    @Override
    public void setParent(MutableTreeNode<T> newParent) {
        this.parent = newParent;
    }

    @Override
    public TreeNode<T> getParent() {
        return this.parent;
    }

    @Override
    public TreeNode<T> getChildAt(int index) {
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("node has no children");
        }
        return this.children.elementAt(index);
    }

    @Override
    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    @Override
    public int getIndex(TreeNode<T> aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            return -1;
        }
        return this.children.indexOf(aChild);
    }

    @Override
    public Enumeration<TreeNode<T>> children() {
        if (this.children == null) {
            return DefaultMutableTreeNode.emptyEnumeration();
        }
        return this.children.elements();
    }

    public void setAllowsChildren(boolean allows) {
        if (allows != this.allowsChildren) {
            this.allowsChildren = allows;
            if (!this.allowsChildren) {
                this.removeAllChildren();
            }
        }
    }

    @Override
    public boolean getAllowsChildren() {
        return this.allowsChildren;
    }

    @Override
    public void setUserObject(T userObject) {
        this.userObject = userObject;
    }

    @Override
    public T getUserObject() {
        return this.userObject;
    }

    @Override
    public void removeFromParent() {
        MutableTreeNode parent = (MutableTreeNode)this.getParent();
        if (parent != null) {
            parent.remove(this);
        }
    }

    @Override
    public void remove(MutableTreeNode<T> aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        if (!this.isNodeChild(aChild)) {
            throw new IllegalArgumentException("argument is not a child");
        }
        this.remove(this.getIndex(aChild));
    }

    public void removeAllChildren() {
        for (int i = this.getChildCount() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    public void add(MutableTreeNode<T> newChild) {
        if (newChild != null && newChild.getParent() == this) {
            this.insert(newChild, this.getChildCount() - 1);
        } else {
            this.insert(newChild, this.getChildCount());
        }
    }

    public boolean isNodeAncestor(TreeNode<T> anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        TreeNode<T> ancestor = this;
        do {
            if (ancestor != anotherNode) continue;
            return true;
        } while ((ancestor = ancestor.getParent()) != null);
        return false;
    }

    public boolean isNodeDescendant(DefaultMutableTreeNode<T> anotherNode) {
        if (anotherNode == null) {
            return false;
        }
        return anotherNode.isNodeAncestor(this);
    }

    public TreeNode<T> getSharedAncestor(DefaultMutableTreeNode<T> aNode) {
        TreeNode<T> node2;
        TreeNode<T> node1;
        int diff;
        if (aNode == this) {
            return this;
        }
        if (aNode == null) {
            return null;
        }
        int level1 = this.getLevel();
        int level2 = aNode.getLevel();
        if (level2 > level1) {
            diff = level2 - level1;
            node1 = aNode;
            node2 = this;
        } else {
            diff = level1 - level2;
            node1 = this;
            node2 = aNode;
        }
        while (diff > 0) {
            node1 = node1.getParent();
            --diff;
        }
        do {
            if (node1 == node2) {
                return node1;
            }
            node1 = node1.getParent();
            node2 = node2.getParent();
        } while (node1 != null);
        if (node1 != null || node2 != null) {
            throw new Error("nodes should be null");
        }
        return null;
    }

    public boolean isNodeRelated(DefaultMutableTreeNode<T> aNode) {
        return aNode != null && this.getRoot() == aNode.getRoot();
    }

    public int getDepth() {
        TreeNode<T> last = null;
        Enumeration<TreeNode<T>> enum_ = this.breadthFirstEnumeration();
        while (enum_.hasMoreElements()) {
            last = enum_.nextElement();
        }
        if (last == null) {
            throw new Error("nodes should be null");
        }
        return ((DefaultMutableTreeNode)last).getLevel() - this.getLevel();
    }

    public int getLevel() {
        int levels = 0;
        TreeNode<T> ancestor = this;
        while ((ancestor = ancestor.getParent()) != null) {
            ++levels;
        }
        return levels;
    }

    public TreeNode<T>[] getPath() {
        return this.getPathToRoot(this, 0);
    }

    protected TreeNode<T>[] getPathToRoot(TreeNode<T> aNode, int depth) {
        TreeNode[] retNodes;
        if (aNode == null) {
            if (depth == 0) {
                return null;
            }
            retNodes = new TreeNode[depth];
        } else {
            retNodes = this.getPathToRoot(aNode.getParent(), ++depth);
            retNodes[retNodes.length - depth] = aNode;
        }
        return retNodes;
    }

    public Object[] getUserObjectPath() {
        TreeNode<T>[] realPath = this.getPath();
        Object[] retPath = new Object[realPath.length];
        for (int counter = 0; counter < realPath.length; ++counter) {
            retPath[counter] = ((DefaultMutableTreeNode)realPath[counter]).getUserObject();
        }
        return retPath;
    }

    public TreeNode<T> getRoot() {
        DefaultMutableTreeNode previous;
        TreeNode<T> ancestor = this;
        do {
            previous = ancestor;
        } while ((ancestor = ancestor.getParent()) != null);
        return previous;
    }

    public boolean isRoot() {
        return this.getParent() == null;
    }

    public DefaultMutableTreeNode<T> getNextNode() {
        if (this.getChildCount() == 0) {
            DefaultMutableTreeNode<T> nextSibling = this.getNextSibling();
            if (nextSibling == null) {
                DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)this.getParent();
                while (true) {
                    if (aNode == null) {
                        return null;
                    }
                    nextSibling = aNode.getNextSibling();
                    if (nextSibling != null) {
                        return nextSibling;
                    }
                    aNode = (DefaultMutableTreeNode)aNode.getParent();
                }
            }
            return nextSibling;
        }
        return (DefaultMutableTreeNode)this.getChildAt(0);
    }

    public DefaultMutableTreeNode<T> getPreviousNode() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        DefaultMutableTreeNode<T> previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            if (previousSibling.getChildCount() == 0) {
                return previousSibling;
            }
            return previousSibling.getLastLeaf();
        }
        return myParent;
    }

    public Enumeration<TreeNode<T>> preorderEnumeration() {
        return new PreorderEnumeration(this);
    }

    public Enumeration<TreeNode<T>> postorderEnumeration() {
        return new PostorderEnumeration(this);
    }

    public Enumeration<TreeNode<T>> breadthFirstEnumeration() {
        return new BreadthFirstEnumeration(this);
    }

    public Enumeration<TreeNode<T>> depthFirstEnumeration() {
        return this.postorderEnumeration();
    }

    public Enumeration<TreeNode<T>> pathFromAncestorEnumeration(TreeNode<T> ancestor) {
        return new PathBetweenNodesEnumeration<T>(ancestor, this);
    }

    public boolean isNodeChild(TreeNode<T> aNode) {
        boolean retval = aNode == null ? false : (this.getChildCount() == 0 ? false : aNode.getParent() == this);
        return retval;
    }

    public TreeNode<T> getFirstChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(0);
    }

    public TreeNode<T> getLastChild() {
        if (this.getChildCount() == 0) {
            throw new NoSuchElementException("node has no children");
        }
        return this.getChildAt(this.getChildCount() - 1);
    }

    public TreeNode<T> getChildAfter(TreeNode<T> aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int index = this.getIndex(aChild);
        if (index == -1) {
            throw new IllegalArgumentException("node is not a child");
        }
        if (index < this.getChildCount() - 1) {
            return this.getChildAt(index + 1);
        }
        return null;
    }

    public TreeNode<T> getChildBefore(TreeNode<T> aChild) {
        if (aChild == null) {
            throw new IllegalArgumentException("argument is null");
        }
        int index = this.getIndex(aChild);
        if (index == -1) {
            throw new IllegalArgumentException("argument is not a child");
        }
        if (index > 0) {
            return this.getChildAt(index - 1);
        }
        return null;
    }

    public boolean isNodeSibling(TreeNode<T> anotherNode) {
        boolean retval;
        if (anotherNode == null) {
            retval = false;
        } else if (anotherNode == this) {
            retval = true;
        } else {
            TreeNode<T> myParent = this.getParent();
            boolean bl = retval = myParent != null && myParent == anotherNode.getParent();
            if (retval && !((DefaultMutableTreeNode)this.getParent()).isNodeChild(anotherNode)) {
                throw new Error("sibling has different parent");
            }
        }
        return retval;
    }

    public int getSiblingCount() {
        TreeNode<T> myParent = this.getParent();
        if (myParent == null) {
            return 1;
        }
        return myParent.getChildCount();
    }

    public DefaultMutableTreeNode<T> getNextSibling() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        DefaultMutableTreeNode retval = myParent == null ? null : (DefaultMutableTreeNode)myParent.getChildAfter(this);
        if (retval != null && !this.isNodeSibling(retval)) {
            throw new Error("child of parent is not a sibling");
        }
        return retval;
    }

    public DefaultMutableTreeNode<T> getPreviousSibling() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        DefaultMutableTreeNode retval = myParent == null ? null : (DefaultMutableTreeNode)myParent.getChildBefore(this);
        if (retval != null && !this.isNodeSibling(retval)) {
            throw new Error("child of parent is not a sibling");
        }
        return retval;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public DefaultMutableTreeNode<T> getFirstLeaf() {
        DefaultMutableTreeNode node = this;
        while (!node.isLeaf()) {
            node = (DefaultMutableTreeNode)node.getFirstChild();
        }
        return node;
    }

    public DefaultMutableTreeNode<T> getLastLeaf() {
        DefaultMutableTreeNode node = this;
        while (!node.isLeaf()) {
            node = (DefaultMutableTreeNode)node.getLastChild();
        }
        return node;
    }

    public DefaultMutableTreeNode<T> getNextLeaf() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        DefaultMutableTreeNode<T> nextSibling = this.getNextSibling();
        if (nextSibling != null) {
            return nextSibling.getFirstLeaf();
        }
        return myParent.getNextLeaf();
    }

    public DefaultMutableTreeNode<T> getPreviousLeaf() {
        DefaultMutableTreeNode myParent = (DefaultMutableTreeNode)this.getParent();
        if (myParent == null) {
            return null;
        }
        DefaultMutableTreeNode<T> previousSibling = this.getPreviousSibling();
        if (previousSibling != null) {
            return previousSibling.getLastLeaf();
        }
        return myParent.getPreviousLeaf();
    }

    public int getLeafCount() {
        int count = 0;
        Enumeration<TreeNode<T>> enum_ = this.breadthFirstEnumeration();
        while (enum_.hasMoreElements()) {
            TreeNode<T> node = enum_.nextElement();
            if (!node.isLeaf()) continue;
            ++count;
        }
        if (count < 1) {
            throw new Error("tree has zero leaves");
        }
        return count;
    }

    public String toString() {
        if (this.userObject == null) {
            return null;
        }
        return this.userObject.toString();
    }

    public DefaultMutableTreeNode<T> clone() {
        DefaultMutableTreeNode newNode = null;
        try {
            newNode = (DefaultMutableTreeNode)super.clone();
            newNode.children = null;
            newNode.parent = null;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e.toString());
        }
        return newNode;
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        Object[] tValues = this.userObject != null && this.userObject instanceof Serializable ? new Object[]{"userObject", this.userObject} : new Object[]{};
        s.writeObject(tValues);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        Object[] tValues = (Object[])s.readObject();
        if (tValues.length > 0 && tValues[0].equals("userObject")) {
            this.userObject = tValues[1];
        }
    }

    final class PathBetweenNodesEnumeration<X>
    implements Enumeration<TreeNode<X>> {
        protected Stack<TreeNode<X>> stack;

        public PathBetweenNodesEnumeration(TreeNode<X> ancestor, TreeNode<X> descendant) {
            if (ancestor == null || descendant == null) {
                throw new IllegalArgumentException("argument is null");
            }
            this.stack = new Stack();
            this.stack.push(descendant);
            TreeNode<X> current = descendant;
            while (current != ancestor) {
                if ((current = current.getParent()) == null && descendant != ancestor) {
                    throw new IllegalArgumentException("node " + ancestor + " is not an ancestor of " + descendant);
                }
                this.stack.push(current);
            }
        }

        @Override
        public boolean hasMoreElements() {
            return this.stack.size() > 0;
        }

        @Override
        public TreeNode<X> nextElement() {
            try {
                return this.stack.pop();
            }
            catch (EmptyStackException e) {
                throw new NoSuchElementException("No more elements");
            }
        }
    }

    final class BreadthFirstEnumeration<X>
    implements Enumeration<TreeNode<X>> {
        protected Queue<Enumeration<TreeNode<X>>> queue;

        public BreadthFirstEnumeration(TreeNode<X> rootNode) {
            Vector<TreeNode<X>> v = new Vector<TreeNode<X>>(1);
            v.addElement(rootNode);
            this.queue = new Queue();
            this.queue.enqueue(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.queue.isEmpty() && this.queue.firstObject().hasMoreElements();
        }

        @Override
        public TreeNode<X> nextElement() {
            Enumeration<TreeNode<X>> enumer = this.queue.firstObject();
            TreeNode<X> node = enumer.nextElement();
            Enumeration<TreeNode<X>> children = node.children();
            if (!enumer.hasMoreElements()) {
                this.queue.dequeue();
            }
            if (children.hasMoreElements()) {
                this.queue.enqueue(children);
            }
            return node;
        }

        final class Queue<Y> {
            QNode<Y> head;
            QNode<Y> tail;

            Queue() {
            }

            public void enqueue(Y anObject) {
                if (this.head == null) {
                    this.tail = new QNode<Y>(anObject, null);
                    this.head = this.tail;
                } else {
                    this.tail.next = new QNode<Y>(anObject, null);
                    this.tail = this.tail.next;
                }
            }

            public Object dequeue() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                Object retval = this.head.object;
                QNode<Y> oldHead = this.head;
                this.head = this.head.next;
                if (this.head == null) {
                    this.tail = null;
                } else {
                    oldHead.next = null;
                }
                return retval;
            }

            public Y firstObject() {
                if (this.head == null) {
                    throw new NoSuchElementException("No more elements");
                }
                return (Y)this.head.object;
            }

            public boolean isEmpty() {
                return this.head == null;
            }

            final class QNode<Z> {
                public Z object;
                public QNode<Z> next;

                public QNode(Z object, QNode<Z> next) {
                    this.object = object;
                    this.next = next;
                }
            }
        }
    }

    final class PostorderEnumeration<X>
    implements Enumeration<TreeNode<X>> {
        protected TreeNode<X> root;
        protected Enumeration<TreeNode<X>> children;
        protected Enumeration<TreeNode<X>> subtree;

        public PostorderEnumeration(TreeNode<X> rootNode) {
            this.root = rootNode;
            this.children = this.root.children();
            this.subtree = DefaultMutableTreeNode.emptyEnumeration();
        }

        @Override
        public boolean hasMoreElements() {
            return this.root != null;
        }

        @Override
        public TreeNode<X> nextElement() {
            TreeNode<X> retval;
            if (this.subtree.hasMoreElements()) {
                retval = this.subtree.nextElement();
            } else if (this.children.hasMoreElements()) {
                this.subtree = new PostorderEnumeration<X>(this.children.nextElement());
                retval = this.subtree.nextElement();
            } else {
                retval = this.root;
                this.root = null;
            }
            return retval;
        }
    }

    final class PreorderEnumeration
    implements Enumeration<TreeNode<T>> {
        protected Stack<Enumeration<TreeNode<T>>> stack;

        public PreorderEnumeration(TreeNode<T> rootNode) {
            Vector v = new Vector(1);
            v.addElement(rootNode);
            this.stack = new Stack();
            this.stack.push(v.elements());
        }

        @Override
        public boolean hasMoreElements() {
            return !this.stack.empty() && this.stack.peek().hasMoreElements();
        }

        @Override
        public TreeNode<T> nextElement() {
            Enumeration enumer = this.stack.peek();
            TreeNode node = enumer.nextElement();
            Enumeration children = node.children();
            if (!enumer.hasMoreElements()) {
                this.stack.pop();
            }
            if (children.hasMoreElements()) {
                this.stack.push(children);
            }
            return node;
        }
    }
}

