/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.mp4;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.logging.Logger;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.mp4.atom.Mp4BoxHeader;
import org.jaudiotagger.tag.TagField;
import org.jaudiotagger.tag.mp4.Mp4FieldKey;
import org.jaudiotagger.tag.mp4.field.Mp4FieldType;

public abstract class Mp4TagField
implements TagField {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.tag.mp4");
    protected String id;
    protected Mp4BoxHeader parentHeader;

    protected Mp4TagField(String id) {
        this.id = id;
    }

    protected Mp4TagField(ByteBuffer data) throws UnsupportedEncodingException {
        this.build(data);
    }

    protected Mp4TagField(Mp4BoxHeader parentHeader, ByteBuffer data) throws UnsupportedEncodingException {
        this.parentHeader = parentHeader;
        this.build(data);
    }

    protected Mp4TagField(String id, ByteBuffer data) throws UnsupportedEncodingException {
        this(id);
        this.build(data);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void isBinary(boolean b) {
    }

    @Override
    public boolean isCommon() {
        return this.id.equals(Mp4FieldKey.ARTIST.getFieldName()) || this.id.equals(Mp4FieldKey.ALBUM.getFieldName()) || this.id.equals(Mp4FieldKey.TITLE.getFieldName()) || this.id.equals(Mp4FieldKey.TRACK.getFieldName()) || this.id.equals(Mp4FieldKey.DAY.getFieldName()) || this.id.equals(Mp4FieldKey.COMMENT.getFieldName()) || this.id.equals(Mp4FieldKey.GENRE.getFieldName());
    }

    protected byte[] getIdBytes() {
        return this.getId().getBytes(StandardCharsets.ISO_8859_1);
    }

    protected abstract byte[] getDataBytes() throws UnsupportedEncodingException;

    public abstract Mp4FieldType getFieldType();

    protected abstract void build(ByteBuffer var1) throws UnsupportedEncodingException;

    @Override
    public byte[] getRawContent() throws UnsupportedEncodingException {
        logger.fine("Getting Raw data for:" + this.getId());
        try {
            byte[] databox = this.getRawContentDataOnly();
            ByteArrayOutputStream outerbaos = new ByteArrayOutputStream();
            outerbaos.write(Utils.getSizeBEInt32(8 + databox.length));
            outerbaos.write(this.getId().getBytes(StandardCharsets.ISO_8859_1));
            outerbaos.write(databox);
            return outerbaos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public byte[] getRawContentDataOnly() throws UnsupportedEncodingException {
        logger.fine("Getting Raw data for:" + this.getId());
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] data = this.getDataBytes();
            baos.write(Utils.getSizeBEInt32(16 + data.length));
            baos.write("data".getBytes(StandardCharsets.ISO_8859_1));
            baos.write(new byte[]{0});
            baos.write(new byte[]{0, 0, (byte)this.getFieldType().getFileClassId()});
            baos.write(new byte[]{0, 0, 0, 0});
            baos.write(data);
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }
}

