/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.wav;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.IffHeaderChunk;

public class WavRIFFHeader {
    public static final String RIFF_SIGNATURE = "RIFF";
    public static final String WAVE_SIGNATURE = "WAVE";

    public static boolean isValidHeader(String loggingName, FileChannel fc) throws IOException, CannotReadException {
        if (fc.size() - fc.position() < (long)IffHeaderChunk.FORM_HEADER_LENGTH) {
            throw new CannotReadException(loggingName + ":This is not a WAV File (<12 bytes)");
        }
        ByteBuffer headerBuffer = Utils.readFileDataIntoBufferLE(fc, IffHeaderChunk.FORM_HEADER_LENGTH);
        if (Utils.readFourBytesAsChars(headerBuffer).equals(RIFF_SIGNATURE)) {
            IffHeaderChunk.logger.finer(loggingName + ":Header:File:Size:" + headerBuffer.getInt());
            if (Utils.readFourBytesAsChars(headerBuffer).equals(WAVE_SIGNATURE)) {
                return true;
            }
        }
        return false;
    }
}

