/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.iff;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.audio.iff.ChunkHeader;

public class IffHeaderChunk {
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.iff");
    public static int SIGNATURE_LENGTH = 4;
    public static int SIZE_LENGTH = 4;
    public static int TYPE_LENGTH = 4;
    public static int FORM_HEADER_LENGTH = SIGNATURE_LENGTH + SIZE_LENGTH + TYPE_LENGTH;

    public static void ensureOnEqualBoundary(RandomAccessFile raf, ChunkHeader chunkHeader) throws IOException {
        if (Utils.isOddLength(chunkHeader.getSize()) && raf.getFilePointer() < raf.length()) {
            logger.config("Skipping Byte because on odd boundary");
            raf.skipBytes(1);
        }
    }

    public static void ensureOnEqualBoundary(FileChannel fc, ChunkHeader chunkHeader) throws IOException {
        if (Utils.isOddLength(chunkHeader.getSize()) && fc.position() < fc.size()) {
            logger.config("Skipping Byte because on odd boundary");
            fc.position(fc.position() + 1L);
        }
    }
}

