/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac.metadatablock;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockData;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.audio.generic.Utils;

public class MetadataBlockDataStreamInfo
implements MetadataBlockData {
    public static final int STREAM_INFO_DATA_LENGTH = 34;
    public static Logger logger = Logger.getLogger("org.jaudiotagger.audio.flac.MetadataBlockDataStreamInfo");
    private int minBlockSize;
    private int maxBlockSize;
    private int minFrameSize;
    private int maxFrameSize;
    private int samplingRate;
    private int samplingRatePerChannel;
    private int bitsPerSample;
    private int noOfChannels;
    private int noOfSamples;
    private float trackLength;
    private String md5;
    private boolean isValid = true;
    private ByteBuffer rawdata;
    private static final char[] hexArray = "0123456789abcdef".toCharArray();

    public MetadataBlockDataStreamInfo(MetadataBlockHeader header, FileChannel fc) throws IOException {
        if (header.getDataLength() < 34) {
            this.isValid = false;
            throw new IOException("MetadataBlockDataStreamInfo HeaderDataSize is invalid:" + header.getDataLength());
        }
        this.rawdata = ByteBuffer.allocate(header.getDataLength());
        this.rawdata.order(ByteOrder.BIG_ENDIAN);
        int bytesRead = fc.read(this.rawdata);
        if (bytesRead < header.getDataLength()) {
            this.isValid = false;
            throw new IOException("Unable to read required number of bytes, read:" + bytesRead + ":required:" + header.getDataLength());
        }
        this.rawdata.flip();
        this.minBlockSize = Utils.u(this.rawdata.getShort());
        this.maxBlockSize = Utils.u(this.rawdata.getShort());
        this.minFrameSize = this.readThreeByteInteger(this.rawdata.get(), this.rawdata.get(), this.rawdata.get());
        this.maxFrameSize = this.readThreeByteInteger(this.rawdata.get(), this.rawdata.get(), this.rawdata.get());
        this.samplingRate = this.readSamplingRate();
        this.noOfChannels = this.readNoOfChannels();
        this.bitsPerSample = this.readBitsPerSample();
        this.noOfSamples = this.readTotalNumberOfSamples();
        this.md5 = this.readMd5();
        this.trackLength = (float)((double)this.noOfSamples / (double)this.samplingRate);
        this.samplingRatePerChannel = this.samplingRate / this.noOfChannels;
        this.rawdata.rewind();
    }

    private String readMd5() {
        char[] hexChars = new char[32];
        if (this.rawdata.limit() >= 34) {
            for (int i = 0; i < 16; ++i) {
                int v = this.rawdata.get(i + 18) & 0xFF;
                hexChars[i * 2] = hexArray[v >>> 4];
                hexChars[i * 2 + 1] = hexArray[v & 0xF];
            }
        }
        return new String(hexChars);
    }

    @Override
    public ByteBuffer getBytes() {
        return this.rawdata;
    }

    @Override
    public int getLength() {
        return this.rawdata.limit();
    }

    public String toString() {
        return "MinBlockSize:" + this.minBlockSize + "MaxBlockSize:" + this.maxBlockSize + "MinFrameSize:" + this.minFrameSize + "MaxFrameSize:" + this.maxFrameSize + "SampleRateTotal:" + this.samplingRate + "SampleRatePerChannel:" + this.samplingRatePerChannel + ":Channel number:" + this.noOfChannels + ":Bits per sample: " + this.bitsPerSample + ":TotalNumberOfSamples: " + this.noOfSamples + ":Length: " + this.trackLength;
    }

    public float getPreciseLength() {
        return this.trackLength;
    }

    public int getNoOfChannels() {
        return this.noOfChannels;
    }

    public int getSamplingRate() {
        return this.samplingRate;
    }

    public int getSamplingRatePerChannel() {
        return this.samplingRatePerChannel;
    }

    public String getEncodingType() {
        return "FLAC " + this.bitsPerSample + " bits";
    }

    public int getBitsPerSample() {
        return this.bitsPerSample;
    }

    public long getNoOfSamples() {
        return this.noOfSamples;
    }

    public String getMD5Signature() {
        return this.md5;
    }

    public boolean isValid() {
        return this.isValid;
    }

    private int readThreeByteInteger(byte b1, byte b2, byte b3) {
        int rate = (Utils.u(b1) << 16) + (Utils.u(b2) << 8) + Utils.u(b3);
        return rate;
    }

    private int readSamplingRate() {
        int rate = (Utils.u(this.rawdata.get(10)) << 12) + (Utils.u(this.rawdata.get(11)) << 4) + ((Utils.u(this.rawdata.get(12)) & 0xF0) >>> 4);
        return rate;
    }

    private int readNoOfChannels() {
        return ((Utils.u(this.rawdata.get(12)) & 0xE) >>> 1) + 1;
    }

    private int readBitsPerSample() {
        return ((Utils.u(this.rawdata.get(12)) & 1) << 4) + ((Utils.u(this.rawdata.get(13)) & 0xF0) >>> 4) + 1;
    }

    private int readTotalNumberOfSamples() {
        int nb = Utils.u(this.rawdata.get(17));
        nb += Utils.u(this.rawdata.get(16)) << 8;
        nb += Utils.u(this.rawdata.get(15)) << 16;
        nb += Utils.u(this.rawdata.get(14)) << 24;
        return nb += (Utils.u(this.rawdata.get(13)) & 0xF) << 32;
    }
}

