/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.dff;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.logging.Level;
import org.jaudiotagger.audio.dff.BaseChunk;
import org.jaudiotagger.audio.dff.ChnlChunk;
import org.jaudiotagger.audio.dff.CmprChunk;
import org.jaudiotagger.audio.dff.DitiChunk;
import org.jaudiotagger.audio.dff.DsdChunk;
import org.jaudiotagger.audio.dff.DstChunk;
import org.jaudiotagger.audio.dff.EndChunk;
import org.jaudiotagger.audio.dff.Frm8Chunk;
import org.jaudiotagger.audio.dff.FrteChunk;
import org.jaudiotagger.audio.dff.FsChunk;
import org.jaudiotagger.audio.dff.Id3Chunk;
import org.jaudiotagger.audio.dff.PropChunk;
import org.jaudiotagger.audio.dff.SndChunk;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.exceptions.InvalidChunkException;
import org.jaudiotagger.audio.generic.AudioFileReader2;
import org.jaudiotagger.audio.generic.GenericAudioHeader;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.tag.Tag;

public class DffFileReader
extends AudioFileReader2 {
    @Override
    protected GenericAudioHeader getEncodingInfo(Path file) throws CannotReadException, IOException {
        Throwable throwable = null;
        try (FileChannel fc = FileChannel.open(file, new OpenOption[0]);){
            Frm8Chunk frm8 = Frm8Chunk.readChunk(Utils.readFileDataIntoBufferLE(fc, 12));
            if (frm8 != null) {
                PropChunk prop;
                DsdChunk dsd = DsdChunk.readChunk(Utils.readFileDataIntoBufferLE(fc, 8));
                if (dsd == null) {
                    throw new CannotReadException(file + " Not a valid dff file. Missing 'DSD '  after 'FRM8' ");
                }
                while ((prop = PropChunk.readChunk(Utils.readFileDataIntoBufferLE(fc, 12))) == null) {
                }
                if (prop == null) {
                    throw new CannotReadException(file + " Not a valid dff file. Content does not have 'PROP'");
                }
                SndChunk snd = SndChunk.readChunk(Utils.readFileDataIntoBufferLE(fc, 4));
                if (snd == null) {
                    throw new CannotReadException(file + " Not a valid dff file. Missing 'SND '  after 'PROP' ");
                }
                BaseChunk chunk = null;
                FsChunk fs = null;
                ChnlChunk chnl = null;
                CmprChunk cmpr = null;
                DitiChunk diti = null;
                EndChunk end = null;
                DstChunk dst = null;
                FrteChunk frte = null;
                Id3Chunk id3 = null;
                while (true) {
                    try {
                        chunk = BaseChunk.readIdChunk(Utils.readFileDataIntoBufferLE(fc, 4));
                    }
                    catch (InvalidChunkException ex) {
                        continue;
                    }
                    if (chunk instanceof FsChunk) {
                        fs = (FsChunk)chunk;
                        fs.readDataChunch(fc);
                        continue;
                    }
                    if (chunk instanceof ChnlChunk) {
                        chnl = (ChnlChunk)chunk;
                        chnl.readDataChunch(fc);
                        continue;
                    }
                    if (chunk instanceof CmprChunk) {
                        cmpr = (CmprChunk)chunk;
                        cmpr.readDataChunch(fc);
                        continue;
                    }
                    if (chunk instanceof DitiChunk) {
                        diti = (DitiChunk)chunk;
                        diti.readDataChunch(fc);
                        continue;
                    }
                    if (chunk instanceof EndChunk) break;
                    if (chunk instanceof DstChunk) {
                        dst = (DstChunk)chunk;
                        dst.readDataChunch(fc);
                        try {
                            frte = (FrteChunk)BaseChunk.readIdChunk(Utils.readFileDataIntoBufferLE(fc, 4));
                        }
                        catch (InvalidChunkException ex) {
                            throw new CannotReadException(file + "Not a valid dft file. Missing 'FRTE' chunk");
                        }
                        if (frte == null) continue;
                        frte.readDataChunch(fc);
                        continue;
                    }
                    if (!(chunk instanceof Id3Chunk)) continue;
                    id3 = (Id3Chunk)chunk;
                    id3.readDataChunch(fc);
                }
                end = (EndChunk)chunk;
                end.readDataChunch(fc);
                if (chnl == null) {
                    throw new CannotReadException(file + " Not a valid dff file. Missing 'CHNL' chunk");
                }
                if (fs == null) {
                    throw new CannotReadException(file + " Not a valid dff file. Missing 'FS' chunk");
                }
                if (dst != null && frte == null) {
                    throw new CannotReadException(file + " Not a valid dst file. Missing 'FRTE' chunk");
                }
                if (end == null && dst == null) {
                    throw new CannotReadException(file + " Not a valid dff file. Missing 'DSD' end chunk");
                }
                int bitsPerSample = 1;
                short channelNumber = chnl.getNumChannels();
                int samplingFreqency = fs.getSampleRate();
                long sampleCount = dst != null ? (long)(frte.getNumFrames() / frte.getRate() * samplingFreqency) : (end.getDataEnd() - end.getDataStart()) * (long)(8 / channelNumber);
                GenericAudioHeader genericAudioHeader = this.buildAudioHeader(channelNumber, samplingFreqency, sampleCount, bitsPerSample, dst != null);
                return genericAudioHeader;
            }
            try {
                throw new CannotReadException(file + " Not a valid dff file. Content does not start with 'FRM8'");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private GenericAudioHeader buildAudioHeader(int channelNumber, int samplingFreqency, long sampleCount, int bitsPerSample, boolean isDST) {
        GenericAudioHeader audioHeader = new GenericAudioHeader();
        audioHeader.setEncodingType("DFF");
        audioHeader.setBitRate(bitsPerSample * samplingFreqency * channelNumber);
        audioHeader.setBitsPerSample(bitsPerSample);
        audioHeader.setChannelNumber(channelNumber);
        audioHeader.setSamplingRate(samplingFreqency);
        audioHeader.setNoOfSamples(sampleCount);
        audioHeader.setPreciseLength((float)sampleCount / (float)samplingFreqency);
        audioHeader.setVariableBitRate(isDST);
        logger.log(Level.FINE, "Created audio header: " + audioHeader);
        return audioHeader;
    }

    @Override
    protected Tag getTag(Path path) throws CannotReadException, IOException {
        return null;
    }
}

