/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;
import org.jaudiotagger.audio.asf.data.AsfExtendedHeader;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkContainerReader;
import org.jaudiotagger.audio.asf.io.ChunkReader;
import org.jaudiotagger.audio.asf.util.Utils;

public class AsfExtHeaderReader
extends ChunkContainerReader<AsfExtendedHeader> {
    private static final GUID[] APPLYING = new GUID[]{GUID.GUID_HEADER_EXTENSION};

    public AsfExtHeaderReader(List<Class<? extends ChunkReader>> toRegister, boolean readChunkOnce) {
        super(toRegister, readChunkOnce);
    }

    @Override
    public boolean canFail() {
        return false;
    }

    @Override
    protected AsfExtendedHeader createContainer(long streamPosition, BigInteger chunkLength, InputStream stream) throws IOException {
        Utils.readGUID(stream);
        Utils.readUINT16(stream);
        long extensionSize = Utils.readUINT32(stream);
        assert (extensionSize == 0L || extensionSize >= 24L);
        assert (chunkLength.subtract(BigInteger.valueOf(46L)).longValue() == extensionSize);
        return new AsfExtendedHeader(streamPosition, chunkLength);
    }

    @Override
    public GUID[] getApplyingIds() {
        return (GUID[])APPLYING.clone();
    }
}

