/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.io.ChunkModifier;
import org.jaudiotagger.audio.asf.io.CountingInputStream;
import org.jaudiotagger.audio.asf.io.ModificationResult;
import org.jaudiotagger.audio.asf.util.Utils;

public class AsfExtHeaderModifier
implements ChunkModifier {
    private final List<ChunkModifier> modifierList;

    public AsfExtHeaderModifier(List<ChunkModifier> modifiers) {
        assert (modifiers != null);
        this.modifierList = new ArrayList<ChunkModifier>(modifiers);
    }

    private void copyChunk(GUID guid, InputStream source, OutputStream destination) throws IOException {
        long chunkSize = Utils.readUINT64(source);
        destination.write(guid.getBytes());
        Utils.writeUINT64(chunkSize, destination);
        Utils.copy(source, destination, chunkSize - 24L);
    }

    @Override
    public boolean isApplicable(GUID guid) {
        return GUID.GUID_HEADER_EXTENSION.equals(guid);
    }

    @Override
    public ModificationResult modify(GUID guid, InputStream source, OutputStream destination) throws IOException {
        assert (GUID.GUID_HEADER_EXTENSION.equals(guid));
        long difference = 0L;
        ArrayList<ChunkModifier> modders = new ArrayList<ChunkModifier>(this.modifierList);
        HashSet<GUID> occuredGuids = new HashSet<GUID>();
        occuredGuids.add(guid);
        BigInteger chunkLen = Utils.readBig64(source);
        GUID reserved1 = Utils.readGUID(source);
        int reserved2 = Utils.readUINT16(source);
        long dataSize = Utils.readUINT32(source);
        assert (dataSize == 0L || dataSize >= 24L);
        assert (chunkLen.subtract(BigInteger.valueOf(46L)).longValue() == dataSize);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        CountingInputStream cis = new CountingInputStream(source);
        while (cis.getReadCount() < dataSize) {
            GUID curr = Utils.readGUID(cis);
            boolean handled = false;
            for (int i = 0; i < modders.size() && !handled; ++i) {
                if (!((ChunkModifier)modders.get(i)).isApplicable(curr)) continue;
                ModificationResult modRes = ((ChunkModifier)modders.get(i)).modify(curr, cis, bos);
                difference += modRes.getByteDifference();
                occuredGuids.addAll(modRes.getOccuredGUIDs());
                modders.remove(i);
                handled = true;
            }
            if (handled) continue;
            occuredGuids.add(curr);
            this.copyChunk(curr, cis, bos);
        }
        for (ChunkModifier curr : modders) {
            ModificationResult result = curr.modify(null, null, bos);
            difference += result.getByteDifference();
            occuredGuids.addAll(result.getOccuredGUIDs());
        }
        destination.write(GUID.GUID_HEADER_EXTENSION.getBytes());
        Utils.writeUINT64(chunkLen.add(BigInteger.valueOf(difference)).longValue(), destination);
        destination.write(reserved1.getBytes());
        Utils.writeUINT16(reserved2, destination);
        Utils.writeUINT32(dataSize + difference, destination);
        destination.write(bos.toByteArray());
        return new ModificationResult(0, difference, occuredGuids);
    }
}

