/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.util.Utils;
import org.jaudiotagger.logging.ErrorMessage;

public enum ContainerType {
    CONTENT_BRANDING(GUID.GUID_CONTENT_BRANDING, 32, false, false, false, false),
    CONTENT_DESCRIPTION(GUID.GUID_CONTENTDESCRIPTION, 16, false, false, false, false),
    EXTENDED_CONTENT(GUID.GUID_EXTENDED_CONTENT_DESCRIPTION, 16, false, false, false, false),
    METADATA_LIBRARY_OBJECT(GUID.GUID_METADATA_LIBRARY, 32, true, true, true, true),
    METADATA_OBJECT(GUID.GUID_METADATA, 16, false, true, false, true);

    private final GUID containerGUID;
    private final boolean guidEnabled;
    private final boolean languageEnabled;
    private final BigInteger maximumDataLength;
    private final boolean multiValued;
    private final long perfMaxDataLen;
    private final boolean streamEnabled;

    public static boolean areInCorrectOrder(ContainerType low, ContainerType high) {
        List<ContainerType> asList = Arrays.asList(ContainerType.getOrdered());
        return asList.indexOf((Object)low) <= asList.indexOf((Object)high);
    }

    public static ContainerType[] getOrdered() {
        return new ContainerType[]{CONTENT_DESCRIPTION, CONTENT_BRANDING, EXTENDED_CONTENT, METADATA_OBJECT, METADATA_LIBRARY_OBJECT};
    }

    private ContainerType(GUID guid, int maxDataLenBits, boolean guidAllowed, boolean stream, boolean language, boolean multiValue) {
        this.containerGUID = guid;
        this.maximumDataLength = BigInteger.valueOf(2L).pow(maxDataLenBits).subtract(BigInteger.ONE);
        this.perfMaxDataLen = this.maximumDataLength.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) <= 0 ? this.maximumDataLength.longValue() : -1L;
        this.guidEnabled = guidAllowed;
        this.streamEnabled = stream;
        this.languageEnabled = language;
        this.multiValued = multiValue;
    }

    public void assertConstraints(String name, byte[] data, int type, int stream, int language) {
        RuntimeException result = this.checkConstraints(name, data, type, stream, language);
        if (result != null) {
            throw result;
        }
    }

    public RuntimeException checkConstraints(String name, byte[] data, int type, int stream, int language) {
        IllegalArgumentException result = null;
        if (name == null || data == null) {
            result = new IllegalArgumentException("Arguments must not be null.");
        } else if (!Utils.isStringLengthValidNullSafe(name)) {
            result = new IllegalArgumentException(ErrorMessage.WMA_LENGTH_OF_STRING_IS_TOO_LARGE.getMsg(name.length()));
        }
        if (result == null && !this.isWithinValueRange(data.length)) {
            result = new IllegalArgumentException(ErrorMessage.WMA_LENGTH_OF_DATA_IS_TOO_LARGE.getMsg(data.length, this.getMaximumDataLength(), this.getContainerGUID().getDescription()));
        }
        if (result == null && (stream < 0 || stream > 127 || !this.isStreamNumberEnabled() && stream != 0)) {
            String streamAllowed = this.isStreamNumberEnabled() ? "0 to 127" : "0";
            result = new IllegalArgumentException(ErrorMessage.WMA_INVALID_STREAM_REFERNCE.getMsg(stream, streamAllowed, this.getContainerGUID().getDescription()));
        }
        if (result == null && type == 6 && !this.isGuidEnabled()) {
            result = new IllegalArgumentException(ErrorMessage.WMA_INVALID_GUID_USE.getMsg(this.getContainerGUID().getDescription()));
        }
        if (result == null && (language != 0 && !this.isLanguageEnabled() || language < 0 || language >= 127)) {
            String langAllowed = this.isStreamNumberEnabled() ? "0 to 126" : "0";
            result = new IllegalArgumentException(ErrorMessage.WMA_INVALID_LANGUAGE_USE.getMsg(language, this.getContainerGUID().getDescription(), langAllowed));
        }
        if (result == null && this == CONTENT_DESCRIPTION && type != 0) {
            result = new IllegalArgumentException(ErrorMessage.WMA_ONLY_STRING_IN_CD.getMsg());
        }
        return result;
    }

    public GUID getContainerGUID() {
        return this.containerGUID;
    }

    public BigInteger getMaximumDataLength() {
        return this.maximumDataLength;
    }

    public boolean isGuidEnabled() {
        return this.guidEnabled;
    }

    public boolean isLanguageEnabled() {
        return this.languageEnabled;
    }

    public boolean isWithinValueRange(long value) {
        return (this.perfMaxDataLen == -1L || this.perfMaxDataLen >= value) && value >= 0L;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public boolean isStreamNumberEnabled() {
        return this.streamEnabled;
    }
}

