/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import net.pms.util.ByteRange;
import net.pms.util.Range;

public class TimeRange
implements Range {
    private Double start;
    private Double end;

    public TimeRange() {
    }

    public TimeRange(Double start, Double end) {
        this.start = start;
        this.end = end;
    }

    public Double getStart() {
        return this.start;
    }

    public double getStartOrZero() {
        return this.start != null ? this.start : 0.0;
    }

    public TimeRange setStart(Double start) {
        this.start = start;
        return this;
    }

    public void rewindStart(double amount) {
        if (this.start != null) {
            this.start = this.start > amount ? Double.valueOf(this.start - amount) : Double.valueOf(0.0);
        }
    }

    public Double getEnd() {
        return this.end;
    }

    public double getEndOrZero() {
        return this.end != null ? this.end : 0.0;
    }

    public TimeRange setEnd(Double end) {
        this.end = end;
        return this;
    }

    public ByteRange createScaledRange(long scale) {
        return new ByteRange(this.start != null ? Long.valueOf((long)((double)scale * this.start)) : null, this.end != null ? Long.valueOf((long)((double)scale * this.end)) : null);
    }

    private void limitTime(TimeRange range) {
        if (range.start != null) {
            if (this.start != null) {
                this.start = Math.max(this.start, range.start);
            }
            if (this.end != null) {
                this.end = Math.max(this.end, range.start);
            }
        }
        if (range.end != null) {
            if (this.start != null) {
                this.start = Math.min(this.start, range.end);
            }
            if (this.end != null) {
                this.end = Math.min(this.end, range.end);
            }
        }
    }

    public String toString() {
        return "TimeRange [start=" + this.start + ", end=" + this.end + "]";
    }

    @Override
    public void limit(Range range) {
        this.limitTime((TimeRange)range);
    }

    @Override
    public boolean isStartOffsetAvailable() {
        return this.start != null;
    }

    @Override
    public boolean isEndLimitAvailable() {
        return this.end != null;
    }

    @Override
    public double getDuration() {
        return this.isStartOffsetAvailable() ? this.end - this.start : this.getEndOrZero();
    }

    @Override
    public ByteRange asByteRange() {
        throw new RuntimeException("Unable to convert to ByteRange:" + String.valueOf(this));
    }

    @Override
    public TimeRange createTimeRange() {
        return new TimeRange(this.start, this.end);
    }
}

