/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import net.pms.PMS;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempFileMgr {
    private static final Logger LOGGER = LoggerFactory.getLogger(TempFileMgr.class);
    private static final int DEFAULT_CLEAN_TIME = 1209600000;
    private static final int INTERVAL = 86400000;
    private final HashMap<File, Integer> files = new HashMap();

    public TempFileMgr() {
        this.parseCleanFile();
    }

    public void add(File f) {
        this.add(f, 1209600000);
    }

    public void add(File f, String str) {
        try {
            this.add(f, Integer.parseInt(str));
        }
        catch (NumberFormatException e) {
            this.add(f);
        }
    }

    public void add(File f, int cleanTime) {
        this.files.put(f, cleanTime);
        try {
            this.dumpFile();
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while trying to add \"{}\" to temporary file management: {}", (Object)f.getAbsolutePath(), (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    private void scan() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<File, Integer>> it = this.files.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<File, Integer> entry = it.next();
            if (!entry.getKey().exists()) {
                it.remove();
                continue;
            }
            if (now - entry.getKey().lastModified() <= (long)entry.getValue().intValue()) continue;
            it.remove();
            if (entry.getKey().delete()) continue;
            LOGGER.warn("Failed to delete temporary file \"{}\"", (Object)entry.getKey().getAbsolutePath());
        }
        try {
            this.dumpFile();
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while trying to write the temporary file management file: {}", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public void schedule() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                TempFileMgr.this.scan();
            }
        };
        Timer t = new Timer();
        t.scheduleAtFixedRate(task, 0L, 86400000L);
    }

    private static File cleanFile() {
        return new File(PMS.getConfiguration().getDataFile("UMS.tmpmgr"));
    }

    private void parseCleanFile() {
        File f = TempFileMgr.cleanFile();
        if (!f.exists()) {
            return;
        }
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), StandardCharsets.UTF_8));){
            String str;
            while ((str = in.readLine()) != null) {
                if (StringUtils.isEmpty(str) || str.startsWith("#")) continue;
                String[] tmp = str.split(",");
                if (tmp.length > 1) {
                    this.add(new File(tmp[0]), tmp[1]);
                    continue;
                }
                this.add(new File(tmp[0]));
            }
        }
        catch (IOException e) {
            LOGGER.error("An error occurred while trying to read the temporary file management file \"{}\": {}", (Object)f.getAbsolutePath(), (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    private void dumpFile() throws IOException {
        try (FileOutputStream out = new FileOutputStream(TempFileMgr.cleanFile());){
            Date now = new Date();
            String n = "## " + now.toString() + "\n";
            out.write("#########\n".getBytes(StandardCharsets.UTF_8));
            out.write(n.getBytes(StandardCharsets.UTF_8));
            for (Map.Entry<File, Integer> entry : this.files.entrySet()) {
                String str = entry.getKey().getAbsolutePath() + "," + String.valueOf(entry.getValue()) + "\n";
                out.write(str.getBytes(StandardCharsets.UTF_8));
            }
            out.flush();
        }
    }
}

