/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskRunner {
    static final Logger LOGGER = LoggerFactory.getLogger(TaskRunner.class);
    private static TaskRunner instance;
    private final ExecutorService executors = Executors.newCachedThreadPool(new ThreadFactory(){
        int counter = 0;

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(r, "background-task-" + this.counter++);
            t.setDaemon(true);
            return t;
        }
    });
    private final Map<String, Integer> counters = new HashMap<String, Integer>();
    private final Map<String, Lock> uniquenessLock = new HashMap<String, Lock>();

    public static synchronized TaskRunner getInstance() {
        if (instance == null) {
            instance = new TaskRunner();
        }
        return instance;
    }

    public void submit(Runnable runnable) {
        this.executors.execute(runnable);
    }

    public <X> Future<X> submit(Callable<X> call) {
        return this.executors.submit(call);
    }

    public void submitNamed(String name, Runnable runnable) {
        this.submitNamed(name, false, runnable);
    }

    public void submitNamed(String name, boolean singletonTask, Runnable runnable) {
        this.submit(() -> {
            String prevName = Thread.currentThread().getName();
            boolean locked = false;
            try {
                if (singletonTask) {
                    if (this.getLock(name).tryLock()) {
                        locked = true;
                        LOGGER.debug("singleton task " + name + " started");
                    } else {
                        locked = false;
                        LOGGER.debug("singleton task '" + name + "' already running, exiting");
                        return;
                    }
                }
                Thread.currentThread().setName(prevName + "-" + name + "(" + this.getAndIncr(name) + ")");
                LOGGER.debug("task started");
                runnable.run();
                LOGGER.debug("task ended");
            }
            finally {
                if (locked) {
                    this.getLock(name).unlock();
                }
                Thread.currentThread().setName(prevName);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock getLock(String name) {
        Map<String, Lock> map = this.uniquenessLock;
        synchronized (map) {
            Lock lk = this.uniquenessLock.get(name);
            if (lk == null) {
                lk = new ReentrantLock();
                this.uniquenessLock.put(name, lk);
            }
            return lk;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAndIncr(String name) {
        Map<String, Integer> map = this.counters;
        synchronized (map) {
            Integer val = this.counters.get(name);
            int newVal = val == null ? 0 : val + 1;
            this.counters.put(name, newVal);
            return newVal;
        }
    }

    public void shutdown() {
        this.executors.shutdown();
    }

    public boolean isTerminated() {
        return this.executors.isTerminated();
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executors.awaitTermination(timeout, unit);
    }
}

