/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;

public class SimpleThreadFactory
implements ThreadFactory {
    private static final AtomicInteger POOL_NUMBER = new AtomicInteger(1);
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final ThreadGroup group;

    public SimpleThreadFactory(String name) {
        this(name, null, 10, false);
    }

    public SimpleThreadFactory(String name, String groupName) {
        this(name, groupName, 10, false);
    }

    public SimpleThreadFactory(String name, String groupName, int maxPriority) {
        this(name, groupName, maxPriority, false);
    }

    public SimpleThreadFactory(String name, boolean logPoolNumber) {
        this(name, null, 10, logPoolNumber);
    }

    public SimpleThreadFactory(String name, String groupName, boolean logPoolNumber) {
        this(name, groupName, 10, logPoolNumber);
    }

    public SimpleThreadFactory(String name, String groupName, int maxPriority, boolean logPoolNumber) {
        if (StringUtils.isBlank(name)) {
            throw new IllegalArgumentException("name cannot be blank");
        }
        if (StringUtils.isNotBlank(groupName)) {
            this.group = new ThreadGroup(groupName);
            this.group.setMaxPriority(maxPriority);
        } else {
            this.group = null;
        }
        this.namePrefix = logPoolNumber ? name + " " + POOL_NUMBER.getAndIncrement() + "-" : name + " ";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t.isDaemon()) {
            t.setDaemon(false);
        }
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        return t;
    }
}

