/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public class LoggableInputStream
extends InputStream {
    protected static final int MAX_SKIP_BUFFER_SIZE = 2048;
    protected final Charset logCharset;
    protected final InputStream inputStream;
    protected final ByteArrayOutputStream logStream = new ByteArrayOutputStream();
    protected int position;
    protected int readPosition;
    protected int markPosition;

    public LoggableInputStream(InputStream inputStream) {
        this(inputStream, null);
    }

    public LoggableInputStream(InputStream inputStream, Charset logCharset) {
        this.inputStream = inputStream;
        this.logCharset = logCharset == null ? StandardCharsets.ISO_8859_1 : logCharset;
    }

    @Override
    public int read() throws IOException {
        if (this.inputStream == null) {
            return -1;
        }
        int result = this.inputStream.read();
        if (result >= 0) {
            if (this.position == this.readPosition) {
                this.logStream.write(result);
                ++this.readPosition;
            }
            ++this.position;
        }
        return result;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.inputStream == null) {
            return -1;
        }
        int numRead = this.inputStream.read(b, off, len);
        if (numRead > 0) {
            if (this.position == this.readPosition) {
                this.logStream.write(b, off, numRead);
                this.readPosition += numRead;
            } else if (this.position + numRead > this.readPosition) {
                int count = this.position + numRead - this.readPosition;
                this.logStream.write(b, off + numRead - count, count);
                this.readPosition += count;
            }
            this.position += numRead;
        }
        return numRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.inputStream == null) {
            return -1;
        }
        int numRead = this.inputStream.read(b);
        if (numRead > 0) {
            if (this.position == this.readPosition) {
                this.logStream.write(b, 0, numRead);
                this.readPosition += numRead;
            } else if (this.position + numRead > this.readPosition) {
                int count = this.position + numRead - this.readPosition;
                this.logStream.write(b, numRead - count, count);
                this.readPosition += count;
            }
            this.position += numRead;
        }
        return numRead;
    }

    @Override
    public int available() throws IOException {
        if (this.inputStream == null) {
            return 0;
        }
        return this.inputStream.available();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this.inputStream == null) {
            return 0L;
        }
        long remaining = n;
        if (n <= 0L) {
            return 0L;
        }
        while (remaining > 0L && this.position < this.readPosition) {
            int count = Math.min(this.readPosition - this.position, (int)n);
            count = (int)this.inputStream.skip(count);
            remaining -= (long)count;
            this.position += count;
        }
        if (remaining > 0L) {
            int numRead;
            int size = (int)Math.min(2048L, remaining);
            byte[] skipBuffer = new byte[size];
            while (remaining > 0L && (numRead = this.inputStream.read(skipBuffer, 0, (int)Math.min((long)size, remaining))) >= 0) {
                if (numRead > 0) {
                    this.logStream.write(skipBuffer, 0, numRead);
                    this.position += numRead;
                    this.readPosition += numRead;
                }
                remaining -= (long)numRead;
            }
        }
        return n - remaining;
    }

    @Override
    public synchronized void mark(int readlimit) {
        if (this.inputStream == null) {
            return;
        }
        this.inputStream.mark(readlimit);
        this.markPosition = this.position;
    }

    @Override
    public boolean markSupported() {
        if (this.inputStream == null) {
            return false;
        }
        return this.inputStream.markSupported();
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.inputStream == null) {
            return;
        }
        this.inputStream.reset();
        this.position = this.markPosition;
    }

    @Override
    public void close() throws IOException {
        if (this.inputStream != null) {
            this.inputStream.close();
        }
    }

    public byte[] getReadBytes() {
        return this.logStream.toByteArray();
    }

    public String toString() {
        try {
            return this.logStream.toString(this.logCharset.name());
        }
        catch (UnsupportedEncodingException e) {
            return "UnsupportedEncodingException: " + e.getMessage();
        }
    }
}

