/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.Messages;
import net.pms.PMS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Languages {
    private static final int MINIMUM_TRANSLATE_PCT = 20;
    private static final int RECOMMENDED_TRANSLATE_PCT = 90;
    private static final int RECOMMENDED_APPROVED_PCT = 85;
    private static final Logger LOGGER = LoggerFactory.getLogger(Languages.class);
    private static final String[] UMS_BCP47_CODES = new String[]{"af", "ar", "bn", "pt-BR", "bg", "ca", "zh-Hans", "zh-Hant", "hr", "cs", "da", "nl", "en-GB", "en-US", "et", "fi", "fr", "de", "el", "iw", "hu", "is", "it", "ja", "ko", "no", "fa", "pl", "pt", "ro", "ru", "sr", "sk", "sl", "es", "sv", "th", "tr", "uk", "vi"};
    private static final HashMap<String, TranslationStatistics> TRANSLATIONS_STATISTICS = new HashMap((int)Math.round((double)UMS_BCP47_CODES.length * 1.34));
    private static final List<LanguageEntry> SORTED_LANGUAGES = new ArrayList<LanguageEntry>();
    private static Locale lastpreferredLocale = null;

    private Languages() {
    }

    private static String localeToLanguageTag(Locale locale) {
        if (locale == null) {
            return null;
        }
        String languageTag = locale.getLanguage();
        if (languageTag != null && !languageTag.isEmpty()) {
            switch (languageTag) {
                case "en": {
                    if (locale.getCountry().equalsIgnoreCase("GB")) {
                        return "en-GB";
                    }
                    return "en-US";
                }
                case "pt": {
                    if (locale.getCountry().equalsIgnoreCase("BR")) {
                        return "pt-BR";
                    }
                    return "pt";
                }
                case "nb": 
                case "nn": {
                    return "no";
                }
                case "cmn": 
                case "zh": {
                    if (locale.getScript().equalsIgnoreCase("Hans")) {
                        return "zh-Hans";
                    }
                    if (locale.getCountry().equalsIgnoreCase("CN") || locale.getCountry().equalsIgnoreCase("SG")) {
                        return "zh-Hans";
                    }
                    return "zh-Hant";
                }
            }
            return languageTag;
        }
        return null;
    }

    private static String languageTagToUMSLanguageTag(String languageTag) {
        if (languageTag == null) {
            return null;
        }
        if (languageTag.isEmpty()) {
            return "";
        }
        switch (languageTag.toLowerCase(Locale.US)) {
            case "en-gb": {
                return "en-GB";
            }
            case "pt-br": {
                return "pt-BR";
            }
            case "cmn-cn": 
            case "cmn-sg": 
            case "cmn-hans": 
            case "zh-cn": 
            case "zh-sg": 
            case "zh-hans": {
                return "zh-Hans";
            }
        }
        if (languageTag.indexOf(45) > 0) {
            languageTag = languageTag.substring(0, languageTag.indexOf(45));
        }
        if (languageTag.equalsIgnoreCase("nb") || languageTag.equalsIgnoreCase("nn")) {
            return "no";
        }
        if (languageTag.equalsIgnoreCase("cmn") || languageTag.equalsIgnoreCase("zh")) {
            return "zh-Hant";
        }
        if (languageTag.equalsIgnoreCase("en")) {
            return "en-US";
        }
        return languageTag.toLowerCase(Locale.US);
    }

    private static void populateTranslationsStatistics() {
        if (TRANSLATIONS_STATISTICS.size() < 1) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Languages.class.getResourceAsStream("/resources/languages.properties"), StandardCharsets.UTF_8));){
                String line;
                Pattern pattern = Pattern.compile("^\\s*(?!#)\\b([^\\.=][^=]+[^\\.=])=(.*[^\\s])\\s*$");
                while ((line = reader.readLine()) != null) {
                    Matcher matcher = pattern.matcher(line);
                    if (!matcher.find()) continue;
                    try {
                        String[] path = matcher.group(1).split("\\.");
                        if (TRANSLATIONS_STATISTICS.containsKey(path[0])) {
                            translationStatistics = TRANSLATIONS_STATISTICS.get(path[0]);
                        } else {
                            translationStatistics = new TranslationStatistics();
                            TRANSLATIONS_STATISTICS.put(path[0], translationStatistics);
                        }
                        if (path.length < 2) {
                            LOGGER.debug("Failed to parse translation statistics line \"{}\": Illegal qualifier", (Object)line);
                            continue;
                        }
                        if (path[1].equalsIgnoreCase("name")) {
                            translationStatistics.name = matcher.group(2);
                            continue;
                        }
                        if (path[1].equalsIgnoreCase("phrases")) {
                            if (path.length < 3) {
                                translationStatistics.phrases = Integer.parseInt(matcher.group(2));
                                continue;
                            }
                            switch (path[2].toLowerCase(Locale.US)) {
                                case "approved": {
                                    translationStatistics.phrasesApproved = Integer.parseInt(matcher.group(2));
                                    break;
                                }
                                case "translated": {
                                    translationStatistics.phrasesTranslated = Integer.parseInt(matcher.group(2));
                                    break;
                                }
                                default: {
                                    LOGGER.debug("Failed to parse translation statistics line \"{}\": Illegal qualifier", (Object)line);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (path[1].equalsIgnoreCase("words")) {
                            if (path.length < 3) {
                                translationStatistics.words = Integer.parseInt(matcher.group(2));
                                continue;
                            }
                            switch (path[2].toLowerCase(Locale.US)) {
                                case "approved": {
                                    translationStatistics.wordsApproved = Integer.parseInt(matcher.group(2));
                                    break;
                                }
                                case "translated": {
                                    translationStatistics.wordsTranslated = Integer.parseInt(matcher.group(2));
                                    break;
                                }
                                default: {
                                    LOGGER.debug("Failed to parse translation statistics line \"{}\": Illegal qualifier", (Object)line);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (path[1].equalsIgnoreCase("progress")) {
                            if (path.length < 3) {
                                LOGGER.debug("Failed to parse translation statistics line \"{}\": Illegal qualifier", (Object)line);
                                continue;
                            }
                            switch (path[2].toLowerCase(Locale.US)) {
                                case "approved": {
                                    translationStatistics.approved = Integer.parseInt(matcher.group(2));
                                    break;
                                }
                                case "translated": {
                                    translationStatistics.translated = Integer.parseInt(matcher.group(2));
                                    break;
                                }
                                default: {
                                    LOGGER.debug("Failed to parse translation statistics line \"{}\": Illegal qualifier", (Object)line);
                                    break;
                                }
                            }
                            continue;
                        }
                        LOGGER.debug("Failed to parse translation statistics line \"{}\": Illegal qualifier", (Object)line);
                    }
                    catch (NumberFormatException e) {
                        LOGGER.debug("Failed to parse translation statistics line \"{}\": ", (Object)line, (Object)e.getMessage());
                    }
                }
            }
            catch (IOException e) {
                LOGGER.error("Error reading translations statistics: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
                TRANSLATIONS_STATISTICS.clear();
            }
        }
    }

    private static LanguageEntry getSortedLanguageByTag(String tag) {
        for (LanguageEntry entry : SORTED_LANGUAGES) {
            if (!entry.tag.equalsIgnoreCase(tag)) continue;
            return entry;
        }
        return null;
    }

    private static LanguageEntry getSortedLanguageByLocale(Locale locale) {
        for (LanguageEntry entry : SORTED_LANGUAGES) {
            if (!entry.locale.equals(locale)) continue;
            return entry;
        }
        for (LanguageEntry entry : SORTED_LANGUAGES) {
            if (!entry.locale.getCountry().equals(locale.getCountry()) || !entry.locale.getLanguage().equals(locale.getLanguage())) continue;
            return entry;
        }
        for (LanguageEntry entry : SORTED_LANGUAGES) {
            if (!entry.locale.getLanguage().equals(locale.getLanguage())) continue;
            return entry;
        }
        if (!locale.getCountry().isEmpty()) {
            for (LanguageEntry entry : SORTED_LANGUAGES) {
                if (!entry.locale.getCountry().equals(locale.getCountry())) continue;
                return entry;
            }
        }
        return null;
    }

    private static boolean isRecommended(LanguageEntry language) {
        return language.tag.startsWith("en") || language.coveragePercent >= 90 || language.approvedPercent >= 85;
    }

    private static boolean isRecommended(TranslationStatistics languageStatistics) {
        return languageStatistics.translated >= 90 || languageStatistics.approved >= 85;
    }

    private static void createSortedList(Locale preferredLocale) {
        if (preferredLocale == null) {
            throw new IllegalArgumentException("preferredLocale cannot be null");
        }
        if (lastpreferredLocale == null || !lastpreferredLocale.equals(preferredLocale)) {
            LanguageEntry preferredLanguage;
            lastpreferredLocale = preferredLocale;
            SORTED_LANGUAGES.clear();
            Languages.populateTranslationsStatistics();
            for (String tag : UMS_BCP47_CODES) {
                LanguageEntry entry = new LanguageEntry();
                entry.tag = tag;
                entry.name = Messages.getString("Language." + tag, preferredLocale);
                entry.defaultname = Messages.getRootString("Language." + tag);
                entry.locale = Locale.forLanguageTag(tag);
                if (tag.equals("en-US")) {
                    entry.coveragePercent = 100;
                    entry.approvedPercent = 100;
                } else {
                    TranslationStatistics stats = TRANSLATIONS_STATISTICS.get(tag);
                    if (stats != null) {
                        if (entry.locale.getLanguage().equals("en") && stats.wordsTranslated > 0) {
                            entry.coveragePercent = 100;
                            entry.approvedPercent = 100;
                        } else {
                            entry.coveragePercent = stats.translated;
                            entry.approvedPercent = stats.approved;
                        }
                    } else {
                        entry.coveragePercent = 0;
                        entry.approvedPercent = 0;
                        LOGGER.debug("Warning: Could not find language statistics for {}", (Object)entry.name);
                    }
                }
                String country = entry.locale.getCountry();
                if ("".equals(country)) {
                    country = switch (entry.locale.getLanguage()) {
                        case "ca" -> "es";
                        case "cs" -> "CZ";
                        case "da" -> "DK";
                        case "el" -> "GR";
                        case "fa" -> "IR";
                        case "he" -> "IL";
                        case "ja" -> "JP";
                        case "ko" -> "KR";
                        case "uk" -> "UA";
                        case "zh" -> "cn";
                        default -> entry.locale.getLanguage();
                    };
                }
                entry.country = country;
                if (entry.coveragePercent < 20) continue;
                SORTED_LANGUAGES.add(entry);
            }
            Collections.sort(SORTED_LANGUAGES);
            LanguageEntry baseLanguage = Languages.getSortedLanguageByTag("en-US");
            if (baseLanguage == null) {
                throw new IllegalStateException("Languages.createSortedList encountered an impossible situation");
            }
            if (SORTED_LANGUAGES.remove(baseLanguage)) {
                SORTED_LANGUAGES.add(0, baseLanguage);
            }
            if ((preferredLanguage = Languages.getSortedLanguageByLocale(preferredLocale)) != null && !preferredLanguage.tag.equals("en-US")) {
                if (SORTED_LANGUAGES.remove(preferredLanguage) && Languages.isRecommended(preferredLanguage)) {
                    SORTED_LANGUAGES.add(0, preferredLanguage);
                } else {
                    SORTED_LANGUAGES.add(1, preferredLanguage);
                }
            }
            ArrayList<LanguageEntry> relatedLanguages = new ArrayList<LanguageEntry>();
            for (LanguageEntry entry : SORTED_LANGUAGES) {
                if (entry == baseLanguage || entry == preferredLanguage || (preferredLocale.getCountry().isEmpty() || !preferredLocale.getCountry().equals(entry.locale.getCountry())) && (preferredLocale.getLanguage().isEmpty() || !preferredLocale.getLanguage().equals(entry.locale.getLanguage()))) continue;
                relatedLanguages.add(entry);
            }
            if (!relatedLanguages.isEmpty()) {
                SORTED_LANGUAGES.removeAll(relatedLanguages);
                Collections.sort(relatedLanguages, new LanguageEntryCoverageComparator());
                SORTED_LANGUAGES.addAll(preferredLanguage == null || preferredLanguage.equals(baseLanguage) ? 1 : 2, relatedLanguages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, TranslationStatistics> getTranslationsStatistics() {
        HashMap<String, TranslationStatistics> hashMap = TRANSLATIONS_STATISTICS;
        synchronized (hashMap) {
            Languages.populateTranslationsStatistics();
            return TRANSLATIONS_STATISTICS;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean warnCoverage(String languageTag) {
        if (languageTag.startsWith("en")) {
            return false;
        }
        HashMap<String, TranslationStatistics> hashMap = TRANSLATIONS_STATISTICS;
        synchronized (hashMap) {
            Languages.populateTranslationsStatistics();
            TranslationStatistics stats = TRANSLATIONS_STATISTICS.get(languageTag);
            if (stats == null) {
                return true;
            }
            return !Languages.isRecommended(stats);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLanguageCoverage(String languageTag) {
        if (languageTag.startsWith("en")) {
            return 100;
        }
        HashMap<String, TranslationStatistics> hashMap = TRANSLATIONS_STATISTICS;
        synchronized (hashMap) {
            Languages.populateTranslationsStatistics();
            TranslationStatistics stats = TRANSLATIONS_STATISTICS.get(languageTag);
            if (stats == null) {
                return 0;
            }
            return stats.translated;
        }
    }

    public static boolean isValid(String languageTag) {
        if (languageTag != null && !languageTag.isEmpty()) {
            for (String code : UMS_BCP47_CODES) {
                if (!code.equalsIgnoreCase(languageTag)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isValid(Locale locale) {
        return Languages.isValid(Languages.localeToLanguageTag(locale));
    }

    public static boolean isCompatible(String languageTag) {
        return Languages.isValid(Languages.languageTagToUMSLanguageTag(languageTag));
    }

    public static String toLanguageTag(String languageTag) {
        if (languageTag != null && !languageTag.isEmpty()) {
            languageTag = Languages.languageTagToUMSLanguageTag(languageTag);
            for (String tag : UMS_BCP47_CODES) {
                if (!tag.equalsIgnoreCase(languageTag)) continue;
                return tag;
            }
        }
        return null;
    }

    public static String toLanguageTag(Locale locale) {
        if (locale != null) {
            return Languages.toLanguageTag(Languages.localeToLanguageTag(locale));
        }
        return null;
    }

    public static Locale toLocale(Locale locale) {
        String tag;
        if (locale != null && (tag = Languages.localeToLanguageTag(locale)) != null && Languages.isValid(tag)) {
            return Locale.forLanguageTag(tag);
        }
        return null;
    }

    public static Locale toLocale(String languageTag) {
        String tag;
        if (languageTag != null && Languages.isValid(tag = Languages.languageTagToUMSLanguageTag(languageTag))) {
            return Locale.forLanguageTag(tag);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLanguageTags(Locale preferredLocale) {
        HashMap<String, TranslationStatistics> hashMap = TRANSLATIONS_STATISTICS;
        synchronized (hashMap) {
            Languages.createSortedList(preferredLocale);
            String[] tags = new String[SORTED_LANGUAGES.size()];
            for (int i = 0; i < SORTED_LANGUAGES.size(); ++i) {
                tags[i] = Languages.SORTED_LANGUAGES.get((int)i).tag;
            }
            return tags;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getLanguageNames(Locale preferredLocale) {
        HashMap<String, TranslationStatistics> hashMap = TRANSLATIONS_STATISTICS;
        synchronized (hashMap) {
            Languages.createSortedList(preferredLocale);
            String[] languages = new String[SORTED_LANGUAGES.size()];
            for (int i = 0; i < SORTED_LANGUAGES.size(); ++i) {
                LanguageEntry entry = SORTED_LANGUAGES.get(i);
                Object name = entry.name;
                if (!entry.name.equals(entry.defaultname)) {
                    name = (String)name + String.format(" (%s)", entry.defaultname);
                }
                if (!entry.locale.getLanguage().equals("en")) {
                    name = (String)name + String.format(" (%d%%)", entry.coveragePercent);
                }
                languages[i] = name;
            }
            return languages;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JsonArray getLanguagesAsJsonArray(Locale locale) {
        Locale preferredLocale = Languages.toLocale(locale);
        if (preferredLocale == null) {
            preferredLocale = PMS.getLocale();
        }
        HashMap<String, TranslationStatistics> hashMap = TRANSLATIONS_STATISTICS;
        synchronized (hashMap) {
            Languages.createSortedList(preferredLocale);
            JsonArray jsonArray = new JsonArray();
            for (int i = 0; i < SORTED_LANGUAGES.size(); ++i) {
                JsonObject objectGroup = new JsonObject();
                LanguageEntry entry = SORTED_LANGUAGES.get(i);
                objectGroup.addProperty("id", entry.tag);
                objectGroup.addProperty("name", entry.name);
                objectGroup.addProperty("defaultname", entry.defaultname);
                objectGroup.addProperty("country", entry.country);
                objectGroup.addProperty("coverage", entry.coveragePercent);
                jsonArray.add(objectGroup);
            }
            return jsonArray;
        }
    }

    public static boolean getLanguageIsRtl(Locale locale) {
        return switch (locale.getLanguage()) {
            case "ar" -> true;
            case "fa" -> true;
            default -> false;
        };
    }

    public static class TranslationStatistics {
        protected String name;
        protected int phrases;
        protected int phrasesApproved;
        protected int phrasesTranslated;
        protected int words;
        protected int wordsApproved;
        protected int wordsTranslated;
        protected int approved;
        protected int translated;
    }

    private static class LanguageEntry
    implements Comparable<LanguageEntry> {
        protected String tag;
        protected String name;
        protected String defaultname;
        protected String country;
        protected Locale locale = null;
        protected int coveragePercent;
        protected int approvedPercent;

        private LanguageEntry() {
        }

        @Override
        public int compareTo(LanguageEntry entry) {
            int result = this.name.compareTo(entry.name);
            if (result != 0) {
                return result;
            }
            result = this.tag.compareTo(entry.tag);
            if (result != 0) {
                return result;
            }
            result = entry.coveragePercent - this.coveragePercent;
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.approvedPercent;
            result = 31 * result + this.coveragePercent;
            result = 31 * result + (this.locale == null ? 0 : this.locale.hashCode());
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.defaultname == null ? 0 : this.defaultname.hashCode());
            result = 31 * result + (this.country == null ? 0 : this.country.hashCode());
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof LanguageEntry)) {
                return false;
            }
            LanguageEntry other = (LanguageEntry)obj;
            return this.approvedPercent == other.approvedPercent && this.coveragePercent == other.coveragePercent && (this.locale == null ? other.locale == null : this.locale.equals(other.locale)) && (this.name == null ? other.name == null : this.name.equals(other.name)) && (this.defaultname == null ? other.defaultname == null : this.defaultname.equals(other.defaultname)) && (this.country == null ? other.country == null : this.country.equals(other.country)) && (this.tag == null ? other.tag == null : this.tag.equals(other.tag));
        }
    }

    private static class LanguageEntryCoverageComparator
    implements Comparator<LanguageEntry>,
    Serializable {
        private static final long serialVersionUID = 1974719326731763265L;

        private LanguageEntryCoverageComparator() {
        }

        @Override
        public int compare(LanguageEntry o1, LanguageEntry o2) {
            return o2.coveragePercent - o1.coveragePercent;
        }
    }
}

