/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import java.awt.Color;
import java.awt.color.ColorSpace;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.util.InvalidArgumentException;

public class FormattableColor
extends Color {
    protected static final Pattern HEX_PATTERN = Pattern.compile("(?i)^\\s*(?:x'|%|#|0x|\\\\x|%x|\\$|h'|16#|16r|#x|#16r|&h|0h)([0-9a-f]{1,8})'?\\s*$");
    protected static final Pattern DEC_PATTERN = Pattern.compile("^\\s*(-?\\d{1,10})\\s*$");
    private static final Map<String, int[]> KNOWN_COLORS = new HashMap<String, int[]>(140, 1.0f);

    public FormattableColor(int rgb) {
        super(rgb);
    }

    public FormattableColor(int rgba, boolean hasalpha) {
        super(rgba, hasalpha);
    }

    public FormattableColor(int r, int g, int b) {
        super(r, g, b);
    }

    public FormattableColor(float r, float g, float b) {
        super(r, g, b);
    }

    public FormattableColor(ColorSpace cspace, float[] components, float alpha) {
        super(cspace, components, alpha);
    }

    public FormattableColor(int r, int g, int b, int a) {
        super(r, g, b, a);
    }

    public FormattableColor(float r, float g, float b, float a) {
        super(r, g, b, a);
    }

    public FormattableColor(Color color) {
        super(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha());
    }

    public FormattableColor(String color) throws InvalidArgumentException {
        super(FormattableColor.calculateIntValue(color), true);
    }

    protected static int calculateIntValue(String color) throws InvalidArgumentException {
        if (color == null) {
            throw new NullPointerException("color cannot be null");
        }
        color = color.trim();
        NumberFormatException ne = null;
        try {
            String value = FormattableColor.extractHexString(color);
            if (value != null) {
                long l = Long.parseLong(value, 16);
                if (value.length() == 7) {
                    return (int)((l & 0xFF00000L) >> 4 | (l & 0xFF000L) >> 4 | (l & 0xFF0L) >> 4 | (l & 0xFL) << 28);
                }
                if (value.length() == 8) {
                    return (int)((l & 0xFFFFFFFFFF000000L) >> 8 | (l & 0xFF0000L) >> 8 | (l & 0xFF00L) >> 8 | (l & 0xFFL) << 24);
                }
                return (int)(0xFFFFFFFFFF000000L | l);
            }
            if (color.contains(",")) {
                int a;
                String[] colorElements = color.split("\\s*,\\s*");
                int r = Integer.parseInt(colorElements[0]);
                int g = Integer.parseInt(colorElements[1]);
                int b = Integer.parseInt(colorElements[2]);
                int n = a = colorElements.length > 3 ? Integer.parseInt(colorElements[3]) : 255;
                if (r > -1 && r < 256 && g > -1 && g < 256 && b > -1 && b < 256 && a > -1 && a < 256) {
                    return a << 24 | r << 16 | g << 8 | b;
                }
            }
            if ((value = FormattableColor.extractDecString(color)) != null) {
                return (int)Long.parseLong(value);
            }
        }
        catch (NumberFormatException e) {
            ne = e;
        }
        int[] rgb = FormattableColor.getNamedColorValues(color);
        if (rgb != null && rgb.length == 3) {
            return 0xFF000000 | (rgb[0] & 0xFF) << 16 | (rgb[1] & 0xFF) << 8 | rgb[2] & 0xFF;
        }
        Color colorInstance = Color.getColor(color);
        if (colorInstance != null) {
            return (colorInstance.getAlpha() & 0xFF) << 24 | (colorInstance.getRed() & 0xFF) << 16 | (colorInstance.getGreen() & 0xFF) << 8 | colorInstance.getBlue() & 0xFF;
        }
        if (ne != null) {
            throw new InvalidArgumentException(String.format(Locale.ROOT, "Could not parse subtitle color \"%s\": %s", color, ne.getMessage()), ne);
        }
        throw new InvalidArgumentException(String.format(Locale.ROOT, "Could not parse subtitle color \"%s\"", color));
    }

    public String get0xRRGGBBAA() {
        return this.getHexValue("0x", "RRGGBBAA", null, true, false);
    }

    public String get0xRRGGBB() {
        return this.getHexValue("0x", "RRGGBB", null, true, true);
    }

    public String getHexValue(String prefix, String pattern, String suffix, boolean upperCase, boolean invertAlpha) {
        StringBuilder sb = new StringBuilder(prefix != null ? prefix : "");
        String red = upperCase ? Integer.toHexString(this.getRed()).toUpperCase(Locale.ROOT) : Integer.toHexString(this.getRed());
        String green = upperCase ? Integer.toHexString(this.getGreen()).toUpperCase(Locale.ROOT) : Integer.toHexString(this.getGreen());
        String blue = upperCase ? Integer.toHexString(this.getBlue()).toUpperCase(Locale.ROOT) : Integer.toHexString(this.getBlue());
        Integer a = invertAlpha ? 255 - this.getAlpha() : this.getAlpha();
        String alpha = upperCase ? Integer.toHexString(a).toUpperCase(Locale.ROOT) : Integer.toHexString(a);
        pattern = pattern.toUpperCase(Locale.ROOT);
        for (int i = 0; i < pattern.length(); ++i) {
            if ("RR".equals(pattern.substring(i, i + 2))) {
                if (red.length() < 2) {
                    sb.append("0").append(red);
                } else {
                    sb.append(red);
                }
                ++i;
                continue;
            }
            if ("R".equals(pattern.substring(i, i + 1))) {
                sb.append(red);
                continue;
            }
            if ("GG".equals(pattern.substring(i, i + 2))) {
                if (green.length() < 2) {
                    sb.append("0").append(green);
                } else {
                    sb.append(green);
                }
                ++i;
                continue;
            }
            if ("G".equals(pattern.substring(i, i + 1))) {
                sb.append(green);
                continue;
            }
            if ("BB".equals(pattern.substring(i, i + 2))) {
                if (blue.length() < 2) {
                    sb.append("0").append(blue);
                } else {
                    sb.append(blue);
                }
                ++i;
                continue;
            }
            if ("B".equals(pattern.substring(i, i + 1))) {
                sb.append(blue);
                continue;
            }
            if ("AA".equals(pattern.substring(i, i + 2))) {
                if (alpha.length() < 2) {
                    sb.append("0").append(alpha);
                } else {
                    sb.append(alpha);
                }
                ++i;
                continue;
            }
            if (!"A".equals(pattern.substring(i, i + 1))) continue;
            sb.append(alpha);
        }
        if (suffix != null) {
            sb.append(suffix);
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[r=" + this.getHexValue("0x", "RR", null, true, false) + ", g=" + this.getHexValue("0x", "GG", null, true, false) + ", b=" + this.getHexValue("0x", "BB", null, true, false) + ", a=" + this.getHexValue("0x", "AA", null, true, false) + "]";
    }

    protected static String extractHexString(String s) {
        Matcher matcher = HEX_PATTERN.matcher(s);
        if (matcher.find()) {
            return matcher.group(1).toUpperCase(Locale.ROOT);
        }
        return null;
    }

    protected static String extractDecString(String s) {
        Matcher matcher = DEC_PATTERN.matcher(s);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static int[] getNamedColorValues(String colorName) {
        if (KNOWN_COLORS.containsKey(colorName = colorName.toUpperCase(Locale.ROOT))) {
            return KNOWN_COLORS.get(colorName);
        }
        return null;
    }

    static {
        KNOWN_COLORS.put("ALICEBLUE", new int[]{240, 248, 255});
        KNOWN_COLORS.put("ANTIQUEWHITE", new int[]{250, 235, 215});
        KNOWN_COLORS.put("AQUA", new int[]{0, 255, 255});
        KNOWN_COLORS.put("AQUAMARINE", new int[]{127, 255, 212});
        KNOWN_COLORS.put("AZURE", new int[]{240, 255, 255});
        KNOWN_COLORS.put("BEIGE", new int[]{245, 245, 220});
        KNOWN_COLORS.put("BISQUE", new int[]{255, 228, 196});
        KNOWN_COLORS.put("BLACK", new int[]{0, 0, 0});
        KNOWN_COLORS.put("BLANCHEDALMOND", new int[]{255, 235, 205});
        KNOWN_COLORS.put("BLUE", new int[]{0, 0, 255});
        KNOWN_COLORS.put("BLUEVIOLET", new int[]{138, 43, 226});
        KNOWN_COLORS.put("BROWN", new int[]{165, 42, 42});
        KNOWN_COLORS.put("BURLYWOOD", new int[]{222, 184, 135});
        KNOWN_COLORS.put("CADETBLUE", new int[]{95, 158, 160});
        KNOWN_COLORS.put("CHARTREUSE", new int[]{127, 255, 0});
        KNOWN_COLORS.put("CHOCOLATE", new int[]{210, 105, 30});
        KNOWN_COLORS.put("CORAL", new int[]{255, 127, 80});
        KNOWN_COLORS.put("CORNFLOWERBLUE", new int[]{100, 149, 237});
        KNOWN_COLORS.put("CORNSILK", new int[]{255, 248, 220});
        KNOWN_COLORS.put("CRIMSON", new int[]{220, 20, 60});
        KNOWN_COLORS.put("CYAN", new int[]{0, 255, 255});
        KNOWN_COLORS.put("DARKBLUE", new int[]{0, 0, 139});
        KNOWN_COLORS.put("DARKCYAN", new int[]{0, 139, 139});
        KNOWN_COLORS.put("DARKGOLDENROD", new int[]{184, 134, 11});
        KNOWN_COLORS.put("DARKGRAY", new int[]{169, 169, 169});
        KNOWN_COLORS.put("DARKGREEN", new int[]{0, 100, 0});
        KNOWN_COLORS.put("DARKKHAKI", new int[]{189, 183, 107});
        KNOWN_COLORS.put("DARKMAGENTA", new int[]{139, 0, 139});
        KNOWN_COLORS.put("DARKOLIVEGREEN", new int[]{85, 107, 47});
        KNOWN_COLORS.put("DARKORANGE", new int[]{255, 140, 0});
        KNOWN_COLORS.put("DARKORCHID", new int[]{153, 50, 204});
        KNOWN_COLORS.put("DARKRED", new int[]{139, 0, 0});
        KNOWN_COLORS.put("DARKSALMON", new int[]{233, 150, 122});
        KNOWN_COLORS.put("DARKSEAGREEN", new int[]{143, 188, 143});
        KNOWN_COLORS.put("DARKSLATEBLUE", new int[]{72, 61, 139});
        KNOWN_COLORS.put("DARKSLATEGRAY", new int[]{47, 79, 79});
        KNOWN_COLORS.put("DARKTURQUOISE", new int[]{0, 206, 209});
        KNOWN_COLORS.put("DARKVIOLET", new int[]{148, 0, 211});
        KNOWN_COLORS.put("DEEPPINK", new int[]{255, 20, 147});
        KNOWN_COLORS.put("DEEPSKYBLUE", new int[]{0, 191, 255});
        KNOWN_COLORS.put("DIMGRAY", new int[]{105, 105, 105});
        KNOWN_COLORS.put("DODGERBLUE", new int[]{30, 144, 255});
        KNOWN_COLORS.put("FIREBRICK", new int[]{178, 34, 34});
        KNOWN_COLORS.put("FLORALWHITE", new int[]{255, 250, 240});
        KNOWN_COLORS.put("FORESTGREEN", new int[]{34, 139, 34});
        KNOWN_COLORS.put("FUCHSIA", new int[]{255, 0, 255});
        KNOWN_COLORS.put("GAINSBORO", new int[]{220, 220, 220});
        KNOWN_COLORS.put("GHOSTWHITE", new int[]{248, 248, 255});
        KNOWN_COLORS.put("GOLD", new int[]{255, 215, 0});
        KNOWN_COLORS.put("GOLDENROD", new int[]{218, 165, 32});
        KNOWN_COLORS.put("GRAY", new int[]{128, 128, 128});
        KNOWN_COLORS.put("GREEN", new int[]{0, 128, 0});
        KNOWN_COLORS.put("GREENYELLOW", new int[]{173, 255, 47});
        KNOWN_COLORS.put("HONEYDEW", new int[]{240, 255, 240});
        KNOWN_COLORS.put("HOTPINK", new int[]{255, 105, 180});
        KNOWN_COLORS.put("INDIANRED", new int[]{205, 92, 92});
        KNOWN_COLORS.put("INDIGO", new int[]{75, 0, 130});
        KNOWN_COLORS.put("IVORY", new int[]{255, 255, 240});
        KNOWN_COLORS.put("KHAKI", new int[]{240, 230, 140});
        KNOWN_COLORS.put("LAVENDER", new int[]{230, 230, 250});
        KNOWN_COLORS.put("LAVENDERBLUSH", new int[]{255, 240, 245});
        KNOWN_COLORS.put("LAWNGREEN", new int[]{124, 252, 0});
        KNOWN_COLORS.put("LEMONCHIFFON", new int[]{255, 250, 205});
        KNOWN_COLORS.put("LIGHTBLUE", new int[]{173, 216, 230});
        KNOWN_COLORS.put("LIGHTCORAL", new int[]{240, 128, 128});
        KNOWN_COLORS.put("LIGHTCYAN", new int[]{224, 255, 255});
        KNOWN_COLORS.put("LIGHTGOLDENRODYELLOW", new int[]{250, 250, 210});
        KNOWN_COLORS.put("LIGHTGRAY", new int[]{211, 211, 211});
        KNOWN_COLORS.put("LIGHTGREEN", new int[]{144, 238, 144});
        KNOWN_COLORS.put("LIGHTPINK", new int[]{255, 182, 193});
        KNOWN_COLORS.put("LIGHTSALMON", new int[]{255, 160, 122});
        KNOWN_COLORS.put("LIGHTSEAGREEN", new int[]{32, 178, 170});
        KNOWN_COLORS.put("LIGHTSKYBLUE", new int[]{135, 206, 250});
        KNOWN_COLORS.put("LIGHTSLATEGRAY", new int[]{119, 136, 153});
        KNOWN_COLORS.put("LIGHTSTEELBLUE", new int[]{176, 196, 222});
        KNOWN_COLORS.put("LIGHTYELLOW", new int[]{255, 255, 224});
        KNOWN_COLORS.put("LIME", new int[]{0, 255, 0});
        KNOWN_COLORS.put("LIMEGREEN", new int[]{50, 205, 50});
        KNOWN_COLORS.put("LINEN", new int[]{250, 240, 230});
        KNOWN_COLORS.put("MAGENTA", new int[]{255, 0, 255});
        KNOWN_COLORS.put("MAROON", new int[]{128, 0, 0});
        KNOWN_COLORS.put("MEDIUMAQUAMARINE", new int[]{102, 205, 170});
        KNOWN_COLORS.put("MEDIUMBLUE", new int[]{0, 0, 205});
        KNOWN_COLORS.put("MEDIUMORCHID", new int[]{186, 85, 211});
        KNOWN_COLORS.put("MEDIUMPURPLE", new int[]{147, 112, 219});
        KNOWN_COLORS.put("MEDIUMSEAGREEN", new int[]{60, 179, 113});
        KNOWN_COLORS.put("MEDIUMSLATEBLUE", new int[]{123, 104, 238});
        KNOWN_COLORS.put("MEDIUMSPRINGGREEN", new int[]{0, 250, 154});
        KNOWN_COLORS.put("MEDIUMTURQUOISE", new int[]{72, 209, 204});
        KNOWN_COLORS.put("MEDIUMVIOLETRED", new int[]{199, 21, 133});
        KNOWN_COLORS.put("MIDNIGHTBLUE", new int[]{25, 25, 112});
        KNOWN_COLORS.put("MINTCREAM", new int[]{245, 255, 250});
        KNOWN_COLORS.put("MISTYROSE", new int[]{255, 228, 225});
        KNOWN_COLORS.put("MOCCASIN", new int[]{255, 228, 181});
        KNOWN_COLORS.put("NAVAJOWHITE", new int[]{255, 222, 173});
        KNOWN_COLORS.put("NAVY", new int[]{0, 0, 128});
        KNOWN_COLORS.put("OLDLACE", new int[]{253, 245, 230});
        KNOWN_COLORS.put("OLIVE", new int[]{128, 128, 0});
        KNOWN_COLORS.put("OLIVEDRAB", new int[]{107, 142, 35});
        KNOWN_COLORS.put("ORANGE", new int[]{255, 165, 0});
        KNOWN_COLORS.put("ORANGERED", new int[]{255, 69, 0});
        KNOWN_COLORS.put("ORCHID", new int[]{218, 112, 214});
        KNOWN_COLORS.put("PALEGOLDENROD", new int[]{238, 232, 170});
        KNOWN_COLORS.put("PALEGREEN", new int[]{152, 251, 152});
        KNOWN_COLORS.put("PALETURQUOISE", new int[]{175, 238, 238});
        KNOWN_COLORS.put("PALEVIOLETRED", new int[]{219, 112, 147});
        KNOWN_COLORS.put("PAPAYAWHIP", new int[]{255, 239, 213});
        KNOWN_COLORS.put("PEACHPUFF", new int[]{255, 218, 185});
        KNOWN_COLORS.put("PERU", new int[]{205, 133, 63});
        KNOWN_COLORS.put("PINK", new int[]{255, 192, 203});
        KNOWN_COLORS.put("PLUM", new int[]{221, 160, 221});
        KNOWN_COLORS.put("POWDERBLUE", new int[]{176, 224, 230});
        KNOWN_COLORS.put("PURPLE", new int[]{128, 0, 128});
        KNOWN_COLORS.put("RED", new int[]{255, 0, 0});
        KNOWN_COLORS.put("ROSYBROWN", new int[]{188, 143, 143});
        KNOWN_COLORS.put("ROYALBLUE", new int[]{65, 105, 225});
        KNOWN_COLORS.put("SADDLEBROWN", new int[]{139, 69, 19});
        KNOWN_COLORS.put("SALMON", new int[]{250, 128, 114});
        KNOWN_COLORS.put("SANDYBROWN", new int[]{244, 164, 96});
        KNOWN_COLORS.put("SEAGREEN", new int[]{46, 139, 87});
        KNOWN_COLORS.put("SEASHELL", new int[]{255, 245, 238});
        KNOWN_COLORS.put("SIENNA", new int[]{160, 82, 45});
        KNOWN_COLORS.put("SILVER", new int[]{192, 192, 192});
        KNOWN_COLORS.put("SKYBLUE", new int[]{135, 206, 235});
        KNOWN_COLORS.put("SLATEBLUE", new int[]{106, 90, 205});
        KNOWN_COLORS.put("SLATEGRAY", new int[]{112, 128, 144});
        KNOWN_COLORS.put("SNOW", new int[]{255, 250, 250});
        KNOWN_COLORS.put("SPRINGGREEN", new int[]{0, 255, 127});
        KNOWN_COLORS.put("STEELBLUE", new int[]{70, 130, 180});
        KNOWN_COLORS.put("TAN", new int[]{210, 180, 140});
        KNOWN_COLORS.put("TEAL", new int[]{0, 128, 128});
        KNOWN_COLORS.put("THISTLE", new int[]{216, 191, 216});
        KNOWN_COLORS.put("TOMATO", new int[]{255, 99, 71});
        KNOWN_COLORS.put("TURQUOISE", new int[]{64, 224, 208});
        KNOWN_COLORS.put("VIOLET", new int[]{238, 130, 238});
        KNOWN_COLORS.put("WHEAT", new int[]{245, 222, 179});
        KNOWN_COLORS.put("WHITE", new int[]{255, 255, 255});
        KNOWN_COLORS.put("WHITESMOKE", new int[]{245, 245, 245});
        KNOWN_COLORS.put("YELLOW", new int[]{255, 255, 0});
        KNOWN_COLORS.put("YELLOWGREEN", new int[]{154, 205, 50});
    }
}

