/*
 * Decompiled with CFR 0.152.
 */
package net.pms.util;

import com.google.errorprone.annotations.Immutable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.pms.util.ExecutableErrorType;
import net.pms.util.Version;

@Immutable
public class ExecutableInfo {
    @Nonnull
    protected final Path executablePath;
    protected final boolean pathExists;
    @Nullable
    protected final Boolean available;
    @Nullable
    protected final Version version;
    @Nullable
    protected final ExecutableErrorType errorType;
    @Nullable
    protected final String errorText;

    public ExecutableInfo(@Nullable Boolean available, @Nonnull Path path, @Nullable Version version, @Nullable ExecutableErrorType errorType, @Nullable String errorText) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        if (!(available == null || available.booleanValue() || errorType != null && errorText != null)) {
            throw new IllegalArgumentException("errorType and errorText must be specified in available is false");
        }
        this.available = available;
        this.executablePath = path;
        this.version = version;
        this.errorType = errorType;
        this.errorText = errorText;
        this.pathExists = Files.exists(path, new LinkOption[0]);
    }

    @Nonnull
    public Path getPath() {
        return this.executablePath;
    }

    public boolean isPathExisting() {
        return this.pathExists;
    }

    @Nullable
    public Boolean getAvailable() {
        return this.available;
    }

    @Nullable
    public Version getVersion() {
        return this.version;
    }

    @Nullable
    public ExecutableErrorType getErrorType() {
        return this.errorType;
    }

    @Nullable
    public String getErrorText() {
        return this.errorText;
    }

    public ExecutableInfoBuilder modify() {
        return new ExecutableInfoBuilder(this);
    }

    public static ExecutableInfoBuilder build(Path executablePath) {
        return new ExecutableInfoBuilder(executablePath);
    }

    public String toString() {
        return "ExecutableInfo [executablePath=" + String.valueOf(this.executablePath) + ", available=" + this.available + ", version=" + String.valueOf(this.version) + ", errorType=" + String.valueOf((Object)this.errorType) + ", errorText=" + this.errorText + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.available == null ? 0 : this.available.hashCode());
        result = 31 * result + (this.errorText == null ? 0 : this.errorText.hashCode());
        result = 31 * result + (this.errorType == null ? 0 : this.errorType.hashCode());
        result = 31 * result + this.executablePath.hashCode();
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutableInfo)) {
            return false;
        }
        ExecutableInfo other = (ExecutableInfo)obj;
        if (this.available == null ? other.available != null : !this.available.equals(other.available)) {
            return false;
        }
        if (this.errorText == null ? other.errorText != null : !this.errorText.equals(other.errorText)) {
            return false;
        }
        if (this.errorType != other.errorType) {
            return false;
        }
        if (!this.executablePath.equals(other.executablePath)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public static class ExecutableInfoBuilder {
        protected Path executablePath;
        protected Boolean available;
        protected Version version;
        protected ExecutableErrorType errorType;
        protected String errorText;

        public ExecutableInfoBuilder() {
        }

        public ExecutableInfoBuilder(Path executablePath) {
            this.executablePath = executablePath;
        }

        public ExecutableInfoBuilder(ExecutableInfo executableInfo) {
            this.available = executableInfo.available;
            this.executablePath = executableInfo.executablePath;
            this.version = executableInfo.version;
            this.errorType = executableInfo.errorType;
            this.errorText = executableInfo.errorText;
        }

        @Nonnull
        public ExecutableInfo build() {
            return new ExecutableInfo(this.available, this.executablePath, this.version, this.errorType, this.errorText);
        }

        public boolean isValid() {
            return this.executablePath != null && (this.available == null || this.available != false || this.errorType != null && this.errorText != null);
        }

        @Nullable
        public Path executablePath() {
            return this.executablePath;
        }

        @Nonnull
        public ExecutableInfoBuilder executablePath(Path executablePath) {
            this.executablePath = executablePath;
            return this;
        }

        @Nullable
        public Boolean available() {
            return this.available;
        }

        @Nonnull
        public ExecutableInfoBuilder available(Boolean available) {
            this.available = available;
            return this;
        }

        @Nullable
        public Version version() {
            return this.version;
        }

        @Nonnull
        public ExecutableInfoBuilder version(Version version) {
            this.version = version;
            return this;
        }

        @Nullable
        public ExecutableErrorType errorType() {
            return this.errorType;
        }

        @Nonnull
        public ExecutableInfoBuilder errorType(ExecutableErrorType errorType) {
            this.errorType = errorType;
            return this;
        }

        @Nullable
        public String errorText() {
            return this.errorText;
        }

        public ExecutableInfoBuilder errorText(String errorText) {
            this.errorText = errorText;
            return this;
        }
    }
}

