/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.transcoding;

import com.jgoodies.forms.factories.Paddings;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Dimension;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.tree.DefaultMutableTreeNode;
import net.pms.Messages;
import net.pms.encoders.Engine;
import net.pms.swing.gui.JavaGui;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.swing.gui.tabs.transcoding.AviSynthFFmpeg;
import net.pms.swing.gui.tabs.transcoding.AviSynthMEncoder;
import net.pms.swing.gui.tabs.transcoding.FFMpegVideo;
import net.pms.swing.gui.tabs.transcoding.FFmpegAudio;
import net.pms.swing.gui.tabs.transcoding.MEncoderVideo;
import net.pms.swing.gui.tabs.transcoding.TsMuxeRVideo;
import net.pms.swing.gui.tabs.transcoding.VLCVideo;
import net.pms.util.StringUtil;

public class TreeNodeSettings
extends DefaultMutableTreeNode {
    private static final long serialVersionUID = -337606760204027449L;
    private static final String ICON_ENGINE_WARNING = "icon-engine-warning.svg";
    private final Engine engine;
    private final JComponent otherConfigPanel;
    private JPanel warningPanel;

    public Engine getPlayer() {
        return this.engine;
    }

    public TreeNodeSettings(String name, Engine engine, JComponent otherConfigPanel) {
        super(name);
        this.engine = engine;
        this.otherConfigPanel = otherConfigPanel;
    }

    public String id() {
        if (this.engine != null) {
            return this.engine.getEngineId().toString();
        }
        if (this.otherConfigPanel != null) {
            return "" + this.otherConfigPanel.hashCode();
        }
        return null;
    }

    public JComponent getConfigPanel() {
        if (this.engine != null) {
            if (this.engine.isAvailable()) {
                return TreeNodeSettings.getConfigPanel(this.engine.getName());
            }
            return this.getWarningPanel();
        }
        if (this.otherConfigPanel != null) {
            return this.otherConfigPanel;
        }
        return new JPanel();
    }

    private JPanel getWarningPanel() {
        if (this.warningPanel == null) {
            ImageIcon warningIcon = JavaGui.readImageIcon(ICON_ENGINE_WARNING);
            FormLayout layout = new FormLayout("10dlu, pref, 10dlu, pref:grow, 10dlu", "5dlu, pref, 3dlu, pref:grow, 5dlu");
            UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
            builder.border(Paddings.DIALOG);
            builder.opaque(false);
            CellConstraints cc = new CellConstraints();
            builder.add(warningIcon).at(cc.xywh(2, 1, 1, 4, CellConstraints.CENTER, CellConstraints.TOP));
            JLabel warningLabel = new JLabel(Messages.getGuiString("ThisEngineNotLoaded"));
            builder.add(warningLabel).at(cc.xy(4, 2, CellConstraints.LEFT, CellConstraints.CENTER));
            warningLabel.setFont(warningLabel.getFont().deriveFont(1));
            if (StringUtil.hasValue(this.engine.getStatusTextFull())) {
                JTextArea stateText = new JTextArea(this.engine.getStatusTextFull());
                stateText.setPreferredSize(new Dimension());
                stateText.setEditable(false);
                stateText.setLineWrap(true);
                stateText.setWrapStyleWord(true);
                builder.add(stateText).at(cc.xy(4, 4, CellConstraints.FILL, CellConstraints.FILL));
            }
            this.warningPanel = builder.getPanel();
        }
        return this.warningPanel;
    }

    public static JComponent getConfigPanel(String name) {
        return switch (name) {
            case "AviSynth/FFmpeg" -> AviSynthFFmpeg.config();
            case "AviSynth/MEncoder" -> AviSynthMEncoder.config();
            case "FFmpeg Video" -> FFMpegVideo.config();
            case "FFmpeg Audio" -> FFmpegAudio.config();
            case "MEncoder Video" -> MEncoderVideo.config();
            case "tsMuxeR Video" -> TsMuxeRVideo.config();
            case "VLC Video" -> VLCVideo.config();
            default -> null;
        };
    }
}

