/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.traces;

import ch.qos.logback.classic.Level;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.FocusManager;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.logging.LoggingConfig;
import net.pms.swing.components.CustomJButton;
import net.pms.swing.components.CustomJSpinner;
import net.pms.swing.components.SpinnerIntModel;
import net.pms.swing.gui.FormLayoutUtil;
import net.pms.swing.gui.JavaGui;
import net.pms.swing.gui.UmsFormBuilder;
import net.pms.swing.gui.ViewLevel;
import net.pms.swing.gui.tabs.traces.DbgPackerComponent;
import net.pms.swing.gui.tabs.traces.TextAreaFIFO;
import net.pms.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracesTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(TracesTab.class);
    private static final Level[] LOG_LEVELS = new Level[]{Level.ERROR, Level.WARN, Level.INFO, Level.DEBUG, Level.TRACE, Level.OFF};
    private static final String[] SYSLOG_FACILITIES = new String[]{"AUTH", "AUTHPRIV", "DAEMON", "CRON", "FTP", "LPR", "KERN", "MAIL", "NEWS", "SYSLOG", "USER", "UUCP", "LOCAL0", "LOCAL1", "LOCAL2", "LOCAL3", "LOCAL4", "LOCAL5", "LOCAL6", "LOCAL7"};
    private final UmsConfiguration configuration;
    private final JavaGui looksFrame;
    private final JLabel jSearchOutput = new JLabel();
    private String[] levelStrings = new String[]{Messages.getGuiString("Error"), Messages.getGuiString("Warning"), Messages.getGuiString("Info"), Messages.getGuiString("Debug"), Messages.getGuiString("Trace"), Messages.getGuiString("All"), Messages.getGuiString("Off")};
    private JLabel jFilterLabel;
    private JComboBox<String> jTracesFilter;
    private JTextField jSearchBox;
    private JTextField jSyslogHost;
    private JLabel jSyslogHostLabel;
    private JLabel jSyslogFacilityLabel;
    private JComboBox<String> jSyslogFacility;
    private JCheckBox jCSSearch;
    private JCheckBox jRESearch;
    private JCheckBox jMLSearch;
    private JCheckBox jShowOptions;
    private JCheckBox jBuffered;
    private JCheckBox jUseSyslog;
    private JSpinner jLineBuffer;
    private JLabel jSyslogPortLabel;
    private JSpinner jSyslogPort;
    private Pattern searchPattern = null;
    private TextAreaFIFO jList;
    private JPanel jOptionsPanel;
    private JLabel jBufferLabel;
    private JSeparator jBufferSeparator;
    private Component jBufferSpace1;
    private Component jBufferSpace2;
    private Component jBufferSpace3;
    private JButton jSearchButton;
    private Component jCSSpace;
    private Component jRESpace;
    private Component jMLSpace;
    private JMenuItem copyItem;
    private JMenuItem clearItem;
    private JComboBox<String> rootLevel;
    private JLabel rootLevelLabel;
    private CustomJButton rebootTrace;
    private CustomJButton packDbg;
    private CustomJButton openFullLog;

    public TracesTab(UmsConfiguration configuration, JavaGui looksFrame) {
        this.configuration = configuration;
        this.looksFrame = looksFrame;
    }

    public JComponent build() {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(PMS.getLocale());
        String colSpec = FormLayoutUtil.getColSpec("pref, pref:grow, pref, 3dlu, pref, pref, pref", orientation);
        int cols = colSpec.split(",").length;
        FormLayout layout = new FormLayout(colSpec, "p, fill:10:grow, p, p");
        UmsFormBuilder builder = UmsFormBuilder.create().layout(layout);
        builder.opaque(true);
        CellConstraints cc = new CellConstraints();
        JPanel jSearchPanel = new JPanel();
        jSearchPanel.setLayout(new BoxLayout(jSearchPanel, 2));
        jSearchPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.jFilterLabel = new JLabel(Messages.getGuiString("Filter") + ":");
        this.jFilterLabel.setDisplayedMnemonic(70);
        this.jFilterLabel.setToolTipText(Messages.getGuiString("FilterLogMessagesLogWindow"));
        this.jTracesFilter = new JComboBox<String>(this.levelStrings);
        this.jTracesFilter.setSelectedIndex(this.findLevelsIdx(this.configuration.getLoggingFilterLogsTab()));
        this.jFilterLabel.setLabelFor(this.jTracesFilter);
        this.jTracesFilter.setToolTipText(Messages.getGuiString("FilterLogMessagesLogWindow"));
        this.jTracesFilter.addActionListener(e -> {
            this.configuration.setLoggingFilterLogsTab(LOG_LEVELS[this.jTracesFilter.getSelectedIndex()]);
            LoggingConfig.setTracesFilter();
        });
        jSearchPanel.add(this.jFilterLabel);
        jSearchPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        jSearchPanel.add(this.jTracesFilter);
        jSearchPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.jSearchBox = new JTextField();
        this.jSearchBox.setBackground(new Color(248, 248, 248));
        this.jSearchBox.setToolTipText(Messages.getGuiString("SearchLogBelowCurrentPosition"));
        jSearchPanel.add(this.jSearchBox);
        jSearchPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.jSearchButton = new JButton(Messages.getGuiString("Search"));
        this.jSearchButton.setMnemonic(83);
        this.jSearchButton.setToolTipText(Messages.getGuiString("SearchLogBelowCurrentPosition"));
        jSearchPanel.add(this.jSearchButton);
        this.jCSSpace = Box.createRigidArea(new Dimension(5, 0));
        jSearchPanel.add(this.jCSSpace);
        this.jCSSearch = new JCheckBox(Messages.getGuiString("CaseSensitive"), this.configuration.getGUILogSearchCaseSensitive());
        this.jCSSearch.setMnemonic(67);
        this.jCSSearch.setToolTipText(Messages.getGuiString("SearchOnlyTextMatchesSearch"));
        jSearchPanel.add(this.jCSSearch);
        this.jRESpace = Box.createRigidArea(new Dimension(5, 0));
        jSearchPanel.add(this.jRESpace);
        this.jRESearch = new JCheckBox("RegEx", this.configuration.getGUILogSearchRegEx());
        this.jRESearch.setMnemonic(82);
        this.jRESearch.setToolTipText(Messages.getGuiString("SearchUsingRegularExpressions"));
        jSearchPanel.add(this.jRESearch);
        this.jMLSpace = Box.createRigidArea(new Dimension(5, 0));
        jSearchPanel.add(this.jMLSpace);
        this.jMLSearch = new JCheckBox(Messages.getGuiString("Multiline"), this.configuration.getGUILogSearchMultiLine());
        this.jMLSearch.setMnemonic(77);
        this.jMLSearch.setToolTipText(Messages.getGuiString("EnableSearchSpanMultipleLines"));
        jSearchPanel.add(this.jMLSearch);
        this.jBufferSpace1 = Box.createRigidArea(new Dimension(4, 0));
        this.jBufferSeparator = new JSeparator(1);
        this.jBufferSpace2 = Box.createRigidArea(new Dimension(4, 0));
        jSearchPanel.add(this.jBufferSpace1);
        jSearchPanel.add(this.jBufferSeparator);
        jSearchPanel.add(this.jBufferSpace2);
        this.jBufferLabel = new JLabel(Messages.getGuiString("LineBuffer"));
        this.jBufferLabel.setDisplayedMnemonic(66);
        this.jBufferLabel.setToolTipText(Messages.getGuiString("NumberLinesLogWindowBelow"));
        this.jLineBuffer = new CustomJSpinner(new SpinnerIntModel(this.configuration.getLoggingLogsTabLinebuffer(), UmsConfiguration.getLoggingLogsTabLinebufferMin(), UmsConfiguration.getLoggingLogsTabLinebufferMax(), UmsConfiguration.getLoggingLogsTabLinebufferStep()), true);
        this.jLineBuffer.setToolTipText(Messages.getGuiString("NumberLinesLogWindowBelow"));
        this.jBufferLabel.setLabelFor(this.jLineBuffer);
        jSearchPanel.add(this.jBufferLabel);
        this.jBufferSpace3 = Box.createRigidArea(new Dimension(5, 0));
        jSearchPanel.add(this.jBufferSpace3);
        jSearchPanel.add(this.jLineBuffer);
        this.jLineBuffer.addChangeListener(e -> {
            this.jList.setMaxLines((Integer)this.jLineBuffer.getValue());
            this.configuration.setLoggingLogsTabLinebuffer(this.jList.getMaxLines());
        });
        this.jSearchBox.addActionListener(e -> this.searchTraces());
        this.jSearchButton.addActionListener(e -> this.searchTraces());
        this.jCSSearch.addActionListener(e -> this.configuration.setGUILogSearchCaseSensitive(this.jCSSearch.isSelected()));
        this.jRESearch.addActionListener(e -> this.configuration.setGUILogSearchRegEx(this.jRESearch.isSelected()));
        this.jMLSearch.addActionListener(e -> this.configuration.setGUILogSearchMultiLine(this.jMLSearch.isSelected()));
        builder.add(jSearchPanel).at(cc.xyw(1, 1, cols));
        this.jList = new TextAreaFIFO(this.configuration.getLoggingLogsTabLinebuffer(), 500);
        this.jList.setEditable(false);
        this.jList.setBackground(Color.WHITE);
        this.jList.setFont(new Font("Monospaced", 0, this.jList.getFont().getSize()));
        JPopupMenu popup = new JPopupMenu();
        Action copy = this.jList.getActionMap().get("copy-to-clipboard");
        this.copyItem = new JMenuItem(copy);
        this.copyItem.setText(Messages.getGuiString("Copy"));
        popup.add(this.copyItem);
        popup.addSeparator();
        this.clearItem = new JMenuItem(Messages.getGuiString("Clear"));
        this.clearItem.addActionListener(e -> this.jList.setText(""));
        popup.add(this.clearItem);
        this.jList.addMouseListener(new PopupTriggerMouseListener(popup, this.jList));
        this.jList.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TracesTab.this.searchTraces();
                }
            }
        });
        JScrollPane jListPane = new JScrollPane(this.jList, 22, 30);
        jListPane.setBorder(BorderFactory.createEmptyBorder());
        builder.add(jListPane).at(cc.xyw(1, 2, cols));
        this.jOptionsPanel = new JPanel();
        this.jOptionsPanel.setLayout(new BoxLayout(this.jOptionsPanel, 2));
        this.jOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getGuiString("LoggingOptions")), BorderFactory.createEmptyBorder(10, 5, 10, 5))));
        this.jBuffered = new JCheckBox(Messages.getGuiString("BufferedLogging"), this.configuration.getLoggingBuffered());
        this.jBuffered.setMnemonic(85);
        this.jBuffered.setToolTipText(Messages.getGuiString("EnableBufferedFileLogging"));
        this.jBuffered.setHorizontalTextPosition(10);
        this.jBuffered.addActionListener(e -> {
            if (PMS.getTraceMode() == 2 && this.jBuffered.isSelected()) {
                this.jBuffered.setSelected(false);
                return;
            }
            this.configuration.setLoggingBuffered(this.jBuffered.isSelected());
            LoggingConfig.setBuffered(this.jBuffered.isSelected());
        });
        this.jOptionsPanel.add(this.jBuffered);
        this.jOptionsPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        boolean useSyslog = this.configuration.getLoggingUseSyslog();
        this.jUseSyslog = new JCheckBox(Messages.getGuiString("LogToSyslog"), useSyslog);
        this.jUseSyslog.setMnemonic(89);
        this.jUseSyslog.setToolTipText(Messages.getGuiString("SendLogSyslogServer"));
        this.jUseSyslog.setHorizontalTextPosition(10);
        this.jUseSyslog.addActionListener(e -> {
            if (PMS.getTraceMode() == 2 && this.jUseSyslog.isSelected()) {
                this.jUseSyslog.setSelected(false);
                return;
            }
            if (this.jSyslogHost.getText().trim().isEmpty()) {
                this.jSearchOutput.setText(Messages.getGuiString("SyslogHostnameCantBeEmpty"));
                this.jUseSyslog.setSelected(false);
                return;
            }
            this.jSearchOutput.setText("");
            boolean useSyslog1 = this.jUseSyslog.isSelected();
            this.configuration.setLoggingUseSyslog(useSyslog1);
            LoggingConfig.setSyslog();
            this.jSyslogHost.setEnabled(!useSyslog1);
            this.jSyslogPort.setEnabled(!useSyslog1);
            this.jSyslogFacility.setEnabled(!useSyslog1);
        });
        this.jOptionsPanel.add(this.jUseSyslog);
        this.jOptionsPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.jSyslogHostLabel = new JLabel(Messages.getGuiString("SyslogHostname"));
        this.jSyslogHostLabel.setDisplayedMnemonic(78);
        this.jSyslogHostLabel.setToolTipText(Messages.getGuiString("HostNameIpAddressSend"));
        this.jOptionsPanel.add(this.jSyslogHostLabel);
        this.jOptionsPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.jSyslogHost = new JTextField(this.configuration.getLoggingSyslogHost(), 10);
        this.jSyslogHostLabel.setLabelFor(this.jSyslogHost);
        this.jSyslogHost.setToolTipText(Messages.getGuiString("HostNameIpAddressSend"));
        this.jSyslogHost.setEnabled(!useSyslog);
        this.jSyslogHost.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    TracesTab.this.jSyslogHost.setText(TracesTab.this.configuration.getLoggingSyslogHost());
                } else if (e.getKeyCode() == 10) {
                    FocusManager.getCurrentManager().focusNextComponent();
                }
            }
        });
        this.jSyslogHost.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                String s = ((JTextField)input).getText().trim();
                if (!(s.isEmpty() || s.matches("^(([a-zA-Z0-9]|[a-zA-Z0-9][a-zA-Z0-9\\-]*[a-zA-Z0-9])\\.)*([A-Za-z0-9]|[A-Za-z0-9][A-Za-z0-9\\-]*[A-Za-z0-9])$") || s.matches("(^([0-9a-fA-F]{0,4}:)+[0-9a-fA-F]{1,4}([0-9a-fA-F]{0,4}:)*$)|(^([0-9a-fA-F]{0,4}:)*[0-9a-fA-F]{1,4}([0-9a-fA-F]{0,4}:)+$)|(^::$)"))) {
                    TracesTab.this.jSearchOutput.setText(String.format(Messages.getGuiString("XIsntValidHostnameIp"), s));
                    return false;
                }
                TracesTab.this.jSearchOutput.setText("");
                TracesTab.this.configuration.setLoggingSyslogHost(TracesTab.this.jSyslogHost.getText().trim());
                return true;
            }
        });
        this.jOptionsPanel.add(this.jSyslogHost);
        this.jOptionsPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.jSyslogPortLabel = new JLabel(Messages.getGuiString("SyslogPort"));
        this.jSyslogPortLabel.setToolTipText(Messages.getGuiString("UdpPortSendSyslogMessages"));
        this.jOptionsPanel.add(this.jSyslogPortLabel);
        this.jOptionsPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.jSyslogPort = new CustomJSpinner(new SpinnerIntModel(this.configuration.getLoggingSyslogPort(), 1, 65535), true);
        this.jSyslogPort.setToolTipText(Messages.getGuiString("UdpPortSendSyslogMessages"));
        this.jSyslogPort.setEnabled(!useSyslog);
        this.jSyslogPortLabel.setLabelFor(this.jSyslogPort);
        this.jSyslogPort.addChangeListener(e -> this.configuration.setLoggingSyslogPort((Integer)this.jSyslogPort.getValue()));
        this.jOptionsPanel.add(this.jSyslogPort);
        this.jOptionsPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.jSyslogFacilityLabel = new JLabel(Messages.getGuiString("SyslogFacility"));
        this.jSyslogFacilityLabel.setDisplayedMnemonic(65);
        this.jSyslogFacilityLabel.setToolTipText(Messages.getGuiString("SyslogFacilityMeantIdentifySource"));
        this.jOptionsPanel.add(this.jSyslogFacilityLabel);
        this.jOptionsPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        this.jSyslogFacility = new JComboBox<String>(SYSLOG_FACILITIES);
        this.jSyslogFacility.setToolTipText(Messages.getGuiString("SyslogFacilityMeantIdentifySource"));
        this.jSyslogFacility.setEnabled(!useSyslog);
        this.jSyslogFacility.setSelectedIndex(this.findSyslogFacilityIdx(this.configuration.getLoggingSyslogFacility()));
        this.jSyslogFacilityLabel.setLabelFor(this.jSyslogFacility);
        this.jSyslogFacility.addActionListener(e -> this.configuration.setLoggingSyslogFacility(SYSLOG_FACILITIES[this.jSyslogFacility.getSelectedIndex()]));
        this.jOptionsPanel.add(this.jSyslogFacility);
        this.jOptionsPanel.setFocusTraversalPolicyProvider(true);
        builder.add(this.jOptionsPanel).at(cc.xyw(1, 3, cols));
        this.jShowOptions = new JCheckBox(Messages.getGuiString("ShowLoggingOptions"), PMS.getTraceMode() != 2 && this.configuration.getLoggingUseSyslog());
        this.jShowOptions.setHorizontalTextPosition(10);
        this.jShowOptions.setToolTipText(Messages.getGuiString("ShowLoggingConfigurationOptions"));
        this.jShowOptions.setMnemonic(71);
        this.jShowOptions.setEnabled(PMS.getTraceMode() != 2);
        this.jShowOptions.addActionListener(e -> {
            this.jOptionsPanel.setVisible(this.jShowOptions.isSelected());
            if (this.jShowOptions.isSelected()) {
                this.jBuffered.requestFocusInWindow();
            }
        });
        builder.add(this.jShowOptions).at(cc.xy(3, 4));
        JPanel pLogFileButtons = new JPanel(new FlowLayout(2));
        Map<String, String> logFiles = LoggingConfig.getLogFilePaths();
        for (Map.Entry<String, String> logger : logFiles.entrySet()) {
            CustomJButton b;
            if (logger.getKey().toLowerCase().startsWith("default.log")) {
                this.openFullLog = new CustomJButton(Messages.getGuiString("OpenFullDebugLog"));
                this.openFullLog.setMnemonic(79);
                b = this.openFullLog;
            } else {
                b = new CustomJButton(logger.getKey());
            }
            b.setToolTipText(logger.getValue());
            b.addActionListener(e -> {
                File logFile = new File(((CustomJButton)e.getSource()).getToolTipText());
                try {
                    Desktop.getDesktop().open(logFile);
                }
                catch (IOException | UnsupportedOperationException ioe) {
                    LOGGER.error("Failed to open file \"{}\" in default editor: {}", (Object)logFile, (Object)ioe);
                }
            });
            pLogFileButtons.add(b);
        }
        builder.add(pLogFileButtons).at(cc.xy(cols, 4));
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger("ROOT");
        this.rootLevelLabel = new JLabel(Messages.getGuiString("LogLevelColon") + ": ");
        this.rootLevelLabel.setDisplayedMnemonic(76);
        this.rootLevelLabel.setToolTipText(Messages.getGuiString("SetRootLoggingLevelDecides"));
        this.rootLevel = new JComboBox<String>(this.levelStrings);
        this.rootLevelLabel.setLabelFor(this.rootLevel);
        this.rootLevel.setSelectedIndex(this.findLevelsIdx(rootLogger.getLevel()));
        this.rootLevel.setToolTipText(Messages.getGuiString("SetRootLoggingLevelDecides"));
        this.rootLevel.addActionListener(e -> {
            JComboBox cb = (JComboBox)e.getSource();
            rootLogger.setLevel(LOG_LEVELS[cb.getSelectedIndex()]);
            Level newLevel = rootLogger.getLevel();
            if (newLevel.toInt() > 20000) {
                rootLogger.setLevel(Level.INFO);
            }
            LOGGER.info("Changed debug level to " + String.valueOf(newLevel));
            if (newLevel != rootLogger.getLevel()) {
                rootLogger.setLevel(newLevel);
            }
            this.configuration.setRootLogLevel(newLevel);
        });
        builder.add(this.rootLevelLabel).at(cc.xy(5, 4));
        builder.add(this.rootLevel).at(cc.xy(6, 4));
        if (PMS.getTraceMode() == 2) {
            this.rootLevel.setEnabled(false);
        }
        JPanel pLogPackButtons = new JPanel(new FlowLayout(0));
        if (PMS.getTraceMode() == 0) {
            this.rebootTrace = new CustomJButton(Messages.getGuiString("CreateTraceLogs"));
            this.rebootTrace.setToolTipText(Messages.getGuiString("RestartUniversalMediaServerTrace"));
            this.rebootTrace.setMnemonic(84);
            this.rebootTrace.addActionListener(e -> {
                int opt = JOptionPane.showConfirmDialog(null, Messages.getGuiString("ForReportingMostIssuesBest"), Messages.getGuiString("StartupLogLevelNotTrace"), 0);
                if (opt == 0) {
                    ProcessUtil.reboot("trace");
                }
            });
            pLogPackButtons.add(this.rebootTrace);
        }
        this.packDbg = new CustomJButton(Messages.getGuiString("PackDebugFiles"));
        this.packDbg.setMnemonic(80);
        this.packDbg.setToolTipText(Messages.getGuiString("PackLogConfigurationFileCompressed"));
        this.packDbg.addActionListener(e -> {
            JComponent comp = new DbgPackerComponent(PMS.get().debugPacker()).config();
            Object[] cancelStr = new String[]{Messages.getGuiString("Close")};
            JOptionPane.showOptionDialog(this.looksFrame, comp, Messages.getGuiString("Options"), -1, -1, null, cancelStr, null);
        });
        pLogPackButtons.add(this.packDbg);
        builder.add(pLogPackButtons).at(cc.xy(1, 4));
        builder.add(this.jSearchOutput).at(cc.xy(2, 4));
        JPanel builtPanel = builder.getPanel();
        builtPanel.getInputMap(2).put(KeyStroke.getKeyStroke(70, 128), "Ctrl_F");
        builtPanel.getActionMap().put("Ctrl_F", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TracesTab.this.jSearchBox.requestFocusInWindow();
            }
        });
        builtPanel.getInputMap(2).put(KeyStroke.getKeyStroke(114, 0), "F3");
        builtPanel.getActionMap().put("F3", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TracesTab.this.searchTraces();
            }
        });
        this.applyViewLevel();
        return builtPanel;
    }

    public void applyViewLevel() {
        ViewLevel viewLevel = this.looksFrame.getViewLevel();
        this.jCSSpace.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jCSSearch.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jRESpace.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jRESearch.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jMLSpace.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jMLSearch.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jLineBuffer.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jShowOptions.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jOptionsPanel.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED) && this.jShowOptions.isSelected());
        this.jBufferLabel.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jBufferSeparator.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jBufferSpace1.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jBufferSpace2.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        this.jBufferSpace3.setVisible(viewLevel.isGreaterOrEqual(ViewLevel.ADVANCED));
        if (viewLevel == ViewLevel.NORMAL) {
            this.jCSSearch.setSelected(false);
            this.configuration.setGUILogSearchCaseSensitive(false);
            this.jRESearch.setSelected(false);
            this.configuration.setGUILogSearchRegEx(false);
            this.jMLSearch.setSelected(false);
            this.configuration.setGUILogSearchMultiLine(false);
            this.jShowOptions.setSelected(false);
            this.jUseSyslog.setSelected(false);
            this.configuration.setLoggingUseSyslog(false);
        }
    }

    public void applyLanguage() {
        this.levelStrings = new String[]{Messages.getGuiString("Error"), Messages.getGuiString("Warning"), Messages.getGuiString("Info"), Messages.getGuiString("Debug"), Messages.getGuiString("Trace"), Messages.getGuiString("All"), Messages.getGuiString("Off")};
        this.jFilterLabel.setText(Messages.getGuiString("Filter") + ":");
        this.jFilterLabel.setToolTipText(Messages.getGuiString("FilterLogMessagesLogWindow"));
        int currentIndex = this.jTracesFilter.getSelectedIndex();
        this.jTracesFilter.setModel(new DefaultComboBoxModel<String>(this.levelStrings));
        this.jTracesFilter.setSelectedIndex(currentIndex);
        this.jTracesFilter.setToolTipText(Messages.getGuiString("FilterLogMessagesLogWindow"));
        this.jSearchBox.setToolTipText(Messages.getGuiString("SearchLogBelowCurrentPosition"));
        this.jSearchButton.setText(Messages.getGuiString("Search"));
        this.jSearchButton.setToolTipText(Messages.getGuiString("SearchLogBelowCurrentPosition"));
        this.jCSSearch.setText(Messages.getGuiString("CaseSensitive"));
        this.jCSSearch.setToolTipText(Messages.getGuiString("SearchOnlyTextMatchesSearch"));
        this.jRESearch.setToolTipText(Messages.getGuiString("SearchUsingRegularExpressions"));
        this.jMLSearch.setText(Messages.getGuiString("Multiline"));
        this.jMLSearch.setToolTipText(Messages.getGuiString("EnableSearchSpanMultipleLines"));
        this.jBufferLabel.setText(Messages.getGuiString("LineBuffer"));
        this.jBufferLabel.setToolTipText(Messages.getGuiString("NumberLinesLogWindowBelow"));
        this.jLineBuffer.setToolTipText(Messages.getGuiString("NumberLinesLogWindowBelow"));
        this.copyItem.setText(Messages.getGuiString("Copy"));
        this.clearItem.setText(Messages.getGuiString("Clear"));
        this.jOptionsPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1), Messages.getGuiString("LoggingOptions")), BorderFactory.createEmptyBorder(10, 5, 10, 5))));
        this.jBuffered.setText(Messages.getGuiString("BufferedLogging"));
        this.jBuffered.setToolTipText(Messages.getGuiString("EnableBufferedFileLogging"));
        this.jUseSyslog.setText(Messages.getGuiString("LogToSyslog"));
        this.jUseSyslog.setToolTipText(Messages.getGuiString("SendLogSyslogServer"));
        this.jSyslogHostLabel.setText(Messages.getGuiString("SyslogHostname"));
        this.jSyslogHostLabel.setToolTipText(Messages.getGuiString("HostNameIpAddressSend"));
        this.jSyslogHost.setToolTipText(Messages.getGuiString("HostNameIpAddressSend"));
        this.jSyslogPortLabel.setText(Messages.getGuiString("SyslogPort"));
        this.jSyslogPortLabel.setToolTipText(Messages.getGuiString("UdpPortSendSyslogMessages"));
        this.jSyslogPort.setToolTipText(Messages.getGuiString("UdpPortSendSyslogMessages"));
        this.jSyslogFacilityLabel.setText(Messages.getGuiString("SyslogFacility"));
        this.jSyslogFacilityLabel.setToolTipText(Messages.getGuiString("SyslogFacilityMeantIdentifySource"));
        this.jSyslogFacility.setToolTipText(Messages.getGuiString("SyslogFacilityMeantIdentifySource"));
        this.jShowOptions.setText(Messages.getGuiString("ShowLoggingOptions"));
        this.jShowOptions.setToolTipText(Messages.getGuiString("ShowLoggingConfigurationOptions"));
        if (this.openFullLog != null) {
            this.openFullLog.setText(Messages.getGuiString("OpenFullDebugLog"));
        }
        this.rootLevelLabel.setText(Messages.getGuiString("LogLevelColon") + ": ");
        this.rootLevelLabel.setToolTipText(Messages.getGuiString("SetRootLoggingLevelDecides"));
        currentIndex = this.rootLevel.getSelectedIndex();
        this.rootLevel.setModel(new DefaultComboBoxModel<String>(this.levelStrings));
        this.rootLevel.setSelectedIndex(currentIndex);
        this.rootLevel.setToolTipText(Messages.getGuiString("SetRootLoggingLevelDecides"));
        this.rebootTrace.setText(Messages.getGuiString("CreateTraceLogs"));
        this.rebootTrace.setToolTipText(Messages.getGuiString("RestartUniversalMediaServerTrace"));
        this.packDbg.setText(Messages.getGuiString("PackDebugFiles"));
        this.packDbg.setToolTipText(Messages.getGuiString("PackLogConfigurationFileCompressed"));
    }

    public JTextArea getList() {
        return this.jList;
    }

    public void append(String msg) {
        this.getList().append(msg);
    }

    private int findLevelsIdx(Level level) {
        for (int i = 0; i < LOG_LEVELS.length; ++i) {
            if (LOG_LEVELS[i] != level) continue;
            return i;
        }
        return -1;
    }

    private void searchTraces() {
        Document document = this.jList.getDocument();
        int flags = 64;
        String find = this.jSearchBox.getText();
        if (find.isEmpty()) {
            this.jSearchOutput.setText("");
        } else if (document.getLength() > 0) {
            if (this.jMLSearch.isSelected()) {
                flags += 40;
            }
            if (!this.jRESearch.isSelected()) {
                flags += 16;
            }
            if (!this.jCSSearch.isSelected()) {
                flags += 2;
            }
            try {
                Matcher match;
                boolean found;
                if (this.searchPattern == null || !find.equals(this.searchPattern.pattern()) || flags != this.searchPattern.flags()) {
                    this.searchPattern = Pattern.compile(find, flags);
                }
                if (!(found = (match = this.searchPattern.matcher(document.getText(0, document.getLength()))).find(this.jList.getCaretPosition())) && match.hitEnd()) {
                    found = match.find(0);
                }
                if (found) {
                    this.jList.requestFocusInWindow();
                    Rectangle viewRect = this.jList.modelToView2D(match.start()).getBounds();
                    Rectangle viewRectEnd = this.jList.modelToView2D(match.end()).getBounds();
                    if (viewRectEnd.x < viewRect.x) {
                        viewRectEnd.x = this.jList.getWidth();
                    }
                    viewRect.width = viewRectEnd.x - viewRect.x;
                    viewRect.height += viewRectEnd.y - viewRect.y;
                    this.jList.scrollRectToVisible(viewRect);
                    this.jList.setCaretPosition(match.start());
                    this.jList.moveCaretPosition(match.end());
                    this.jSearchOutput.setText("");
                } else {
                    this.jSearchOutput.setText(String.format(Messages.getGuiString("XNotFound"), this.jSearchBox.getText()));
                }
            }
            catch (PatternSyntaxException pe) {
                this.jSearchOutput.setText(String.format(Messages.getGuiString("RegexErrorX"), pe.getLocalizedMessage()));
            }
            catch (BadLocationException ex) {
                LOGGER.debug("Exception caught while searching traces list: " + String.valueOf(ex));
                this.jSearchOutput.setText(Messages.getGuiString("SearchError"));
            }
        }
    }

    private int findSyslogFacilityIdx(String facility) {
        for (int i = 0; i < SYSLOG_FACILITIES.length; ++i) {
            if (!facility.equalsIgnoreCase(SYSLOG_FACILITIES[i])) continue;
            return i;
        }
        return -1;
    }

    private static class PopupTriggerMouseListener
    extends MouseAdapter {
        private final JPopupMenu popup;
        private final JComponent component;

        public PopupTriggerMouseListener(JPopupMenu popup, JComponent component) {
            this.popup = popup;
            this.component = component;
        }

        private void showMenuIfPopupTrigger(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.popup.show(this.component, e.getX() + 3, e.getY() + 3);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.showMenuIfPopupTrigger(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.showMenuIfPopupTrigger(e);
        }
    }
}

