/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.traces;

import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import net.pms.configuration.UmsConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextAreaFIFO
extends JTextArea {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextAreaFIFO.class);
    private final Timer removeTimer;
    private int maxLines;

    public TextAreaFIFO(int lines, int removeDelayMS) {
        this.maxLines = lines;
        this.removeTimer = new Timer(removeDelayMS, e -> this.removeLines());
        this.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (TextAreaFIFO.this.removeTimer.isRunning()) {
                    return;
                }
                TextAreaFIFO.this.removeTimer.start();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public void removeLines() {
        Element root = this.getDocument().getDefaultRootElement();
        int remove = root.getElementCount() - this.maxLines;
        if (remove > 0) {
            Element line = root.getElement(remove - 1);
            try {
                this.getDocument().remove(0, line.getEndOffset());
            }
            catch (BadLocationException ble) {
                LOGGER.warn("Can't remove {} excess line{}: {}", remove, remove == 1 ? "" : "s", ble);
            }
        }
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int lines) {
        this.maxLines = lines = Math.min(Math.max(lines, UmsConfiguration.getLoggingLogsTabLinebufferMin()), UmsConfiguration.getLoggingLogsTabLinebufferMax());
    }
}

