/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.gui.tabs.status;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.metal.MetalIconFactory;
import net.pms.Messages;
import net.pms.renderers.devices.players.BasicPlayer;
import net.pms.renderers.devices.players.LogicalPlayer;
import net.pms.renderers.devices.players.PlayerState;
import net.pms.renderers.devices.players.PlaylistItem;
import net.pms.swing.SwingUtil;
import net.pms.util.UMSUtils;
import org.apache.commons.lang.StringUtils;

public class PlayerControlPanel
extends JPanel {
    private static ImageIcon addIcon;
    private static ImageIcon removeIcon;
    private static ImageIcon clearIcon;
    private static ImageIcon playIcon;
    private static ImageIcon pauseIcon;
    private static ImageIcon stopIcon;
    private static ImageIcon fwdIcon;
    private static ImageIcon rewIcon;
    private static ImageIcon nextIcon;
    private static ImageIcon prevIcon;
    private static ImageIcon volumeIcon;
    private static ImageIcon muteIcon;
    private static ImageIcon sliderIcon;
    private LogicalPlayer player;
    private AbstractAction add;
    private AbstractAction remove;
    private AbstractAction clear;
    private AbstractAction play;
    private AbstractAction stop;
    private AbstractAction next;
    private AbstractAction prev;
    private AbstractAction forward;
    private AbstractAction rewind;
    private AbstractAction mute;
    private Button position;
    private JSlider volumeSlider;
    private JTextField uri;
    private JComboBox uris;
    private boolean edited;
    private boolean playing;
    private String lasturi;
    private File pwd;
    private boolean playControl;
    private boolean volumeControl;
    private boolean expanded;
    int sliding;

    public PlayerControlPanel(final BasicPlayer player) {
        if (playIcon == null) {
            PlayerControlPanel.loadIcons();
        }
        this.player = (LogicalPlayer)player;
        final ActionListener actionListener = e -> SwingUtilities.invokeLater(() -> this.refreshPlayerState(((BasicPlayer)e.getSource()).getState()));
        player.connect(actionListener);
        int controls = player.getControls();
        this.playControl = (controls & 1) != 0;
        this.volumeControl = (controls & 2) != 0;
        this.expanded = true;
        this.sliding = 0;
        try {
            this.pwd = new File(player.getState().getUri()).getParentFile();
        }
        catch (Exception e2) {
            this.pwd = new File("");
        }
        this.setPreferredSize(new Dimension(530, 70));
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 1;
        c.insets = new Insets(6, 0, 0, 0);
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = c.weighty = 1.0;
        Toolbar ctrl = new Toolbar();
        ctrl.setLayout(new BoxLayout(ctrl, 0));
        if (this.volumeControl) {
            if (this.playControl) {
                this.addVolumeControls(ctrl);
            } else {
                ctrl.add(Box.createHorizontalGlue());
                this.addVolumeControls(ctrl);
                ctrl.add(Box.createHorizontalGlue());
                this.add((Component)ctrl, c);
            }
        }
        if (this.playControl) {
            ctrl.add(Box.createHorizontalStrut(this.volumeControl ? 55 : 140));
            this.addPlayControls(ctrl);
            ctrl.add(Box.createHorizontalGlue());
            this.addStatus(ctrl);
            this.add((Component)ctrl, c);
            ++c.gridy;
            Toolbar toolbar = new Toolbar();
            this.addUriControls(toolbar);
            this.add((Component)toolbar, c);
        }
        player.alert();
        PlayerControlPanel.getEnclosingWindow(this.getParent()).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                player.disconnect(actionListener);
            }
        });
    }

    public final void addPlayControls(Container parent) {
        this.prev = new AbstractAction("", prevIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.player.prev();
            }
        };
        parent.add(new Button(36, this.prev));
        this.rewind = new AbstractAction("", rewIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.player.rewind();
            }
        };
        parent.add(new Button(36, this.rewind));
        this.play = new AbstractAction("", playIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.setEdited(false);
                PlayerControlPanel.this.player.pressPlay(PlayerControlPanel.this.uri.getText(), null);
            }
        };
        parent.add(new Button(36, this.play));
        this.stop = new AbstractAction("", stopIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.player.pressStop();
            }
        };
        parent.add(new Button(36, this.stop));
        this.forward = new AbstractAction("", fwdIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.player.forward();
            }
        };
        parent.add(new Button(36, this.forward));
        this.next = new AbstractAction("", nextIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.player.next();
            }
        };
        parent.add(new Button(36, this.next));
    }

    public final void addStatus(final Container parent) {
        this.position = new Button(new AbstractAction(""){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.toggleView(parent);
            }
        });
        parent.add(this.position);
        this.position.setHorizontalAlignment(4);
        this.position.setToolTipText(Messages.getGuiString("ShowHideDetails"));
    }

    public final void addVolumeControls(Container parent) {
        UIDefaults defaults = UIManager.getDefaults();
        Object hti = defaults.put("Slider.horizontalThumbIcon", sliderIcon);
        Object tb = defaults.put("Slider.trackBorder", BorderFactory.createEmptyBorder());
        this.volumeSlider = new JSlider(0, 0, 100, 0);
        Dimension d = new Dimension(80, 20);
        this.volumeSlider.setPreferredSize(d);
        this.volumeSlider.setSize(d);
        this.volumeSlider.setMaximumSize(d);
        this.volumeSlider.addChangeListener(e -> {
            if (((JSlider)e.getSource()).getValueIsAdjusting()) {
                this.player.setVolume(this.volumeSlider.getValue());
                this.sliding = 3;
            }
        });
        this.volumeSlider.setFocusable(false);
        parent.add(this.volumeSlider);
        defaults.put("Slider.horizontalThumbIcon", hti);
        defaults.put("Slider.trackBorder", tb);
        this.mute = new AbstractAction("", volumeIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.player.mute();
            }
        };
        Button muteButton = new Button(this.mute);
        parent.add(muteButton);
    }

    public final void addUriControls(final Container parent) {
        this.uris = new JComboBox<PlaylistItem>(this.player.getPlaylist());
        this.uris.setMaximumRowCount(20);
        this.uris.setEditable(true);
        this.uris.setPrototypeDisplayValue("");
        this.uri = (JTextField)this.uris.getEditor().getEditorComponent();
        this.uri.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                SwingUtilities.invokeLater(() -> PlayerControlPanel.this.uri.select(0, 0));
            }
        });
        this.uri.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                PlayerControlPanel.this.setEdited(true);
                if (!PlayerControlPanel.this.playing) {
                    PlayerControlPanel.this.play.setEnabled(!StringUtils.isBlank(PlayerControlPanel.this.uri.getText()));
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changedUpdate(e);
            }
        });
        parent.add(this.uris);
        this.add = new AbstractAction("", addIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.setEdited(false);
                PlayerControlPanel.this.player.add(-1, PlayerControlPanel.this.uri.getText(), null, null, true);
            }
        };
        Button a = new Button(this.add);
        a.setToolTipText(Messages.getGuiString("AddToPlaylist"));
        parent.add(a);
        this.remove = new AbstractAction("", removeIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.player.remove(PlayerControlPanel.this.uri.getText());
            }
        };
        Button r = new Button(this.remove);
        r.setToolTipText(Messages.getGuiString("RemoveFromPlaylist"));
        parent.add(r);
        this.clear = new AbstractAction("", clearIcon){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                PlayerControlPanel.this.player.clear();
            }
        };
        Button c = new Button(this.clear);
        c.setToolTipText(Messages.getGuiString("ClearPlaylist"));
        parent.add(c);
        parent.add(new Button(new AbstractAction("", MetalIconFactory.getTreeFolderIcon()){
            private static final long serialVersionUID = -2826057503405341316L;

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser(PlayerControlPanel.this.pwd);
                fc.setFileSelectionMode(0);
                if (fc.showOpenDialog(parent) == 0) {
                    PlayerControlPanel.this.uri.setText(fc.getSelectedFile().getPath());
                    PlayerControlPanel.this.setEdited(true);
                }
                PlayerControlPanel.this.pwd = fc.getCurrentDirectory();
            }
        }));
    }

    public static Window getEnclosingWindow(Component c) {
        if (c == null) {
            return JOptionPane.getRootFrame();
        }
        if (c instanceof Window) {
            Window window = (Window)c;
            return window;
        }
        return PlayerControlPanel.getEnclosingWindow(c.getParent());
    }

    public BasicPlayer getPlayer() {
        return this.player;
    }

    public void setEdited(boolean b) {
        this.edited = b;
        this.updatePlaylist();
    }

    public void updatePlaylist() {
        boolean empty = this.uris.getModel().getSize() == 0;
        this.add.setEnabled((this.edited || empty) && StringUtils.isNotBlank(this.uri.getText()));
        this.remove.setEnabled(!empty);
        this.clear.setEnabled(!empty);
        boolean more = this.uris.getModel().getSize() > 1;
        this.next.setEnabled(more);
        this.prev.setEnabled(more);
        this.edited = false;
    }

    public void refreshPlayerState(PlayerState state) {
        if (this.playControl) {
            this.playing = !state.isStopped();
            this.play.putValue("SmallIcon", state.isPlaying() ? pauseIcon : playIcon);
            this.stop.setEnabled(this.playing);
            this.forward.setEnabled(this.playing);
            this.rewind.setEnabled(this.playing);
            this.position.setText(UMSUtils.playedDurationStr(state.getPosition(), state.getDuration()));
            boolean isNew = !StringUtils.isBlank(state.getUri()) && !state.getUri().equals(this.lasturi);
            this.lasturi = state.getUri();
            if (isNew) {
                if (this.edited) {
                    this.player.add(-1, this.uri.getText(), null, null, false);
                    this.setEdited(false);
                }
                this.uri.setText(state.getName());
            }
            this.play.setEnabled(this.playing || !StringUtils.isBlank(this.uri.getText()));
            this.updatePlaylist();
        }
        if (this.volumeControl) {
            this.mute.putValue("SmallIcon", state.isMuted() ? muteIcon : volumeIcon);
            this.volumeSlider.setEnabled(!state.isMuted());
            if (--this.sliding < 0) {
                this.volumeSlider.setValue(state.getVolume());
            }
        }
    }

    private static void loadIcons() {
        addIcon = PlayerControlPanel.getImageIcon("add.svg");
        removeIcon = PlayerControlPanel.getImageIcon("remove.svg");
        clearIcon = PlayerControlPanel.getImageIcon("clear.svg");
        playIcon = PlayerControlPanel.getImageIcon("play.svg");
        pauseIcon = PlayerControlPanel.getImageIcon("pause.svg");
        stopIcon = PlayerControlPanel.getImageIcon("stop.svg");
        fwdIcon = PlayerControlPanel.getImageIcon("fwd.svg");
        rewIcon = PlayerControlPanel.getImageIcon("rew.svg");
        nextIcon = PlayerControlPanel.getImageIcon("next.svg");
        prevIcon = PlayerControlPanel.getImageIcon("prev.svg");
        volumeIcon = PlayerControlPanel.getImageIcon("vol.svg");
        muteIcon = PlayerControlPanel.getImageIcon("mute.svg");
        sliderIcon = PlayerControlPanel.getImageIcon("bar.svg");
    }

    public static ImageIcon getImageIcon(String filename) {
        return SwingUtil.getImageIcon("swing/player/" + filename);
    }

    public void toggleView(Component child) {
        Container anchor = child.getParent();
        anchor.setPreferredSize(anchor.getSize());
        this.expanded = !this.expanded;
        for (Component c : anchor.getParent().getComponents()) {
            if (c == anchor) continue;
            c.setVisible(this.expanded);
        }
        int y = (int)anchor.getLocation().getY();
        JFrame top = (JFrame)SwingUtilities.getWindowAncestor(this);
        top.setVisible(false);
        top.pack();
        Point p = top.getLocation();
        top.setLocation((int)p.getX(), y - (int)anchor.getLocation().getY() + (int)p.getY());
        top.setVisible(true);
    }

    static class Toolbar
    extends JToolBar {
        private static final long serialVersionUID = -657958964967514184L;

        public Toolbar() {
            super(0);
            this.setFloatable(false);
            this.setRollover(true);
            this.setOpaque(false);
            this.setBorderPainted(false);
        }
    }

    static class Button
    extends JButton {
        private static final long serialVersionUID = 8649059925768844933L;

        public Button(Action a) {
            this(0, a);
        }

        public Button(int width, Action a) {
            super(a);
            if (width > 0) {
                this.setPreferredSize(new Dimension(width, 30));
            }
            this.setFocusable(false);
        }
    }
}

