/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing.components;

import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AbstractMultiResolutionImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;
import net.pms.swing.components.SvgTranscoder;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.util.XMLResourceDescriptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.svg.SVGDocument;

public class SvgMultiResolutionImage
extends AbstractMultiResolutionImage {
    private static final Logger LOGGER = LoggerFactory.getLogger(SvgMultiResolutionImage.class);
    private static final SAXSVGDocumentFactory FACTORY = new SAXSVGDocumentFactory(XMLResourceDescriptor.getXMLParserClassName());
    private final SVGDocument svg;
    private final ImageFilter filter;
    private final Image baseImage;
    private final List<Image> variants = new ArrayList<Image>();

    public SvgMultiResolutionImage(SVGDocument svg, ImageFilter filter, Float width, Float height) {
        this.svg = svg;
        this.filter = filter;
        this.baseImage = SvgMultiResolutionImage.getResolutionVariant(svg, filter, width, height);
        if (this.baseImage != null) {
            this.variants.add(this.baseImage);
        }
    }

    public SvgMultiResolutionImage(SVGDocument svg, ImageFilter filter) {
        this(svg, filter, null, null);
    }

    public SvgMultiResolutionImage(SVGDocument svg) {
        this(svg, null);
    }

    public SvgMultiResolutionImage(URL imageResource) {
        this(SvgMultiResolutionImage.getSVGDocument(imageResource));
    }

    public SvgMultiResolutionImage(InputStream imageStream) {
        this(SvgMultiResolutionImage.getSVGDocument(imageStream));
    }

    public SvgMultiResolutionImage(URL imageResource, int width, int height) {
        this(SvgMultiResolutionImage.getSVGDocument(imageResource), null, Float.valueOf(width), Float.valueOf(height));
    }

    @Override
    public Image getBaseImage() {
        return this.baseImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getResolutionVariant(double destImageWidth, double destImageHeight) {
        List<Image> list = this.variants;
        synchronized (list) {
            for (Image variant : this.variants) {
                if ((double)variant.getHeight(null) != destImageHeight || (double)variant.getWidth(null) != destImageHeight) continue;
                return variant;
            }
            Image variant = SvgMultiResolutionImage.getResolutionVariant(this.svg, this.filter, Float.valueOf((float)destImageWidth), Float.valueOf((float)destImageHeight));
            this.variants.add(variant);
            return variant;
        }
    }

    @Override
    public List<Image> getResolutionVariants() {
        return Collections.unmodifiableList(this.variants);
    }

    public ImageIcon toImageIcon() {
        return new ImageIcon(this);
    }

    public SVGDocument getSVGDocument() {
        return this.svg;
    }

    public static SVGDocument getSVGDocument(URL imageResource) {
        try {
            return SvgMultiResolutionImage.getSVGDocument(imageResource.openStream());
        }
        catch (IOException ex) {
            LOGGER.error("SVG MultiResolution error", ex);
            return null;
        }
    }

    private static SVGDocument getSVGDocument(InputStream imageStream) {
        try {
            return FACTORY.createSVGDocument(null, imageStream);
        }
        catch (IOException ex) {
            LOGGER.error("SVG MultiResolution error", ex);
            return null;
        }
    }

    private static Image getResolutionVariant(SVGDocument svg, ImageFilter filter, Float destImageWidth, Float destImageHeight) {
        if (svg == null) {
            return null;
        }
        SvgTranscoder t = new SvgTranscoder();
        if (destImageWidth != null && destImageHeight != null) {
            Element elem;
            t.addTranscodingHint(SvgTranscoder.KEY_WIDTH, destImageWidth);
            t.addTranscodingHint(SvgTranscoder.KEY_HEIGHT, destImageHeight);
            float height = svg.getRootElement().getHeight().getBaseVal().getValue();
            float width = svg.getRootElement().getWidth().getBaseVal().getValue();
            if ((destImageWidth.floatValue() < width || destImageHeight.floatValue() < height) && (elem = svg.getElementById("small")) != null) {
                elem.setAttribute("opacity", "1");
            }
        }
        try {
            TranscoderInput input = new TranscoderInput(svg);
            t.transcode(input, null);
            Image variant = t.getBufferedImage();
            if (filter != null && variant != null) {
                FilteredImageSource producer = new FilteredImageSource(((Image)variant).getSource(), filter);
                variant = Toolkit.getDefaultToolkit().createImage(producer);
            }
            return variant;
        }
        catch (TranscoderException ex) {
            LOGGER.error("SVG Transcoder error", ex);
            return null;
        }
    }
}

