/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.sun.jna.Platform;
import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.image.BaseMultiResolutionImage;
import java.net.URL;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.text.JTextComponent;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.swing.components.SvgMultiResolutionImage;
import net.pms.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SwingUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwingUtil.class);
    private static final Object LOOK_AND_FEEL_INITIALIZED_LOCK = new Object();
    private static final String WINDOWS_LNF = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private static final String PLASTICXP_LNF = "com.jgoodies.looks.plastic.PlasticXPLookAndFeel";
    private static final String METAL_LNF = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String GTK_LNF = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    public static final boolean HDPI_AWARE = true;
    private static boolean lookAndFeelInitialized = false;

    private SwingUtil() {
    }

    public static boolean isHeadless() {
        try {
            JDialog d = new JDialog();
            d.dispose();
            return false;
        }
        catch (HeadlessException | InternalError | NoClassDefFoundError e) {
            return true;
        }
    }

    public static boolean askYesNoMessage(Object message, String title, boolean defaultValue) {
        if (!PMS.isHeadless()) {
            Object[] yesNoOptions = new Object[]{Messages.getGuiString("Yes"), Messages.getGuiString("No")};
            int result = JOptionPane.showOptionDialog(null, message, title, 0, 3, null, yesNoOptions, defaultValue ? yesNoOptions[0] : yesNoOptions[1]);
            return result == 0;
        }
        return defaultValue;
    }

    public static boolean initDefaultToolkit() {
        try {
            Toolkit.getDefaultToolkit();
            return true;
        }
        catch (AWTError t) {
            LOGGER.error("Toolkit error: " + t.getClass().getName() + ": " + t.getMessage());
            return false;
        }
    }

    public static JComponent getPreferredSizeComponent(JComponent component) {
        JPanel pWrap = new JPanel(new BorderLayout());
        pWrap.add((Component)component, "West");
        return pWrap;
    }

    public static void enableContainer(Container c, boolean enable) {
        for (Component component : c.getComponents()) {
            component.setEnabled(enable);
            if (!(component instanceof Container)) continue;
            Container container = (Container)component;
            SwingUtil.enableContainer(container, enable);
        }
    }

    public static URL getImageResource(String filename) {
        return SwingUtil.class.getResource("/resources/images/" + filename);
    }

    public static Image getImage(String filename) {
        URL url = SwingUtil.getImageResource(filename);
        if (url != null) {
            String[] resolutions;
            if ("svg".equalsIgnoreCase(FileUtil.getExtension(filename))) {
                return new SvgMultiResolutionImage(url);
            }
            Image img = new ImageIcon(url).getImage();
            ArrayList<Image> images = new ArrayList<Image>();
            images.add(img);
            for (String resolution : resolutions = new String[]{"@1.25x", "@1.5x", "@1.75x", "@2x", "@2.25x", "@2.5x", "@2.75x", "@3x", "@3.25x", "@3.5x", "@3.75x", "@4x"}) {
                url = SwingUtil.getImageResource(FileUtil.appendToFileName(filename, resolution));
                if (url == null) continue;
                images.add(new ImageIcon(url).getImage());
            }
            if (images.size() > 1) {
                return new BaseMultiResolutionImage((Image[])images.toArray(Image[]::new));
            }
            return img;
        }
        return null;
    }

    public static ImageIcon getImageIcon(String filename) {
        Image image = SwingUtil.getImage(filename);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public static Image getAppIconImage() {
        return new SvgMultiResolutionImage(SwingUtil.getImageResource("icon.svg"));
    }

    public static Dimension getWordWrappedTextDimension(JTextComponent textComponent, int width, String text) {
        String[] paragraphs;
        if (textComponent == null) {
            throw new IllegalArgumentException("textComponent cannot be null");
        }
        if (width < 1) {
            throw new IllegalArgumentException("width must be 1 or greater");
        }
        if (text == null) {
            text = textComponent.getText();
        }
        if (text.isEmpty()) {
            return new Dimension(width, 0);
        }
        FontMetrics metrics = textComponent.getFontMetrics(textComponent.getFont());
        FontRenderContext rendererContext = metrics.getFontRenderContext();
        int formatWidth = width - textComponent.getInsets().left - textComponent.getInsets().right;
        int lines = 0;
        for (String paragraph : paragraphs = text.split("\n")) {
            if (paragraph.isEmpty()) {
                ++lines;
                continue;
            }
            AttributedString attributedText = new AttributedString(paragraph);
            attributedText.addAttribute(TextAttribute.FONT, textComponent.getFont());
            AttributedCharacterIterator charIterator = attributedText.getIterator();
            LineBreakMeasurer lineMeasurer = new LineBreakMeasurer(charIterator, rendererContext);
            lineMeasurer.setPosition(charIterator.getBeginIndex());
            while (lineMeasurer.getPosition() < charIterator.getEndIndex()) {
                lineMeasurer.nextLayout(formatWidth);
                ++lines;
            }
        }
        return new Dimension(width, metrics.getHeight() * lines + textComponent.getInsets().top + textComponent.getInsets().bottom);
    }

    public static Dimension getWordWrappedTextDimension(JTextComponent textComponent, int width) {
        return SwingUtil.getWordWrappedTextDimension(textComponent, width, null);
    }

    public static float getComponentAverageCharacterWidth(Component component) {
        FontMetrics metrics = component.getFontMetrics(component.getFont());
        int i = 0;
        float avgWidth = 0.0f;
        for (int width : metrics.getWidths()) {
            avgWidth += (float)width;
            ++i;
        }
        return i == 0 ? 0.0f : avgWidth / (float)i;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initializeLookAndFeel() {
        Object object = LOOK_AND_FEEL_INITIALIZED_LOCK;
        synchronized (object) {
            if (lookAndFeelInitialized) {
                return;
            }
            if (Platform.isWindows()) {
                try {
                    UIManager.setLookAndFeel(WINDOWS_LNF);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    LOGGER.error("Error while setting Windows look and feel: ", e);
                }
            } else if (System.getProperty("nativelook") == null && !Platform.isMac()) {
                try {
                    UIManager.setLookAndFeel(PLASTICXP_LNF);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                    LOGGER.error("Error while setting Plastic XP look and feel: ", e);
                }
            } else {
                try {
                    String systemClassName = UIManager.getSystemLookAndFeelClassName();
                    if (!Platform.isMac()) {
                        try {
                            Class.forName(GTK_LNF);
                            if (systemClassName.equals(METAL_LNF)) {
                                systemClassName = GTK_LNF;
                            }
                        }
                        catch (ClassNotFoundException ce) {
                            LOGGER.error("Error loading GTK look and feel: ", ce);
                        }
                    }
                    LOGGER.trace("Choosing Java look and feel: " + systemClassName);
                    UIManager.setLookAndFeel(systemClassName);
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e1) {
                    try {
                        UIManager.setLookAndFeel(PLASTICXP_LNF);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException | UnsupportedLookAndFeelException e) {
                        LOGGER.error("Error while setting Plastic XP look and feel: ", e);
                    }
                    LOGGER.error("Error while setting native look and feel: ", e1);
                }
            }
            if (SwingUtil.isParticularLaFSet(UIManager.getLookAndFeel(), PLASTICXP_LNF)) {
                PlasticLookAndFeel.setPlasticTheme(PlasticLookAndFeel.createMyDefaultTheme());
                PlasticLookAndFeel.setTabStyle("default");
                PlasticLookAndFeel.setHighContrastFocusColorsEnabled(false);
            } else if (SwingUtil.isParticularLaFSet(UIManager.getLookAndFeel(), METAL_LNF)) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            JRadioButton radio = new JRadioButton();
            radio.getUI().uninstallUI(radio);
            JCheckBox checkBox = new JCheckBox();
            checkBox.getUI().uninstallUI(checkBox);
            if (SwingUtil.isParticularLaFSet(UIManager.getLookAndFeel(), WINDOWS_LNF)) {
                UIManager.put("FileChooser.useSystemExtensionHiding", false);
            }
            lookAndFeelInitialized = true;
        }
    }

    private static boolean isParticularLaFSet(LookAndFeel lnf, String lookAndFeelClassPath) {
        if (lnf == null) {
            return false;
        }
        try {
            Class<?> c = Class.forName(lookAndFeelClassPath);
            return c.isInstance(lnf);
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }

    private static /* synthetic */ Image[] lambda$getAppIconImage$1(int x$0) {
        return new Image[x$0];
    }
}

