/*
 * Decompiled with CFR 0.152.
 */
package net.pms.swing;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.Timer;
import net.pms.Messages;
import net.pms.configuration.GuiConfiguration;
import net.pms.configuration.UmsConfiguration;
import net.pms.swing.SwingUtil;
import net.pms.swing.components.SvgMultiResolutionImage;
import org.apache.commons.configuration.ConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Splash
extends JFrame {
    private static final Logger LOGGER = LoggerFactory.getLogger(Splash.class);
    private static Splash instance = null;
    private final transient Object optionLock = new Object();
    private JLabel imageLabel;
    private JLabel statusLabel;
    private String status;
    private String dots;
    private Timer timer;

    public Splash(final @Nonnull UmsConfiguration configuration, @Nullable GraphicsConfiguration graphicsConfiguration) {
        super(graphicsConfiguration);
        if (!configuration.isShowSplashScreen() || System.getProperty("console") != null) {
            return;
        }
        ImageIcon image = new SvgMultiResolutionImage(SwingUtil.getImageResource("splash/splash.svg"), 512, 256).toImageIcon();
        this.imageLabel = new JLabel(image);
        this.imageLabel.setBounds(0, 0, image.getIconWidth(), image.getIconHeight());
        this.setSize(this.imageLabel.getWidth(), this.imageLabel.getHeight());
        this.setUndecorated(true);
        this.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.add(this.imageLabel);
        this.imageLabel.addMouseListener(new MouseAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mouseClicked(MouseEvent e) {
                Object object = Splash.this.optionLock;
                synchronized (object) {
                    int isShowSplashScreen = JOptionPane.showConfirmDialog(Splash.this.imageLabel, Messages.getGuiString("DisableSplashScreenDuringStartup"), Messages.getGuiString("SplashScreenSetting"), 0, 3);
                    if (isShowSplashScreen == 0) {
                        configuration.setShowSplashScreen(false);
                        try {
                            configuration.save();
                        }
                        catch (ConfigurationException e1) {
                            LOGGER.error("Error when saving the Splash Screen setting", e1);
                        }
                    }
                }
            }
        });
        this.setIconImage(SwingUtil.getImage("icon.svg"));
        this.statusLabel = new JLabel();
        this.statusLabel.setFont(new Font("SansSerif", 1, 10));
        this.statusLabel.setSize(this.imageLabel.getWidth(), 12);
        this.statusLabel.setBackground(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        this.statusLabel.setForeground(Color.WHITE);
        this.statusLabel.setHorizontalAlignment(0);
        this.statusLabel.setLocation(0, (int)((double)this.imageLabel.getHeight() / 1.2));
        this.imageLabel.add(this.statusLabel);
        Rectangle bounds = this.getGraphicsConfiguration().getBounds();
        this.setLocation(bounds.x + (bounds.width - this.getWidth()) / 2, bounds.y + (bounds.height - this.getHeight()) / 2);
        this.setVisible(true);
        this.timer = new Timer(500, e -> {
            if (this.status != null) {
                this.dots = this.dots.length() == 3 ? "" : this.dots + ".";
                this.statusLabel.setText(this.status + this.dots);
            }
        });
        this.timer.setInitialDelay(500);
        this.timer.start();
    }

    public void setText(String text) {
        this.status = text;
        this.dots = "";
        if (this.statusLabel != null) {
            this.statusLabel.setText(this.status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.imageLabel != null) {
            this.imageLabel.setVisible(false);
        }
        if (this.statusLabel != null) {
            this.statusLabel.setVisible(false);
        }
        if (this.timer != null) {
            this.timer.stop();
        }
        Object object = this.optionLock;
        synchronized (object) {
            super.dispose();
        }
    }

    public static void create(UmsConfiguration configuration, GuiConfiguration conf) {
        if (instance == null) {
            instance = new Splash(configuration, conf.getGraphicsConfiguration());
        }
    }

    public static void setStatusMessage(String text) {
        if (instance != null) {
            instance.setText(Messages.getGuiString(text));
        }
    }

    public static void setStatus(String text) {
        if (instance != null) {
            instance.setText(text);
        }
    }

    public static void showSplash(boolean value) {
        if (instance != null) {
            instance.setVisible(value);
        }
    }

    public static void disposeSplash() {
        if (instance != null) {
            instance.dispose();
        }
    }
}

