/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.item;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.pms.Messages;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.formats.FormatFactory;
import net.pms.formats.ISOVOB;
import net.pms.media.MediaInfo;
import net.pms.parsers.MPlayerParser;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.FileUtil;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;

public class DVDISOTitle
extends StoreItem {
    private final File file;
    private final int title;
    private final String parentName;
    private long length;

    public DVDISOTitle(Renderer renderer, File file, String parentName, int title) {
        super(renderer);
        this.file = file;
        this.title = title;
        this.parentName = parentName;
        this.setLastModified(file.lastModified());
    }

    @Override
    protected void resolveOnce() {
        if (this.getMediaInfo() == null) {
            MediaInfo media = new MediaInfo();
            MPlayerParser.parseDvdTitle(media, this.file, this.title);
            this.setMediaInfo(media);
            this.length = media.getSize();
        }
    }

    public long getLength() {
        return this.length;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return null;
    }

    @Override
    public String getName() {
        return (String)(StringUtils.isBlank(this.parentName) ? "" : this.parentName + " ") + Messages.getString("Title") + " " + this.title;
    }

    @Override
    public String getSystemName() {
        return this.file.getAbsolutePath() + File.separator + "Title " + this.title;
    }

    @Override
    public String getFileName() {
        return this.file.getAbsolutePath();
    }

    @Override
    public boolean isValid() {
        if (this.getFormat() == null) {
            this.setFormat(FormatFactory.getFormat(ISOVOB.class));
        }
        return true;
    }

    @Override
    public long length() {
        int cbrVideoBitrate = this.getDefaultRenderer().getCBRVideoBitrate();
        return cbrVideoBitrate > 0 ? (long)((double)((cbrVideoBitrate + 256) * 1024) / 8.0 * 1.04 * this.getMediaInfo().getDurationInSeconds()) : 0x7FFFFFFF7FFFFFFFL;
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        File cachedThumbnail = null;
        File thumbFolder = null;
        boolean alternativeCheck = false;
        while (cachedThumbnail == null) {
            if (thumbFolder == null) {
                thumbFolder = this.file.getParentFile();
            }
            if ((cachedThumbnail = FileUtil.replaceExtension(thumbFolder, this.file, "jpg", true, true)) == null) {
                cachedThumbnail = FileUtil.replaceExtension(thumbFolder, this.file, "png", true, true);
            }
            if (cachedThumbnail == null) {
                cachedThumbnail = FileUtil.getFileNameWithAddedExtension(thumbFolder, this.file, ".cover.jpg");
            }
            if (cachedThumbnail == null) {
                cachedThumbnail = FileUtil.getFileNameWithAddedExtension(thumbFolder, this.file, ".cover.png");
            }
            if (alternativeCheck || StringUtils.isNotBlank(this.renderer.getUmsConfiguration().getAlternateThumbFolder()) && !(thumbFolder = new File(this.renderer.getUmsConfiguration().getAlternateThumbFolder())).isDirectory()) break;
            alternativeCheck = true;
        }
        if (cachedThumbnail != null) {
            return DLNAThumbnailInputStream.toThumbnailInputStream(new FileInputStream(cachedThumbnail));
        }
        if (this.getMediaInfo() != null && this.getMediaInfo().getThumbnail() != null) {
            return this.getMediaInfo().getThumbnailInputStream();
        }
        return this.getGenericThumbnailInputStream(null);
    }

    @Override
    public String getDisplayNameSuffix() {
        Object nameSuffix = super.getDisplayNameSuffix();
        if (this.getMediaInfo() != null && this.getMediaInfo().getDurationInSeconds() > 0.0 && this.renderer.isShowDVDTitleDuration()) {
            nameSuffix = (String)nameSuffix + " (" + StringUtil.convertTimeToString(this.getMediaInfo().getDurationInSeconds(), "%01d:%02d:%02.0f") + ")";
        }
        return nameSuffix;
    }
}

