/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.pms.configuration.sharedcontent.VirtualFolderContent;
import net.pms.formats.Format;
import net.pms.formats.FormatFactory;
import net.pms.renderers.Renderer;
import net.pms.store.FileSearch;
import net.pms.store.StoreContainer;
import net.pms.store.StoreResource;
import net.pms.store.SystemFileResource;
import net.pms.store.SystemFilesHelper;
import net.pms.store.container.RealFolder;
import net.pms.store.container.SearchFolder;
import net.pms.store.item.RealFile;
import net.pms.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualFolder
extends StoreContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(VirtualFolder.class);
    private final String forcedName;
    private final List<File> files;
    private final List<VirtualFolderContent> virtualFolders;
    private List<File> discoverable;
    private List<File> emptyFoldersToRescan;
    private boolean addToMediaLibrary = true;
    private ArrayList<StoreResource> searchList;
    private File potentialCover;

    public VirtualFolder(Renderer renderer) {
        super(renderer, null, null);
        this.setChildrenSorted(true);
        this.files = new ArrayList<File>();
        this.virtualFolders = new ArrayList<VirtualFolderContent>();
        this.forcedName = null;
        this.setLastModified(0L);
    }

    public VirtualFolder(Renderer renderer, VirtualFolderContent virtualFolder) {
        super(renderer, virtualFolder.getName(), null);
        this.setChildrenSorted(true);
        this.addToMediaLibrary = virtualFolder.isAddToMediaLibrary();
        this.files = virtualFolder.getFiles();
        this.virtualFolders = virtualFolder.getVirtualFolders();
        this.forcedName = null;
        this.setLastModified(0L);
    }

    public VirtualFolder(Renderer renderer, VirtualFolder virtualFile, List<File> files, String forcedName) {
        super(renderer, null, null);
        this.setChildrenSorted(true);
        this.addToMediaLibrary = virtualFile.isAddToMediaLibrary();
        this.files = virtualFile.getFiles();
        this.virtualFolders = new ArrayList<VirtualFolderContent>();
        this.discoverable = files;
        this.forcedName = forcedName;
        this.setLastModified(0L);
        this.analyzeChildren();
    }

    public List<File> getFiles() {
        return this.files;
    }

    public void addFile(File file) {
        this.files.add(file);
    }

    private void manageFile(File f) {
        StoreResource res = this.renderer.getMediaStore().createResourceFromFile(f);
        if (res != null) {
            if (res instanceof RealFile) {
                RealFile realfile = (RealFile)res;
                realfile.setAddToMediaLibrary(this.addToMediaLibrary);
                if (this.searchList != null) {
                    this.searchList.add(realfile);
                }
            }
            if (res instanceof RealFolder) {
                RealFolder realFolder = (RealFolder)res;
                realFolder.setAddToMediaLibrary(this.addToMediaLibrary);
                if (this.searchList != null) {
                    this.searchList.add(realFolder);
                }
            }
            this.addChild(res, true, true);
        } else if (f.isDirectory() && this.renderer.getUmsConfiguration().isHideEmptyFolders() && !FileUtil.isFolderRelevant(f, this.renderer.getUmsConfiguration())) {
            if (this.emptyFoldersToRescan == null) {
                this.emptyFoldersToRescan = new ArrayList<File>();
            }
            if (!this.emptyFoldersToRescan.contains(f)) {
                this.emptyFoldersToRescan.add(f);
            }
        }
    }

    private File getPath() {
        VirtualFolder virtualFolder = this;
        if (virtualFolder instanceof SystemFileResource) {
            SystemFileResource systemFileResource = (SystemFileResource)((Object)virtualFolder);
            return systemFileResource.getSystemFile();
        }
        return null;
    }

    private List<File> getFilesListForDirectories() {
        ArrayList<File> out = new ArrayList<File>();
        List<String> ignoredDirectoryNames = this.renderer.getUmsConfiguration().getIgnoredFolderNames();
        for (File directory : this.getFiles()) {
            String directoryName;
            String string = directoryName = directory == null || directory.getName() == null ? "unnamed" : directory.getName();
            if (directory == null || !directory.isDirectory()) {
                LOGGER.trace("Ignoring {} because it is not a valid directory", (Object)directoryName);
                continue;
            }
            if (!ignoredDirectoryNames.isEmpty() && ignoredDirectoryNames.contains(directoryName)) {
                LOGGER.debug("Ignoring {} because it is in the ignored directories list", (Object)directoryName);
                continue;
            }
            if (directory.canRead()) {
                File[] listFiles = directory.listFiles(file -> {
                    if (!file.canRead()) {
                        LOGGER.trace("Ignoring '{}' because it is unreadable", (Object)file);
                        return false;
                    }
                    String filename = file.getName();
                    if (file.isDirectory()) {
                        boolean ignored;
                        boolean bl = ignored = !ignoredDirectoryNames.isEmpty() && ignoredDirectoryNames.contains(filename);
                        if (ignored) {
                            LOGGER.debug("Ignoring '{}' because it is in the ignored directories list", (Object)file);
                        }
                        return !ignored;
                    }
                    boolean isMediaFile = SystemFilesHelper.isPotentialMediaFile(filename);
                    if (!isMediaFile) {
                        LOGGER.trace("Ignoring '{}' because it is not a media file", (Object)file);
                    }
                    return isMediaFile;
                });
                if (listFiles == null) {
                    LOGGER.warn("Can't read files from directory: {}", (Object)directory.getAbsolutePath());
                    continue;
                }
                out.addAll(Arrays.asList(listFiles));
                continue;
            }
            LOGGER.warn("Can't read directory: {}", (Object)directory.getAbsolutePath());
        }
        return out;
    }

    private boolean analyzeChildren() {
        FileSearch fs = null;
        if (!this.discoverable.isEmpty() && this.renderer.getUmsConfiguration().getSearchInFolder()) {
            this.searchList = new ArrayList();
            fs = new FileSearch(this.searchList);
            this.addChild(new SearchFolder(this.renderer, fs));
        }
        for (VirtualFolderContent virtualFolder : this.virtualFolders) {
            StoreContainer parent = this.getSharedContentParent(virtualFolder.getParent());
            parent.addChild(new VirtualFolder(this.renderer, virtualFolder), true, true);
        }
        while (!this.discoverable.isEmpty()) {
            this.manageFile(this.discoverable.remove(0));
        }
        if (fs != null) {
            fs.update(this.searchList);
        }
        return this.discoverable.isEmpty();
    }

    @Override
    public synchronized void discoverChildren() {
        if (this.discoverable != null) {
            return;
        }
        this.discoverable = new ArrayList<File>();
        this.getChildren().clear();
        List<File> childrenFiles = this.getFilesListForDirectories();
        HashSet<File> images = new HashSet<File>();
        HashSet<File> audioVideo = new HashSet<File>();
        Iterator<File> iterator = childrenFiles.iterator();
        while (iterator.hasNext()) {
            File file = iterator.next();
            if (!file.isFile()) continue;
            if (SystemFilesHelper.isPotentialThumbnail(file.getName())) {
                if (SystemFilesHelper.isFolderThumbnail(file, false)) {
                    this.potentialCover = file;
                    iterator.remove();
                    continue;
                }
                images.add(file);
                continue;
            }
            Format format = FormatFactory.getAssociatedFormat(file.getAbsolutePath());
            if (format == null || !format.isAudio() && !format.isVideo()) continue;
            audioVideo.add(file);
        }
        if (!images.isEmpty() && !audioVideo.isEmpty()) {
            for (File file : audioVideo) {
                Set<File> potentialMatches = SystemFilesHelper.getPotentialFileThumbnails(file, false);
                iterator = images.iterator();
                while (iterator.hasNext()) {
                    File imageFile = iterator.next();
                    if (!potentialMatches.contains(imageFile)) continue;
                    iterator.remove();
                    childrenFiles.remove(imageFile);
                }
            }
        }
        if (childrenFiles.size() > this.renderer.getUmsConfiguration().getATZLimit() && StringUtils.isEmpty(this.forcedName)) {
            TreeMap<String, ArrayList<File>> map = new TreeMap<String, ArrayList<File>>();
            for (File file : childrenFiles) {
                ArrayList<File> l;
                if (!file.isFile() && !file.isDirectory() || file.isHidden() || !file.canRead()) continue;
                if (file.isDirectory() && this.renderer.getUmsConfiguration().isHideEmptyFolders() && !FileUtil.isFolderRelevant(file, this.renderer.getUmsConfiguration())) {
                    LOGGER.debug("Ignoring empty/non-relevant directory: " + file.getName());
                    if (this.emptyFoldersToRescan == null) {
                        this.emptyFoldersToRescan = new ArrayList<File>();
                    }
                    if (this.emptyFoldersToRescan.contains(file)) continue;
                    this.emptyFoldersToRescan.add(file);
                    continue;
                }
                String filenameToSort = FileUtil.renameForSorting(file.getName(), false, file.getAbsolutePath());
                char c = filenameToSort.toUpperCase().charAt(0);
                if (c < 'A' || c > 'Z') {
                    c = '#';
                }
                if ((l = (ArrayList<File>)map.get(String.valueOf(c))) == null) {
                    l = new ArrayList<File>();
                }
                l.add(file);
                map.put(String.valueOf(c), l);
            }
            if (map.size() > 1) {
                for (Map.Entry entry : map.entrySet()) {
                    VirtualFolder mf = new VirtualFolder(this.renderer, this, (List)entry.getValue(), (String)entry.getKey());
                    this.addChild(mf, true, true);
                }
                return;
            }
        }
        for (File f : childrenFiles) {
            if (!f.isDirectory()) continue;
            this.discoverable.add(f);
        }
        for (File f : childrenFiles) {
            if (!f.isFile()) continue;
            this.discoverable.add(f);
        }
        this.setDiscovered(this.analyzeChildren());
        this.sortChildrenIfNeeded();
        this.setLastRefreshTime(System.currentTimeMillis());
    }

    public File getPotentialCover() {
        return this.potentialCover;
    }

    public void setPotentialCover(File potentialCover) {
        this.potentialCover = potentialCover;
    }

    @Override
    public boolean isRefreshNeeded() {
        long modified = 0L;
        for (File f : this.getFiles()) {
            if (f == null) continue;
            modified = Math.max(modified, f.lastModified());
        }
        boolean emptyFolderNowNotEmpty = false;
        if (this.emptyFoldersToRescan != null) {
            for (File emptyFile : this.emptyFoldersToRescan) {
                if (!FileUtil.isFolderRelevant(emptyFile, this.renderer.getUmsConfiguration())) continue;
                emptyFolderNowNotEmpty = true;
                break;
            }
        }
        return this.getLastRefreshTime() < modified || this.renderer.getUmsConfiguration().getSortMethod(this.getPath()) == 5 || emptyFolderNowNotEmpty;
    }

    @Override
    public synchronized void doRefreshChildren() {
        this.emptyFoldersToRescan = null;
        this.discoverable = null;
        this.discoverChildren();
    }

    @Override
    public boolean isSearched() {
        return this.getParent() instanceof SearchFolder;
    }

    public void setAddToMediaLibrary(boolean value) {
        this.addToMediaLibrary = value;
    }

    @Override
    public boolean isAddToMediaLibrary() {
        return this.addToMediaLibrary;
    }

    @Override
    public String getName() {
        if (StringUtils.isEmpty(this.forcedName)) {
            return super.getName();
        }
        return this.forcedName;
    }

    @Override
    public boolean allowScan() {
        return true;
    }
}

