/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import net.pms.renderers.Renderer;
import net.pms.store.SearchObj;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.container.Search;
import net.pms.store.container.SearchAction;

public class SearchFolder
extends LocalizedStoreContainer {
    private SearchObj sobj;

    public SearchFolder(Renderer renderer, SearchObj sobj) {
        this(renderer, "Search", sobj);
    }

    public SearchFolder(Renderer renderer, String i18nName, SearchObj sobj) {
        super(renderer, i18nName);
        this.sobj = sobj;
    }

    private void createSearcher(SearchObj obj, String initStr) {
        char i;
        Search s = new Search(this.renderer, obj, initStr);
        this.addChild(s);
        this.addChild(new SearchAction(this.renderer, s, '\u0000', "Clear"));
        this.addChild(new SearchAction(this.renderer, s, ' ', "Space"));
        this.addChild(new SearchAction(this.renderer, s, '\b', "Delete"));
        for (i = 'A'; i <= 'Z'; i = (char)(i + '\u0001')) {
            this.addChild(new SearchAction(this.renderer, s, i));
        }
        for (i = '0'; i <= '9'; i = (char)(i + '\u0001')) {
            this.addChild(new SearchAction(this.renderer, s, i));
        }
    }

    @Override
    public synchronized void resolve() {
    }

    @Override
    public void discoverChildren(String str) {
        if (str == null) {
            this.discoverChildren();
        } else {
            this.sobj.search(str, this);
        }
    }

    @Override
    public boolean isSearched() {
        return true;
    }

    @Override
    public void discoverChildren() {
        this.createSearcher(this.sobj, "");
    }

    @Override
    public boolean isRefreshNeeded() {
        return true;
    }

    @Override
    public boolean refreshChildren() {
        this.refreshChildren(null, null);
        return true;
    }

    @Override
    public boolean refreshChildren(String str, String lang) {
        if (str == null) {
            return false;
        }
        this.getChildren().clear();
        this.discoverChildren(str);
        return true;
    }
}

