/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.util.List;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableVideoMetadata;
import net.pms.dlna.DLNAThumbnailInputStream;
import net.pms.media.video.metadata.TvSeriesMetadata;
import net.pms.renderers.Renderer;
import net.pms.store.MediaInfoStore;
import net.pms.store.MediaStatusStore;
import net.pms.store.ThumbnailStore;
import net.pms.store.container.MediaLibraryFolder;

public class MediaLibraryTvSeries
extends MediaLibraryFolder {
    private final Long tvSeriesId;
    private TvSeriesMetadata tvSeriesMetadata;

    public MediaLibraryTvSeries(Renderer renderer, Long tvSeriesId, String[] sql, int[] expectedOutput) {
        super(renderer, null, sql, expectedOutput);
        this.setName(tvSeriesId.toString());
        this.tvSeriesId = tvSeriesId;
        this.setSortable(true);
    }

    @Override
    public String getSystemName() {
        return "tv_series_" + this.getName();
    }

    @Override
    public String getLocalizedDisplayName(String lang) {
        if (this.getTvSeriesMetadata() != null) {
            this.tvSeriesMetadata.ensureHavingTranslation(lang);
            return this.tvSeriesMetadata.getTitle(lang);
        }
        return super.getDisplayNameBase();
    }

    @Override
    public String getDisplayNameBase() {
        return this.getLocalizedDisplayName(null);
    }

    public synchronized TvSeriesMetadata getTvSeriesMetadata() {
        if (this.tvSeriesMetadata == null && this.tvSeriesId != null) {
            this.tvSeriesMetadata = MediaInfoStore.getTvSeriesMetadata(this.tvSeriesId);
        }
        return this.tvSeriesMetadata;
    }

    @Override
    public DLNAThumbnailInputStream getThumbnailInputStream() throws IOException {
        if (this.getTvSeriesMetadata() != null && this.getTvSeriesMetadata().getThumbnailId() != null) {
            return ThumbnailStore.getThumbnailInputStream(this.getTvSeriesMetadata().getThumbnailId());
        }
        try {
            return super.getThumbnailInputStream();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public boolean isFullyPlayedAware() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFullyPlayed() {
        block5: {
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection == null) break block5;
                List<String> filenames = MediaTableVideoMetadata.getTvEpisodesFilesByTvSeriesId(connection, this.tvSeriesId);
                for (String filename : filenames) {
                    if (!this.renderer.hasShareAccess(new File(filename)) || MediaStatusStore.isFullyPlayed(filename, this.renderer.getAccountUserId())) continue;
                    boolean bl = false;
                    return bl;
                }
                boolean bl = true;
                return bl;
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFullyPlayed(boolean fullyPlayed) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            if (connection != null) {
                List<String> filenames = MediaTableVideoMetadata.getTvEpisodesFilesByTvSeriesId(connection, this.tvSeriesId);
                for (String filename : filenames) {
                    if (!this.renderer.hasShareAccess(new File(filename))) continue;
                    MediaStatusStore.setFullyPlayed(filename, this.renderer.getAccountUserId(), fullyPlayed, null);
                }
            }
        }
        finally {
            MediaDatabase.close(connection);
        }
    }
}

