/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import net.pms.renderers.Renderer;
import net.pms.store.container.LocalizedStoreContainer;

abstract class MediaLibraryAbstract
extends LocalizedStoreContainer {
    private static final Double FORTY_MINUTES_IN_SECONDS = 2400.0;
    protected static final String EMPTY_STRING = "''";
    protected static final String TRUE = "TRUE";
    protected static final String NULL = "NULL";
    protected static final String AND = " AND ";
    protected static final String AS = " AS ";
    protected static final String ASC = " ASC";
    protected static final String DESC = " DESC";
    protected static final String NOT_EQUAL = " != ";
    protected static final String EQUAL = " = ";
    protected static final String GREATER_THAN = " > ";
    protected static final String FROM = " FROM ";
    protected static final String NOT = "NOT ";
    protected static final String IS = " IS ";
    protected static final String IN = " IN ";
    protected static final String LEFT_JOIN = " LEFT JOIN ";
    protected static final String NOT_IN = " NOT IN ";
    protected static final String ON = " ON ";
    protected static final String OR = " OR ";
    protected static final String ORDER_BY = " ORDER BY ";
    protected static final String SELECT = "SELECT ";
    protected static final String SELECT_ALL = "SELECT *";
    protected static final String SELECT_DISTINCT = "SELECT DISTINCT ";
    protected static final String WHERE = " WHERE ";
    protected static final String WITH = "WITH ";
    protected static final String LIMIT = " LIMIT ";
    protected static final String LIMIT_1 = " LIMIT 1";
    protected static final String LIMIT_100 = " LIMIT 100";
    protected static final String IS_NULL = " IS NULL";
    protected static final String IS_TRUE = " IS TRUE";
    protected static final String IS_NOT_NULL = " IS NOT NULL";
    protected static final String IS_NOT_TRUE = " IS NOT TRUE";
    protected static final String FORMATDATETIME_MODIFIED = "FORMATDATETIME(FILES.MODIFIED, 'yyyy MM d')";
    protected static final String COALESCE_ARTIST = "COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST)";
    protected static final String FORMAT_TYPE_AUDIO = "FILES.FORMAT_TYPE = 1";
    protected static final String FORMAT_TYPE_IMAGE = "FILES.FORMAT_TYPE = 2";
    protected static final String FORMAT_TYPE_VIDEO = "FILES.FORMAT_TYPE = 4";
    protected static final String FORMAT_TYPE_ISO = "FILES.FORMAT_TYPE = 32";
    private static final String FULLYPLAYED_CONDITION = "FILES_STATUS.ISFULLYPLAYED IS TRUE";
    private static final String NOT_FULLYPLAYED_CONDITION = "FILES_STATUS.ISFULLYPLAYED IS NOT TRUE";
    private static final String WAS_PLAYED_CONDITION = "FILES_STATUS.DATELASTPLAY IS NOT NULL";
    protected static final String TVEPISODE_CONDITION = "VIDEO_METADATA.ISTVEPISODE";
    protected static final String MOVIE_CONDITION = "NOT VIDEO_METADATA.ISTVEPISODE AND VIDEO_METADATA.MEDIA_YEAR IS NOT NULL AND FILES.DURATION > " + FORTY_MINUTES_IN_SECONDS;
    protected static final String IS_NOT_3D_CONDITION = "FILES.ID NOT IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE MULTIVIEW_LAYOUT != '')";
    protected static final String IS_3D_CONDITION = "FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE MULTIVIEW_LAYOUT != '')";
    protected static final String IS_VIDEO4K_CONDITION = "FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH > 3700 OR VIDEOTRACKS.HEIGHT > 2000)";
    protected static final String IS_VIDEOHD_CONDITION = "FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH > 864 OR VIDEOTRACKS.HEIGHT > 576)";
    protected static final String IS_VIDEOSD_CONDITION = "FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH < 865 AND VIDEOTRACKS.HEIGHT < 577)";
    protected static final String IS_NOT_SAMPLE_CONDITION = "VIDEO_METADATA.ISSAMPLE IS NOT TRUE";
    protected static final String UNSORTED_CONDITION = "NOT VIDEO_METADATA.ISTVEPISODE AND (VIDEO_METADATA.MEDIA_YEAR IS NULL)";
    protected static final String FROM_FILES = " FROM FILES";
    protected static final String FROM_FILES_VIDEOMETA = " FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID";
    protected static final String FROM_FILES_VIDEOMETA_TV_SERIES = " FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID";
    protected static final String FROM_FILES_STATUS = " FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME";
    protected static final String FROM_FILES_STATUS_VIDEOMETA = " FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID";
    protected static final String FROM_FILES_STATUS_VIDEO_TV_SERIES = " FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID";
    protected static final String SELECT_DISTINCT_TVSEASON = "SELECT DISTINCT VIDEO_METADATA.TVSEASON FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID";
    protected static final String SELECT_FILES_STATUS_WHERE = "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME WHERE ";
    protected static final String SELECT_FILES_STATUS_VIDEO_WHERE = "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE ";
    protected static final String SELECT_FILES_STATUS_VIDEO_TV_SERIES_WHERE = "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID WHERE ";
    protected static final String SELECT_FILENAME_FILES_WHERE = "SELECT FILES.FILENAME FROM FILES WHERE ";
    protected static final String SELECT_FILENAME_MODIFIED = "SELECT FILES.FILENAME, FILES.MODIFIED";
    protected static final String SELECT_FILENAME_MODIFIED_FILES_WHERE = "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES WHERE ";
    protected static final int FILES = 0;
    protected static final int TEXTS = 1;
    protected static final int PLAYLISTS = 2;
    protected static final int ISOS = 3;
    protected static final int SEASONS = 4;
    protected static final int FILES_NOSORT = 5;
    protected static final int TEXTS_NOSORT = 6;
    protected static final int EPISODES = 7;
    protected static final int TEXTS_WITH_FILTERS = 8;
    protected static final int FILES_WITH_FILTERS = 9;
    protected static final int TEXTS_NOSORT_WITH_FILTERS = 10;
    protected static final int ISOS_WITH_FILTERS = 11;
    protected static final int TVSERIES_WITH_FILTERS = 12;
    protected static final int TVSERIES = 13;
    protected static final int TVSERIES_NOSORT = 14;
    protected static final int EPISODES_WITHIN_SEASON = 15;
    protected static final int MOVIE_FOLDERS = 16;
    protected static final int FILES_NOSORT_DEDUPED = 17;
    protected static final int EMPTY_FILES_WITH_FILTERS = 18;

    MediaLibraryAbstract(Renderer renderer, String i18nName, String thumbnailIcon) {
        this(renderer, i18nName, thumbnailIcon, (String)null);
    }

    MediaLibraryAbstract(Renderer renderer, String i18nName, String thumbnailIcon, String formatString) {
        super(renderer, i18nName, thumbnailIcon, formatString);
    }

    private static String getUserCondition(int userId) {
        return "FILES_STATUS.USERID = " + userId;
    }

    private static String getUserConditionIncludingNull(int userId) {
        return "(" + MediaLibraryAbstract.getUserCondition(userId) + " OR FILES_STATUS.USERID IS NULL)";
    }

    protected static String getWatchedCondition(int userId) {
        return MediaLibraryAbstract.getUserCondition(userId) + " AND FILES_STATUS.ISFULLYPLAYED IS TRUE";
    }

    protected static String getUnWatchedCondition(int userId) {
        return MediaLibraryAbstract.getUserConditionIncludingNull(userId) + " AND FILES_STATUS.ISFULLYPLAYED IS NOT TRUE";
    }

    protected static String getInProgressCondition(int userId) {
        return MediaLibraryAbstract.getWasPlayedCondition(userId) + " AND FILES_STATUS.ISFULLYPLAYED IS NOT TRUE";
    }

    protected static String getWasPlayedCondition(int userId) {
        return MediaLibraryAbstract.getUserCondition(userId) + " AND FILES_STATUS.DATELASTPLAY IS NOT NULL";
    }
}

