/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store.container;

import net.pms.renderers.Renderer;
import net.pms.store.container.LocalizedStoreContainer;
import net.pms.store.container.MediaLibraryAbstract;
import net.pms.store.container.MediaLibraryFolder;
import net.pms.util.FullyPlayedAction;

public class MediaLibrary
extends MediaLibraryAbstract {
    private MediaLibraryFolder allFolder;
    private MediaLibraryFolder albumFolder;
    private MediaLibraryFolder artistFolder;
    private MediaLibraryFolder genreFolder;
    private MediaLibraryFolder playlistFolder;
    private LocalizedStoreContainer vfAudio = null;

    public MediaLibrary(Renderer renderer) {
        super(renderer, "MediaLibrary", "/images/store/media-library.png");
        this.addVideoFolder();
        this.addAudioFolder();
        this.addImageFolder();
    }

    private void addVideoFolder() {
        LocalizedStoreContainer vfVideo = new LocalizedStoreContainer(this.renderer, "Video");
        MediaLibraryFolder unwatchedTvShowsFolder = new MediaLibraryFolder(this.renderer, "TvShows", new String[]{"SELECT DISTINCT TV_SERIES.ID, TV_SERIES.TITLE FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID WHERE FILES.FORMAT_TYPE = 4 AND VIDEO_METADATA.ISTVEPISODE AND VIDEO_METADATA.ISSAMPLE IS NOT TRUE AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " ORDER BY TV_SERIES.TITLE ASC", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID WHERE FILES.FORMAT_TYPE = 4 AND VIDEO_METADATA.ISTVEPISODE AND VIDEO_METADATA.ISSAMPLE IS NOT TRUE AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " AND TV_SERIES.ID = '${0}' ORDER BY VIDEO_METADATA.TVSEASON, CAST(REGEXP_SUBSTR(CONCAT('0', VIDEO_METADATA.TVEPISODENUMBER), '\\d*') AS INTEGER)"}, new int[]{12, 7});
        MediaLibraryFolder unwatchedMoviesFolder = new MediaLibraryFolder(this.renderer, "Movies", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME WHERE FILES.FORMAT_TYPE = 4 AND " + MOVIE_CONDITION + " AND VIDEO_METADATA.ISSAMPLE IS NOT TRUE AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " AND FILES.ID NOT IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE MULTIVIEW_LAYOUT != '') ORDER BY FILES.FILENAME ASC", 0);
        MediaLibraryFolder unwatchedMovies3DFolder = new MediaLibraryFolder(this.renderer, "3dMovies", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME WHERE FILES.FORMAT_TYPE = 4 AND " + MOVIE_CONDITION + " AND VIDEO_METADATA.ISSAMPLE IS NOT TRUE AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " AND FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE MULTIVIEW_LAYOUT != '') ORDER BY FILES.FILENAME ASC", 0);
        MediaLibraryFolder unwatchedUnsortedFolder = new MediaLibraryFolder(this.renderer, "Unsorted", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME WHERE FILES.FORMAT_TYPE = 4 AND NOT VIDEO_METADATA.ISTVEPISODE AND (VIDEO_METADATA.MEDIA_YEAR IS NULL) AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES.FILENAME ASC", 0);
        MediaLibraryFolder unwatchedRecentlyAddedVideos = new MediaLibraryFolder(this.renderer, "RecentlyAdded", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME WHERE FILES.FORMAT_TYPE = 4 AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES.MODIFIED DESC LIMIT 100", 5);
        MediaLibraryFolder unwatchedAllVideosFolder = new MediaLibraryFolder(this.renderer, "AllVideos", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME WHERE FILES.FORMAT_TYPE = 4 AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES.FILENAME ASC", 0);
        MediaLibraryFolder unwatchedVideosByDate = new MediaLibraryFolder(this.renderer, "ByDate", new String[]{"SELECT FORMATDATETIME(FILES.MODIFIED, 'yyyy MM d') FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES.MODIFIED DESC", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND FORMATDATETIME(FILES.MODIFIED, 'yyyy MM d') = '${0}' AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES.FILENAME ASC"}, new int[]{6, 0});
        MediaLibraryFolder unwatched4kVideos = new MediaLibraryFolder(this.renderer, "4kVideos", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH > 3700 OR VIDEOTRACKS.HEIGHT > 2000) AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES.FILENAME ASC", 0);
        MediaLibraryFolder unwatchedMlfVideo03 = new MediaLibraryFolder(this.renderer, "HdVideos", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH > 864 OR VIDEOTRACKS.HEIGHT > 576) AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES.FILENAME ASC", 0);
        MediaLibraryFolder unwatchedMlfVideo04 = new MediaLibraryFolder(this.renderer, "SdVideos", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH < 865 AND VIDEOTRACKS.HEIGHT < 577) AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES.FILENAME ASC", 0);
        MediaLibraryFolder unwatchedMlfVideo05 = new MediaLibraryFolder(this.renderer, "DvdImages", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 32 AND " + MediaLibrary.getUnWatchedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES.FILENAME ASC", 3);
        MediaLibraryFolder tvShowsFolder = new MediaLibraryFolder(this.renderer, "TvShows", new String[]{"SELECT DISTINCT TV_SERIES.ID, TV_SERIES.TITLE FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID WHERE FILES.FORMAT_TYPE = 4 AND VIDEO_METADATA.ISTVEPISODE AND VIDEO_METADATA.ISSAMPLE IS NOT TRUE ORDER BY TV_SERIES.TITLE ASC", "SELECT * FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID WHERE FILES.FORMAT_TYPE = 4 AND VIDEO_METADATA.ISTVEPISODE AND VIDEO_METADATA.ISSAMPLE IS NOT TRUE AND TV_SERIES.ID = '${0}' ORDER BY VIDEO_METADATA.TVSEASON, CAST(REGEXP_SUBSTR(CONCAT('0', VIDEO_METADATA.TVEPISODENUMBER), '\\d*') AS INTEGER)"}, new int[]{12, 7});
        MediaLibraryFolder moviesFolder = new MediaLibraryFolder(this.renderer, "Movies", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND " + MOVIE_CONDITION + " AND FILES.ID NOT IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE MULTIVIEW_LAYOUT != '') AND VIDEO_METADATA.ISSAMPLE IS NOT TRUE ORDER BY FILES.FILENAME ASC", 9);
        MediaLibraryFolder movies3DFolder = new MediaLibraryFolder(this.renderer, "3dMovies", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND " + MOVIE_CONDITION + " AND FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE MULTIVIEW_LAYOUT != '') AND VIDEO_METADATA.ISSAMPLE IS NOT TRUE ORDER BY FILES.FILENAME ASC", 9);
        MediaLibraryFolder unsortedFolder = new MediaLibraryFolder(this.renderer, "Unsorted", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND NOT VIDEO_METADATA.ISTVEPISODE AND (VIDEO_METADATA.MEDIA_YEAR IS NULL) ORDER BY FILES.FILENAME ASC", 9);
        MediaLibraryFolder allVideosFolder = new MediaLibraryFolder(this.renderer, "AllVideos", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 ORDER BY FILES.FILENAME ASC", 9);
        MediaLibraryFolder recentlyAddedVideos = new MediaLibraryFolder(this.renderer, "RecentlyAdded", new String[]{"SELECT * FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 ORDER BY FILES.DATEADDED DESC,FILES.MODIFIED DESC LIMIT 100"}, new int[]{5});
        MediaLibraryFolder inProgressVideos = new MediaLibraryFolder(this.renderer, "InProgress", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND " + MediaLibrary.getInProgressCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES_STATUS.DATELASTPLAY DESC LIMIT 100", 5);
        MediaLibraryFolder mostPlayedVideos = new MediaLibraryFolder(this.renderer, "MostPlayed", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND " + MediaLibrary.getWasPlayedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES_STATUS.PLAYCOUNT DESC LIMIT 100", 5);
        MediaLibraryFolder videosByDate = new MediaLibraryFolder(this.renderer, "ByDate", new String[]{"SELECT FORMATDATETIME(FILES.MODIFIED, 'yyyy MM d') FROM FILES WHERE FILES.FORMAT_TYPE = 4 ORDER BY FILES.MODIFIED DESC", "FILES.FORMAT_TYPE = 4 AND FORMATDATETIME(FILES.MODIFIED, 'yyyy MM d') = '${0}' ORDER BY FILES.FILENAME ASC"}, new int[]{10, 0});
        MediaLibraryFolder fourKVideos = new MediaLibraryFolder(this.renderer, "4kVideos", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH > 3700 OR VIDEOTRACKS.HEIGHT > 2000) ORDER BY FILES.FILENAME ASC", 9);
        MediaLibraryFolder mlfVideo03 = new MediaLibraryFolder(this.renderer, "HdVideos", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH > 864 OR VIDEOTRACKS.HEIGHT > 576) ORDER BY FILES.FILENAME ASC", 9);
        MediaLibraryFolder mlfVideo04 = new MediaLibraryFolder(this.renderer, "SdVideos", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND FILES.ID IN (SELECT VIDEOTRACKS.FILEID FROM VIDEOTRACKS WHERE VIDEOTRACKS.WIDTH < 865 AND VIDEOTRACKS.HEIGHT < 577) ORDER BY FILES.FILENAME ASC", 9);
        MediaLibraryFolder mlfVideo05 = new MediaLibraryFolder(this.renderer, "DvdImages", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 32 ORDER BY FILES.FILENAME ASC", 11);
        if (this.renderer.getUmsConfiguration().getFullyPlayedAction() == FullyPlayedAction.HIDE_MEDIA) {
            vfVideo.addChild(unwatchedTvShowsFolder);
            vfVideo.addChild(unwatchedMoviesFolder);
            vfVideo.addChild(unwatchedMovies3DFolder);
            vfVideo.addChild(unwatchedUnsortedFolder);
            vfVideo.addChild(unwatchedRecentlyAddedVideos);
            vfVideo.addChild(inProgressVideos);
            vfVideo.addChild(unwatchedAllVideosFolder);
            vfVideo.addChild(unwatchedVideosByDate);
            vfVideo.addChild(unwatched4kVideos);
            vfVideo.addChild(unwatchedMlfVideo03);
            vfVideo.addChild(unwatchedMlfVideo04);
            vfVideo.addChild(unwatchedMlfVideo05);
        } else {
            vfVideo.addChild(tvShowsFolder);
            vfVideo.addChild(moviesFolder);
            vfVideo.addChild(movies3DFolder);
            vfVideo.addChild(unsortedFolder);
            vfVideo.addChild(recentlyAddedVideos);
            if (this.renderer.getUmsConfiguration().isShowRecentlyPlayedFolder()) {
                MediaLibraryFolder recentlyPlayedVideos = new MediaLibraryFolder(this.renderer, "RecentlyPlayed", "SELECT * FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND " + MediaLibrary.getWasPlayedCondition(this.renderer.getAccountUserId()) + " ORDER BY FILES_STATUS.DATELASTPLAY DESC LIMIT 100", 5);
                vfVideo.addChild(recentlyPlayedVideos);
            }
            vfVideo.addChild(inProgressVideos);
            vfVideo.addChild(mostPlayedVideos);
            vfVideo.addChild(allVideosFolder);
            vfVideo.addChild(videosByDate);
            vfVideo.addChild(fourKVideos);
            vfVideo.addChild(mlfVideo03);
            vfVideo.addChild(mlfVideo04);
            vfVideo.addChild(mlfVideo05);
        }
        this.addChild(vfVideo);
    }

    private void addAudioFolder() {
        this.vfAudio = new LocalizedStoreContainer(this.renderer, "Audio");
        this.allFolder = new MediaLibraryFolder(this.renderer, "AllAudioTracks", "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 ORDER BY FILES.FILENAME ASC", 0);
        this.vfAudio.addChild(this.allFolder);
        this.playlistFolder = new MediaLibraryFolder(this.renderer, "AllAudioPlaylists", "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES WHERE FILES.FORMAT_TYPE = 16 ORDER BY FILES.FILENAME ASC", 2);
        this.vfAudio.addChild(this.playlistFolder);
        this.artistFolder = new MediaLibraryFolder(this.renderer, "ByArtist", new String[]{"SELECT DISTINCT COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) AS ARTIST FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 ORDER BY ARTIST ASC", "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) = '${0}'"}, new int[]{1, 0});
        this.vfAudio.addChild(this.artistFolder);
        this.albumFolder = new MediaLibraryFolder(this.renderer, "ByAlbum", new String[]{"SELECT DISTINCT AUDIO_METADATA.ALBUM FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 ORDER BY AUDIO_METADATA.ALBUM ASC", "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND AUDIO_METADATA.ALBUM = '${0}'"}, new int[]{1, 0});
        this.vfAudio.addChild(this.albumFolder);
        this.genreFolder = new MediaLibraryFolder(this.renderer, "ByGenre", new String[]{"SELECT DISTINCT AUDIO_METADATA.GENRE FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 ORDER BY AUDIO_METADATA.GENRE ASC", "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND AUDIO_METADATA.GENRE = '${0}'"}, new int[]{1, 0});
        this.vfAudio.addChild(this.genreFolder);
        MediaLibraryFolder mlf6 = new MediaLibraryFolder(this.renderer, "ByArtistAlbum", new String[]{"SELECT DISTINCT COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) AS ARTIST FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 ORDER BY ARTIST ASC", "SELECT DISTINCT AUDIO_METADATA.ALBUM FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) = '${0}' ORDER BY AUDIO_METADATA.ALBUM ASC", "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) = '${1}' AND AUDIO_METADATA.ALBUM = '${0}' ORDER BY AUDIO_METADATA.TRACK ASC, FILES.FILENAME ASC"}, new int[]{1, 1, 0});
        this.vfAudio.addChild(mlf6);
        MediaLibraryFolder mlf7 = new MediaLibraryFolder(this.renderer, "ByGenreArtistAlbum", new String[]{"SELECT DISTINCT AUDIO_METADATA.GENRE FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 ORDER BY AUDIO_METADATA.GENRE ASC", "SELECT DISTINCT COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) AS ARTIST FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND AUDIO_METADATA.GENRE = '${0}' ORDER BY ARTIST ASC", "SELECT DISTINCT AUDIO_METADATA.ALBUM FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND AUDIO_METADATA.GENRE = '${1}' AND COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) = '${0}' ORDER BY AUDIO_METADATA.ALBUM ASC", "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND AUDIO_METADATA.GENRE = '${2}' AND COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) = '${1}' AND AUDIO_METADATA.ALBUM = '${0}' ORDER BY AUDIO_METADATA.TRACK ASC, FILES.FILENAME ASC"}, new int[]{1, 1, 1, 0});
        this.vfAudio.addChild(mlf7);
        MediaLibraryFolder audioByDate = new MediaLibraryFolder(this.renderer, "ByDate", new String[]{"SELECT FORMATDATETIME(FILES.MODIFIED, 'yyyy MM d') FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 ORDER BY FILES.MODIFIED DESC", "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND FORMATDATETIME(FILES.MODIFIED, 'yyyy MM d') = '${0}' ORDER BY AUDIO_METADATA.TRACK ASC, FILES.FILENAME ASC"}, new int[]{6, 0});
        this.vfAudio.addChild(audioByDate);
        MediaLibraryFolder mlf8 = new MediaLibraryFolder(this.renderer, "ByLetterArtistAlbum", new String[]{"SELECT REGEXP_RULES.ID FROM REGEXP_RULES ORDER BY REGEXP_RULES.REGEXP_ORDER ASC", "SELECT DISTINCT COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) AS ARTIST FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND ARTIST REGEXP (SELECT REGEXP_RULES.REGEXP_RULE FROM REGEXP_RULES WHERE REGEXP_RULES.ID = '${0}') ORDER BY ARTIST ASC", "SELECT DISTINCT AUDIO_METADATA.ALBUM FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) = '${0}' ORDER BY AUDIO_METADATA.ALBUM ASC", "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES, AUDIO_METADATA WHERE FILES.ID = AUDIO_METADATA.FILEID AND FILES.FORMAT_TYPE = 1 AND COALESCE(AUDIO_METADATA.ALBUMARTIST, AUDIO_METADATA.ARTIST) = '${1}' AND AUDIO_METADATA.ALBUM = '${0}'"}, new int[]{1, 1, 1, 0});
        this.vfAudio.addChild(mlf8);
        this.addChild(this.vfAudio);
    }

    private void addImageFolder() {
        LocalizedStoreContainer vfImage = new LocalizedStoreContainer(this.renderer, "Photo");
        MediaLibraryFolder mlfPhoto01 = new MediaLibraryFolder(this.renderer, "AllPhotos", "FILES.FORMAT_TYPE = 2 ORDER BY FILES.FILENAME ASC", 0);
        vfImage.addChild(mlfPhoto01);
        MediaLibraryFolder photoByDate = new MediaLibraryFolder(this.renderer, "ByDate", new String[]{"SELECT FORMATDATETIME(FILES.MODIFIED, 'yyyy MM d') FROM FILES WHERE FILES.FORMAT_TYPE = 2 ORDER BY FILES.MODIFIED DESC", "FILES.FORMAT_TYPE = 2 AND FORMATDATETIME(FILES.MODIFIED, 'yyyy MM d') = '${0}' ORDER BY FILES.FILENAME ASC"}, new int[]{6, 0});
        vfImage.addChild(photoByDate);
        this.addChild(vfImage);
    }

    public MediaLibraryFolder getArtistFolder() {
        return this.artistFolder;
    }

    public MediaLibraryFolder getGenreFolder() {
        return this.genreFolder;
    }

    public MediaLibraryFolder getPlaylistFolder() {
        return this.playlistFolder;
    }

    public MediaLibraryFolder getAllFolder() {
        return this.allFolder;
    }

    public LocalizedStoreContainer getAudioFolder() {
        return this.vfAudio;
    }

    public MediaLibraryFolder getAlbumFolder() {
        return this.albumFolder;
    }
}

