/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.util.TimeRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResumeObj {
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final Logger LOGGER = LoggerFactory.getLogger(ResumeObj.class);
    private static final int DAYS = 86400000;
    public static final String CLEAN_REG = "_hash_(\\d+)";
    private final File file;
    private long offsetTime = 0L;
    private long resDuration = 0L;
    private long minDur;

    public ResumeObj(File f) {
        this.file = f;
        this.minDur = CONFIGURATION.getMinimumWatchedPlayTime();
    }

    public void setMinDuration(long dur) {
        if (dur == 0L) {
            dur = CONFIGURATION.getMinimumWatchedPlayTime();
        }
        this.minDur = dur;
    }

    public void read() {
        try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), StandardCharsets.UTF_8));){
            String str = in.readLine();
            if (str != null) {
                String[] tmp = str.split(",");
                this.offsetTime = Long.parseLong(tmp[0]);
                if (tmp.length > 1) {
                    this.resDuration = Long.parseLong(tmp[1]);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public File getResumeFile() {
        return this.file;
    }

    public boolean noResume() {
        return this.offsetTime == 0L;
    }

    public long getTimeOffset() {
        if (this.isDone()) {
            return 0L;
        }
        this.read();
        return this.offsetTime;
    }

    public boolean isDone() {
        return !this.file.exists();
    }

    public void update(TimeRange range, StoreResource r) {
        if (range.isStartOffsetAvailable() && range.getStartOrZero() > 0.0) {
            long now = System.currentTimeMillis();
            if (r.getMediaInfo() != null) {
                this.stop(now + this.getTimeOffset() - (long)(range.getStart() * 1000.0), (long)(r.getMediaInfo().getDuration() * 1000.0));
            } else {
                this.stop(now + this.getTimeOffset() - (long)(range.getStart() * 1000.0), 0L);
            }
        }
    }

    public void stop(long startTime, long expDuration) {
        long now = System.currentTimeMillis();
        long thisPlay = now - startTime;
        long duration = thisPlay + this.offsetTime;
        if (expDuration > this.minDur && (double)duration >= (double)expDuration * CONFIGURATION.getResumeBackFactor()) {
            this.file.delete();
            return;
        }
        if (thisPlay < (long)CONFIGURATION.getResumeRewind()) {
            return;
        }
        if (thisPlay < this.minDur) {
            return;
        }
        this.offsetTime = duration - (long)CONFIGURATION.getResumeRewind();
        this.resDuration = expDuration;
        LOGGER.debug("Resume stop. This segment " + thisPlay + " new time " + duration);
        ResumeObj.write(this.offsetTime, expDuration, this.file);
    }

    private static File resumePath() {
        File path = new File(CONFIGURATION.getDataFile("resume"));
        path.mkdirs();
        return path;
    }

    private static File resumeFile(StoreItem r) {
        String wName = r.getName().replaceAll("[:\\[\\]\n\r]", "").trim();
        String fName = wName + "_hash_" + r.resumeHash() + ".resume";
        return new File(ResumeObj.resumePath(), fName);
    }

    public static File[] resumeFiles() {
        File path = ResumeObj.resumePath();
        return path.listFiles();
    }

    public static ResumeObj create(StoreItem originalResource) {
        double dur;
        if (!originalResource.renderer.getUmsConfiguration().isResumeEnabled()) {
            return null;
        }
        File resumeFile = ResumeObj.resumeFile(originalResource);
        if (!resumeFile.exists()) {
            return null;
        }
        ResumeObj res = new ResumeObj(resumeFile);
        res.read();
        if (res.noResume()) {
            return null;
        }
        if (originalResource.getMediaInfo() != null && ((dur = originalResource.getMediaInfo().getDurationInSeconds()) == 0.0 || dur == 9.223372034707292E18)) {
            originalResource.getMediaInfo().setDuration((double)res.resDuration / 1000.0);
        }
        res.setMinDuration(originalResource.minPlayTime());
        return res;
    }

    public static ResumeObj store(StoreItem r, long startTime) {
        File f = ResumeObj.resumeFile(r);
        ResumeObj obj = new ResumeObj(f);
        obj.setMinDuration(r.minPlayTime());
        obj.stop(startTime, (long)r.getMediaInfo().getDurationInSeconds() * 1000L);
        if (obj.noResume()) {
            return null;
        }
        return obj;
    }

    private static void write(long time, long duration, File f) {
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), StandardCharsets.UTF_8));){
            out.write(time + "," + duration);
            out.flush();
            out.close();
            if (CONFIGURATION.getResumeKeepTime() > 0) {
                PMS.get().addTempFile(f, CONFIGURATION.getResumeKeepTime() * 86400000);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

