/*
 * Decompiled with CFR 0.152.
 */
package net.pms.store;

import java.io.File;
import java.util.List;
import java.util.Optional;
import net.pms.renderers.Renderer;
import net.pms.store.DbIdLibrary;
import net.pms.store.DbIdTypeAndIdent;
import net.pms.store.MediaStoreIds;
import net.pms.store.StoreResource;
import net.pms.store.container.MediaLibraryFolder;
import net.pms.store.container.MusicBrainzAlbumFolder;
import net.pms.store.container.MusicBrainzPersonFolder;
import net.pms.store.container.VirtualFolderDbId;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbIdResourceLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DbIdResourceLocator.class);

    private DbIdResourceLocator() {
    }

    public static StoreResource getAlbumFromMediaLibrary(Renderer renderer, String realFileName) {
        Optional<StoreResource> optional;
        MediaLibraryFolder album = renderer.getMediaStore().getMediaLibrary().getAlbumFolder();
        if (!album.isDiscovered()) {
            album.discoverChildren();
        }
        if ((optional = album.getChildren().stream().filter(sr -> realFileName.equals(sr.getDisplayName())).findFirst()).isPresent()) {
            StoreResource sr2 = optional.get();
            return sr2;
        }
        LOGGER.error("album cannot be located in media library : " + realFileName);
        return null;
    }

    public static StoreResource getLibraryResourceRealFile(Renderer renderer, String realFileName) {
        if (renderer.hasShareAccess(new File(realFileName))) {
            List<Long> ids = MediaStoreIds.getMediaStoreIdsForName(realFileName, "RealFile", "RealFolder");
            for (Long id : ids) {
                StoreResource resource = renderer.getMediaStore().getResource(id.toString());
                if (resource == null) continue;
                return resource;
            }
            LOGGER.error("{} not found as RealFile in database.", (Object)realFileName);
        }
        return null;
    }

    public static StoreResource getLibraryResourcePlaylist(Renderer renderer, String realFileName) {
        if (renderer.hasShareAccess(new File(realFileName))) {
            List<Long> ids = MediaStoreIds.getMediaStoreIdsForName(realFileName, "PlaylistFolder", "RealFolder");
            for (Long id : ids) {
                StoreResource resource = renderer.getMediaStore().getResource(id.toString());
                if (resource == null) continue;
                return resource;
            }
            LOGGER.error("{} not found as PlaylistFolder in database.", (Object)realFileName);
        }
        return null;
    }

    public static MusicBrainzPersonFolder getLibraryResourcePersonFolder(Renderer renderer, DbIdTypeAndIdent typeIdent) {
        List<Long> ids = MediaStoreIds.getMediaStoreIdsForName(typeIdent.toString(), MusicBrainzPersonFolder.class);
        for (Long id : ids) {
            StoreResource resource = renderer.getMediaStore().getResource(id.toString());
            if (resource == null) continue;
            return (MusicBrainzPersonFolder)resource;
        }
        LOGGER.debug("Person '{}' not found in database.", (Object)typeIdent.toString());
        return null;
    }

    public static MusicBrainzAlbumFolder getLibraryResourceMusicBrainzFolder(Renderer renderer, DbIdTypeAndIdent typeIdent) {
        List<Long> ids = MediaStoreIds.getMediaStoreIdsForName(typeIdent.toString(), MusicBrainzAlbumFolder.class);
        for (Long id : ids) {
            StoreResource resource = renderer.getMediaStore().getResource(id.toString());
            if (resource == null) continue;
            return (MusicBrainzAlbumFolder)resource;
        }
        LOGGER.debug("MusicBrainz album '{}' not found in database.", (Object)typeIdent.toString());
        return null;
    }

    public static VirtualFolderDbId getLibraryResourceVirtualFolder(Renderer renderer, DbIdTypeAndIdent typeIdent) {
        List<Long> ids = MediaStoreIds.getMediaStoreIdsForName(typeIdent.toString(), VirtualFolderDbId.class);
        for (Long id : ids) {
            StoreResource resource = renderer.getMediaStore().getResource(id.toString());
            if (resource == null) continue;
            return (VirtualFolderDbId)resource;
        }
        LOGGER.debug("VirtualFolderDbId '{}' not found in database.", (Object)typeIdent.toString());
        return null;
    }

    public static StoreResource getLibraryResourceFolder(Renderer renderer, String realFolderName) {
        if (renderer.hasShareAccess(new File(realFolderName))) {
            List<Long> ids = MediaStoreIds.getMediaStoreIdsForName(realFolderName, "RealFolder", "RealFolder");
            for (Long id : ids) {
                StoreResource resource = renderer.getMediaStore().getResource(id.toString());
                if (resource == null) continue;
                return resource;
            }
            LOGGER.info("{} not found as RealFolder in database.", (Object)realFolderName);
        }
        return null;
    }

    public static StoreResource getLibraryResourceByDbTypeIdent(Renderer renderer, DbIdTypeAndIdent typeIdent) {
        LOGGER.debug("getLibraryResourceByDbTypeIdent : {}", (Object)typeIdent.toString());
        switch (typeIdent.type) {
            case TYPE_MUSICBRAINZ_RECORDID: {
                if (StringUtils.isAllBlank(typeIdent.ident)) {
                    return null;
                }
                return DbIdResourceLocator.getLibraryResourceMusicBrainzFolder(renderer, typeIdent);
            }
            case TYPE_PERSON: 
            case TYPE_PERSON_COMPOSER: 
            case TYPE_PERSON_CONDUCTOR: {
                if (StringUtils.isAllBlank(typeIdent.ident)) {
                    return renderer.getMediaStore().getDbIdLibrary().getPersonArtistFolder();
                }
                MusicBrainzPersonFolder personFolder = DbIdResourceLocator.getLibraryResourcePersonFolder(renderer, typeIdent);
                if (personFolder == null) {
                    personFolder = DbIdLibrary.addLibraryResourcePerson(renderer, typeIdent);
                }
                return personFolder;
            }
            case TYPE_PERSON_ALBUM: 
            case TYPE_PERSON_ALL_FILES: {
                VirtualFolderDbId folder = DbIdResourceLocator.getLibraryResourceVirtualFolder(renderer, typeIdent);
                if (folder == null) {
                    LOGGER.debug("person album path not in database : {} " + typeIdent.toString());
                }
                return folder;
            }
            case TYPE_PERSON_ALBUM_FILES: {
                MusicBrainzPersonFolder folder = DbIdResourceLocator.getLibraryResourcePersonFolder(renderer, typeIdent);
                if (folder == null) {
                    LOGGER.debug("person album path not in database : {} " + typeIdent.toString());
                }
                return folder;
            }
            case TYPE_MYMUSIC_ALBUM: {
                LOGGER.trace("Returning 'my music' folder");
                return renderer.getMediaStore().getDbIdLibrary().getAudioLikesFolder();
            }
        }
        LOGGER.error("implement type : " + String.valueOf((Object)typeIdent.type));
        return null;
    }
}

