/*
 * Decompiled with CFR 0.152.
 */
package net.pms.service.sleep;

import net.pms.PMS;
import net.pms.platform.PlatformUtils;
import net.pms.service.sleep.AbstractSleepWorker;
import net.pms.service.sleep.PreventSleepMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SleepManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(SleepManager.class);
    protected int playingCount;
    protected PreventSleepMode mode = PMS.getConfiguration().getPreventSleep();
    protected boolean sleepPrevented;
    protected AbstractSleepWorker worker;

    public SleepManager() {
        this.start();
    }

    public synchronized void startPlaying() {
        ++this.playingCount;
        if (SleepManager.isPreventSleepSupported() && !this.sleepPrevented && this.mode == PreventSleepMode.PLAYBACK) {
            this.preventSleep();
        }
    }

    public synchronized void stopPlaying() {
        if (this.playingCount == 0) {
            LOGGER.error("Sleepmanager cannot decrease playing reference count as it's already zero");
            return;
        }
        --this.playingCount;
        if (SleepManager.isPreventSleepSupported() && this.playingCount == 0 && this.sleepPrevented && this.mode == PreventSleepMode.PLAYBACK) {
            this.allowSleep();
            this.postponeSleep();
        }
    }

    public synchronized void postponeSleep() {
        if (SleepManager.isPreventSleepSupported() && this.mode == PreventSleepMode.PLAYBACK && !this.sleepPrevented) {
            this.resetSleepTimer();
        }
    }

    public synchronized int getPlayingCount() {
        return this.playingCount;
    }

    public synchronized void setMode(PreventSleepMode mode) {
        if (mode == null) {
            LOGGER.error("Ignoring attempt to set PreventSleepMode to null");
            return;
        }
        if (this.mode != mode) {
            this.mode = mode;
            switch (mode) {
                case NEVER: {
                    if (!this.sleepPrevented) break;
                    this.allowSleep();
                    break;
                }
                case PLAYBACK: {
                    if (this.playingCount > 0 && !this.sleepPrevented) {
                        this.preventSleep();
                        break;
                    }
                    if (this.playingCount != 0 || !this.sleepPrevented) break;
                    this.allowSleep();
                    break;
                }
                case RUNNING: {
                    if (this.sleepPrevented) break;
                    this.preventSleep();
                    break;
                }
                default: {
                    throw new IllegalStateException("PreventSleepMode value not implemented: " + mode.getValue());
                }
            }
            if (this.worker != null) {
                this.worker.setMode(mode);
            }
        }
    }

    public final synchronized void start() {
        LOGGER.debug("Starting SleepManager");
        if (SleepManager.isPreventSleepSupported()) {
            if (this.mode == PreventSleepMode.RUNNING || this.mode == PreventSleepMode.PLAYBACK && this.playingCount > 0) {
                this.preventSleep();
            }
        } else {
            LOGGER.debug("SleepManager doesn't support current platform");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        AbstractSleepWorker localWorker;
        LOGGER.debug("Stopping SleepManager");
        SleepManager sleepManager = this;
        synchronized (sleepManager) {
            localWorker = this.worker;
        }
        if (localWorker != null) {
            localWorker.interrupt();
            try {
                localWorker.join();
            }
            catch (InterruptedException e) {
                LOGGER.debug("SleepManager was interrupted while waiting for the sleep worker to terminate");
            }
        }
    }

    public synchronized void restart() {
        this.stop();
        this.start();
    }

    protected synchronized void allowSleep() {
        this.initializeWorker();
        if (this.worker != null) {
            this.worker.allowSleep();
        }
        this.sleepPrevented = false;
    }

    protected synchronized void preventSleep() {
        this.initializeWorker();
        if (this.worker != null) {
            this.worker.preventSleep();
        }
        this.sleepPrevented = true;
    }

    protected synchronized void resetSleepTimer() {
        this.initializeWorker();
        if (this.worker != null) {
            this.worker.resetSleepTimer();
        }
    }

    protected void initializeWorker() {
        if (this.worker == null && SleepManager.isPreventSleepSupported()) {
            this.worker = PlatformUtils.INSTANCE.getSleepWorker(this, this.mode);
            this.worker.start();
        }
    }

    protected synchronized void clearWorker() {
        this.worker = null;
    }

    public static boolean isPreventSleepSupported() {
        return PlatformUtils.INSTANCE.isPreventSleepSupported();
    }
}

