/*
 * Decompiled with CFR 0.152.
 */
package net.pms.service;

import jakarta.annotation.Nullable;
import net.pms.service.process.ProcessManager;
import net.pms.service.sleep.SleepManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Services {
    private static final Logger LOGGER = LoggerFactory.getLogger(Services.class);
    private static Services instance;
    private ProcessManager processManager;
    private SleepManager sleepManager;

    @Nullable
    public static Services get() {
        return instance;
    }

    public static void create() {
        if (instance != null) {
            throw new IllegalStateException("Services have already been created");
        }
        instance = new Services();
    }

    public static void destroy() {
        if (instance != null) {
            instance.stop();
            instance = null;
        }
    }

    @Nullable
    public static ProcessManager processManager() {
        return instance == null ? null : instance.getProcessManager();
    }

    @Nullable
    public static SleepManager sleepManager() {
        return instance == null ? null : instance.getSleepManager();
    }

    public static void postponeSleep() {
        if (instance != null && instance.getSleepManager() != null) {
            instance.getSleepManager().postponeSleep();
        }
    }

    public static void set(Services newInstance) {
        instance = newInstance;
    }

    public static void stopProcessManager() {
        if (instance != null && Services.instance.processManager != null) {
            Services.instance.processManager.stop();
        }
    }

    public Services() {
        this.start();
    }

    public final void start() {
        if (this.processManager != null || this.sleepManager != null) {
            throw new IllegalStateException("Services have already been started");
        }
        LOGGER.debug("Starting services");
        this.processManager = new ProcessManager();
        this.sleepManager = new SleepManager();
    }

    public void stop() {
        LOGGER.debug("Stopping services");
        if (this.processManager != null) {
            this.processManager.stop();
            this.processManager = null;
        }
        if (this.sleepManager != null) {
            this.sleepManager.stop();
            this.sleepManager = null;
        }
    }

    public ProcessManager getProcessManager() {
        return this.processManager;
    }

    public SleepManager getSleepManager() {
        return this.sleepManager;
    }
}

