/*
 * Decompiled with CFR 0.152.
 */
package net.pms.renderers.devices.players;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pms.renderers.Renderer;
import net.pms.renderers.devices.players.BasicPlayer;
import net.pms.renderers.devices.players.PlayerState;
import net.pms.renderers.devices.players.Playlist;

public abstract class MinimalPlayer
implements BasicPlayer {
    protected Renderer renderer;
    protected PlayerState state;
    protected final ReentrantReadWriteLock listenersLock = new ReentrantReadWriteLock();
    protected final LinkedHashSet<ActionListener> listeners = new LinkedHashSet();

    protected MinimalPlayer(Renderer renderer) {
        this.renderer = renderer;
        this.state = new PlayerState();
        this.reset();
    }

    @Override
    public void start() {
    }

    @Override
    public final void reset() {
        this.state.reset();
        this.alert();
    }

    @Override
    public void connect(ActionListener listener) {
        if (listener != null) {
            this.listenersLock.writeLock().lock();
            try {
                this.listeners.add(listener);
            }
            finally {
                this.listenersLock.writeLock().unlock();
            }
        }
    }

    @Override
    public void disconnect(ActionListener listener) {
        this.listenersLock.writeLock().lock();
        try {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.close();
            }
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
    }

    @Override
    public void alert() {
        this.listenersLock.readLock().lock();
        try {
            for (ActionListener l : this.listeners) {
                l.actionPerformed(new ActionEvent(this, 0, null));
            }
        }
        finally {
            this.listenersLock.readLock().unlock();
        }
        this.renderer.refreshPlayerStateGui(this.state);
    }

    @Override
    public PlayerState getState() {
        return this.state;
    }

    @Override
    public void close() {
        this.listenersLock.writeLock().lock();
        try {
            this.listeners.clear();
        }
        finally {
            this.listenersLock.writeLock().unlock();
        }
        this.renderer.setPlayer(null);
    }

    @Override
    public void setBuffer(long mb) {
        this.state.setBuffer(mb);
        this.alert();
    }

    @Override
    public void setURI(String uri, String metadata) {
    }

    @Override
    public void pressPlay(String uri, String metadata) {
    }

    @Override
    public void pressStop() {
    }

    @Override
    public void play() {
    }

    @Override
    public void pause() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void next() {
    }

    @Override
    public void prev() {
    }

    @Override
    public void forward() {
    }

    @Override
    public void rewind() {
    }

    @Override
    public void mute() {
    }

    @Override
    public void setVolume(int volume) {
    }

    @Override
    public void add(int index, String uri, String name, String metadata, boolean select) {
    }

    @Override
    public void remove(String uri) {
    }

    @Override
    public int getControls() {
        return 0;
    }

    @Override
    public Playlist getPlaylist() {
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    public Renderer getRenderer() {
        return this.renderer;
    }
}

