/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.windows;

import com.sun.jna.platform.win32.Kernel32;
import net.pms.platform.windows.WindowsUtils;
import net.pms.service.sleep.AbstractSleepWorker;
import net.pms.service.sleep.PreventSleepMode;
import net.pms.service.sleep.SleepManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsSleepWorker
extends AbstractSleepWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(WindowsSleepWorker.class);
    private static final int FIFTEEN_MINUTES_IN_MILLISECONDS = 900000;

    public WindowsSleepWorker(SleepManager owner, PreventSleepMode mode) {
        super("Windows Sleep Worker", mode, owner);
    }

    @Override
    protected int getDelayUntilAllowSleep() {
        return WindowsUtils.isVersionThatSleepsImmediately() ? 900000 : 0;
    }

    @Override
    protected synchronized void doAllowSleep() {
        LOGGER.trace("Calling SetThreadExecutionState ES_CONTINUOUS to allow Windows to go to sleep");
        Kernel32.INSTANCE.SetThreadExecutionState(Integer.MIN_VALUE);
        this.sleepPrevented = false;
    }

    @Override
    protected synchronized void doPreventSleep() {
        LOGGER.trace("Calling SetThreadExecutionState ES_SYSTEM_REQUIRED to prevent Windows from going to sleep");
        Kernel32.INSTANCE.SetThreadExecutionState(-2147483647);
        this.sleepPrevented = true;
    }

    @Override
    protected synchronized void doResetSleepTimer() {
        LOGGER.trace("Calling SetThreadExecutionState ES_SYSTEM_REQUIRED to reset the Windows sleep timer");
        Kernel32.INSTANCE.SetThreadExecutionState(1);
        this.resetSleepTimer = false;
    }
}

