/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac.kernreturn;

import net.pms.platform.mac.kernreturn.KernReturnT;

public enum Message implements KernReturnT
{
    MACH_MSG_IPC_SPACE(8192),
    MACH_MSG_VM_SPACE(4096),
    MACH_MSG_IPC_KERNEL(2048),
    MACH_MSG_VM_KERNEL(1024),
    MACH_SEND_IN_PROGRESS(0x10000001),
    MACH_SEND_INVALID_DATA(0x10000002),
    MACH_SEND_INVALID_DEST(0x10000003),
    MACH_SEND_TIMED_OUT(0x10000004),
    MACH_SEND_INVALID_VOUCHER(0x10000005),
    MACH_SEND_INTERRUPTED(0x10000007),
    MACH_SEND_MSG_TOO_SMALL(0x10000008),
    MACH_SEND_INVALID_REPLY(0x10000009),
    MACH_SEND_INVALID_RIGHT(0x1000000A),
    MACH_SEND_INVALID_NOTIFY(0x1000000B),
    MACH_SEND_INVALID_MEMORY(0x1000000C),
    MACH_SEND_NO_BUFFER(0x1000000D),
    MACH_SEND_TOO_LARGE(0x1000000E),
    MACH_SEND_INVALID_TYPE(0x1000000F),
    MACH_SEND_INVALID_HEADER(0x10000010),
    MACH_SEND_INVALID_TRAILER(0x10000011),
    MACH_SEND_INVALID_RT_OOL_SIZE(0x10000015),
    MACH_RCV_IN_PROGRESS(0x10004001),
    MACH_RCV_INVALID_NAME(268451842),
    MACH_RCV_TIMED_OUT(268451843),
    MACH_RCV_TOO_LARGE(0x10004004),
    MACH_RCV_INTERRUPTED(268451845),
    MACH_RCV_PORT_CHANGED(268451846),
    MACH_RCV_INVALID_NOTIFY(268451847),
    MACH_RCV_INVALID_DATA(268451848),
    MACH_RCV_PORT_DIED(268451849),
    MACH_RCV_IN_SET(268451850),
    MACH_RCV_HEADER_ERROR(268451851),
    MACH_RCV_BODY_ERROR(268451852),
    MACH_RCV_INVALID_TYPE(268451853),
    MACH_RCV_SCATTER_SMALL(268451854),
    MACH_RCV_INVALID_TRAILER(268451855),
    MACH_RCV_IN_PROGRESS_TIMED(0x10004011);

    public static final int MACH_MSG_MASK = 15872;
    private final int value;

    private Message(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static Message typeOf(int msgReturn) {
        for (Message entry : Message.values()) {
            if (entry.getValue() != msgReturn) continue;
            return entry;
        }
        return null;
    }

    public String toString() {
        return this.toStandardString();
    }

    @Override
    public String toStandardString() {
        return super.toString() + " (0x" + Long.toHexString((long)this.value & 0xFFFFFFFFL) + ")";
    }
}

