/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac.kernreturn;

import net.pms.platform.mac.kernreturn.DefaultKernReturnT;
import net.pms.platform.mac.kernreturn.KernReturnT;

public enum IOReturn implements KernReturnT
{
    kIOReturnError(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2BC),
    kIOReturnNoMemory(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2BD),
    kIOReturnNoResources(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2BE),
    kIOReturnIPCError(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2BF),
    kIOReturnNoDevice(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2C0),
    kIOReturnNotPrivileged(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2C1),
    kIOReturnBadArgument(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2C2),
    kIOReturnLockedRead(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2C3),
    kIOReturnLockedWrite(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2C4),
    kIOReturnExclusiveAccess(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2C5),
    kIOReturnBadMessageID(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2C6),
    kIOReturnUnsupported(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2C7),
    kIOReturnVMError(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2C8),
    kIOReturnInternalError(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2C9),
    kIOReturnIOError(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2CA),
    kIOReturnCannotLock(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2CC),
    kIOReturnNotOpen(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2CD),
    kIOReturnNotReadable(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2CE),
    kIOReturnNotWritable(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2CF),
    kIOReturnNotAligned(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2D0),
    kIOReturnBadMedia(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2D1),
    kIOReturnStillOpen(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2D2),
    kIOReturnRLDError(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2D3),
    kIOReturnDMAError(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2D4),
    kIOReturnBusy(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2D5),
    kIOReturnTimeout(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2D6),
    kIOReturnOffline(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2D7),
    kIOReturnNotReady(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2D8),
    kIOReturnNotAttached(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2D9),
    kIOReturnNoChannels(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2DA),
    kIOReturnNoSpace(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2DB),
    kIOReturnPortExists(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2DD),
    kIOReturnCannotWire(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2DE),
    kIOReturnNoInterrupt(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2DF),
    kIOReturnNoFrames(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2E0),
    kIOReturnMessageTooLarge(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2E1),
    kIOReturnNotPermitted(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2E2),
    kIOReturnNoPower(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2E3),
    kIOReturnNoMedia(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2E4),
    kIOReturnUnformattedMedia(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2E5),
    kIOReturnUnsupportedMode(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2E6),
    kIOReturnUnderrun(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2E7),
    kIOReturnOverrun(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2E8),
    kIOReturnDeviceError(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2E9),
    kIOReturnNoCompletion(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2EA),
    kIOReturnAborted(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2EB),
    kIOReturnNoBandwidth(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2EC),
    kIOReturnNotResponding(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2ED),
    kIOReturnIsoTooOld(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2EE),
    kIOReturnIsoTooNew(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2EF),
    kIOReturnNotFound(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 0x2F0),
    kIOReturnInvalid(DefaultKernReturnT.convertToSystem(DefaultKernReturnT.System.sys_iokit) | DefaultKernReturnT.convertToSubsystem(IOReturnSubsystem.sub_iokit_common) | 1);

    private final int value;

    private IOReturn(int value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    public static IOReturn typeOf(int ioReturn) {
        for (IOReturn entry : IOReturn.values()) {
            if (entry.getValue() != ioReturn) continue;
            return entry;
        }
        return null;
    }

    public String toString() {
        return this.toStandardString();
    }

    @Override
    public String toStandardString() {
        return super.toString() + " (0x" + Long.toHexString((long)this.value & 0xFFFFFFFFL) + ")";
    }

    public static enum IOReturnSubsystem implements DefaultKernReturnT.Subsystem
    {
        sub_iokit_common(0),
        sub_iokit_usb(1),
        sub_iokit_firewire(2),
        sub_iokit_block_storage(4),
        sub_iokit_graphics(5),
        sub_iokit_networking(6),
        sub_iokit_bluetooth(8),
        sub_iokit_pmu(9),
        sub_iokit_acpi(10),
        sub_iokit_smbus(11),
        sub_iokit_ahci(12),
        sub_iokit_powermanagement(13),
        sub_iokit_hidsystem(14),
        sub_iokit_scsi(16),
        sub_iokit_usbaudio(17),
        sub_iokit_thunderbolt(29),
        sub_iokit_platform(42),
        sub_iokit_audio_video(69),
        sub_iokit_baseband(128),
        sub_iokit_HDA(254),
        sub_iokit_hsic(327),
        sub_iokit_sdio(372),
        sub_iokit_wlan(520),
        sub_iokit_vendor_specific(-2),
        sub_iokit_reserved(-1);

        private final int value;

        private IOReturnSubsystem(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static DefaultKernReturnT.Subsystem typeOf(int subSystemCode) {
            for (IOReturnSubsystem entry : IOReturnSubsystem.values()) {
                if (entry.getValue() != subSystemCode) continue;
                return entry;
            }
            return null;
        }
    }
}

