/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac.kernreturn;

import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import net.pms.platform.mac.kernreturn.IOReturn;
import net.pms.platform.mac.kernreturn.KernReturn;
import net.pms.platform.mac.kernreturn.KernReturnT;
import net.pms.platform.mac.kernreturn.Message;

public class DefaultKernReturnT
implements KernReturnT {
    public static final DefaultKernReturnT SUCCESS;
    public static final DefaultKernReturnT none;
    public static final DefaultKernReturnT ROUTINE_NIL;
    public static final DefaultKernReturnT KERN_SUCCESS;
    public static final DefaultKernReturnT kIOReturnSuccess;
    public static final DefaultKernReturnT MACH_MSG_SUCCESS;
    private static final Object unmappedSubsystemSetLock;
    private static final HashSet<WeakReference<UnmappedSubsystem>> unmappedSubsystemSet;
    private static final Object unmappedKernReturnSetLock;
    private static final HashSet<WeakReference<DefaultKernReturnT>> unmappedKernReturnSet;
    final int code;

    private DefaultKernReturnT(int code) {
        this.code = code;
    }

    @Override
    public int getValue() {
        return this.code;
    }

    public String toString() {
        return this.toStandardString();
    }

    @Override
    public String toStandardString() {
        if (this.code == 0) {
            return "Success (0)";
        }
        return "DefaultKernReturnT (0x" + Long.toHexString((long)this.code & 0xFFFFFFFFL) + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultKernReturnT getDefaultKernReturnTFromCode(int kernReturn) {
        DefaultKernReturnT result = null;
        Object object = unmappedKernReturnSetLock;
        synchronized (object) {
            Iterator<WeakReference<DefaultKernReturnT>> iterator = unmappedKernReturnSet.iterator();
            while (iterator.hasNext()) {
                WeakReference<DefaultKernReturnT> weakReference = iterator.next();
                DefaultKernReturnT element = (DefaultKernReturnT)weakReference.get();
                if (element == null) {
                    iterator.remove();
                    continue;
                }
                if (element.getValue() != kernReturn) continue;
                result = element;
            }
            if (result == null) {
                result = new DefaultKernReturnT(kernReturn);
                unmappedKernReturnSet.add(new WeakReference<DefaultKernReturnT>(result));
            }
        }
        return result;
    }

    public static int getSystemCode(KernReturnT kernReturn) {
        return DefaultKernReturnT.getSystemCode(kernReturn.getValue());
    }

    public static int getSystemCode(int kernReturn) {
        return kernReturn >> 26 & 0x3F;
    }

    public static System getSystem(KernReturnT kernReturn) {
        return System.typeOf(DefaultKernReturnT.getSystemCode(kernReturn.getValue()));
    }

    public static int convertToSystem(System value) {
        return DefaultKernReturnT.convertToSystem(value.getValue());
    }

    public static int convertToSystem(int value) {
        return (value & 0x3F) << 26;
    }

    public static int convertToSubsystem(Subsystem value) {
        return DefaultKernReturnT.convertToSubsystem(value.getValue());
    }

    public static int convertToSubsystem(int value) {
        return (value & 0xFFF) << 14;
    }

    public static int getSubsystemCode(KernReturnT kernReturn) {
        return DefaultKernReturnT.getSubsystemCode(kernReturn.getValue());
    }

    public static int getSubsystemCode(int kernReturn) {
        return kernReturn >> 14 & 0xFFF;
    }

    public static Subsystem getSubsystem(KernReturnT kernReturn) {
        Subsystem result = null;
        if (kernReturn instanceof IOReturn) {
            result = IOReturn.IOReturnSubsystem.typeOf(DefaultKernReturnT.getSubsystemCode(kernReturn));
        }
        if (result == null) {
            result = DefaultSubsystem.typeOf(DefaultKernReturnT.getSubsystemCode(kernReturn));
        }
        return result != null ? result : DefaultKernReturnT.getUnmappedSubsystemFromCode(DefaultKernReturnT.getSubsystemCode(kernReturn));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UnmappedSubsystem getUnmappedSubsystemFromCode(int value) {
        UnmappedSubsystem result = null;
        Object object = unmappedSubsystemSetLock;
        synchronized (object) {
            Iterator<WeakReference<UnmappedSubsystem>> iterator = unmappedSubsystemSet.iterator();
            while (iterator.hasNext()) {
                WeakReference<UnmappedSubsystem> weakReference = iterator.next();
                UnmappedSubsystem element = (UnmappedSubsystem)weakReference.get();
                if (element == null) {
                    iterator.remove();
                    continue;
                }
                if (element.getValue() != value) continue;
                result = element;
            }
            if (result == null) {
                result = new UnmappedSubsystem(value);
                unmappedSubsystemSet.add(new WeakReference<UnmappedSubsystem>(result));
            }
        }
        return result;
    }

    public static int getErrorCode(KernReturnT kernReturn) {
        return DefaultKernReturnT.getErrorCode(kernReturn.getValue());
    }

    public static int getErrorCode(int kernReturn) {
        return kernReturn & 0x3FFF;
    }

    public static KernReturnT typeOf(int kernReturn) {
        if (kernReturn == 0) {
            return SUCCESS;
        }
        System system = System.typeOf(DefaultKernReturnT.getSystemCode(kernReturn));
        KernReturnT result = null;
        if (system == System.sys_iokit) {
            result = IOReturn.typeOf(kernReturn);
        }
        if (result == null) {
            result = Message.typeOf(kernReturn);
        }
        if (result == null) {
            result = KernReturn.typeOf(kernReturn);
        }
        if (result == null) {
            result = DefaultKernReturnT.getDefaultKernReturnTFromCode(kernReturn);
        }
        return result;
    }

    static {
        none = SUCCESS = new DefaultKernReturnT(0);
        ROUTINE_NIL = SUCCESS;
        KERN_SUCCESS = SUCCESS;
        kIOReturnSuccess = SUCCESS;
        MACH_MSG_SUCCESS = SUCCESS;
        unmappedSubsystemSetLock = new Object();
        unmappedSubsystemSet = new HashSet();
        unmappedKernReturnSetLock = new Object();
        unmappedKernReturnSet = new HashSet();
    }

    public static enum System {
        err_kern(0),
        err_us(1),
        err_server(2),
        err_ipc(3),
        err_mach_ipc(4),
        err_dipc(7),
        sys_iokit(56),
        err_local(62),
        err_ipc_compat(63),
        err_max_system(63);

        private final int value;

        private System(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static System typeOf(int systemCode) {
            for (System entry : System.values()) {
                if (entry.getValue() != systemCode) continue;
                return entry;
            }
            return null;
        }
    }

    public static interface Subsystem {
        public int getValue();
    }

    public static enum DefaultSubsystem implements Subsystem
    {
        none(0),
        unix_err(3);

        private final int value;

        private DefaultSubsystem(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }

        public static Subsystem typeOf(int subSystemCode) {
            for (DefaultSubsystem entry : DefaultSubsystem.values()) {
                if (entry.getValue() != subSystemCode) continue;
                return entry;
            }
            return null;
        }
    }

    public static class UnmappedSubsystem
    implements Subsystem {
        private final int value;

        private UnmappedSubsystem(int value) {
            this.value = value;
        }

        @Override
        public int getValue() {
            return this.value;
        }
    }
}

