/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac.iokit;

import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import net.pms.platform.mac.MacUtils;
import net.pms.platform.mac.corefoundation.CoreFoundation;
import net.pms.platform.mac.iokit.IOKit;
import net.pms.platform.mac.iokit.IOKitException;
import net.pms.platform.mac.kernreturn.DefaultKernReturnT;
import net.pms.platform.mac.kernreturn.KernReturnT;
import net.pms.platform.mac.types.IOIteratorTRef;
import net.pms.platform.mac.types.IORegistryEntryT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IOKitUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(IOKitUtils.class);
    private static final IOKit IOKIT = IOKit.INSTANCE;
    private static final CoreFoundation CF = CoreFoundation.INSTANCE;

    private IOKitUtils() {
    }

    public static long getSystemIdleTimeMS() throws IOKitException {
        IOIteratorTRef iteratorRef = new IOIteratorTRef(true);
        KernReturnT ioReturn = IOKIT.IOServiceGetMatchingServices(null, IOKIT.IOServiceMatching("IOHIDSystem"), iteratorRef);
        try {
            if (ioReturn == DefaultKernReturnT.KERN_SUCCESS) {
                IORegistryEntryT entry = IORegistryEntryT.toIORegistryT(IOKIT.IOIteratorNext(iteratorRef.getValue()));
                if (entry != null) {
                    try {
                        CoreFoundation.CFMutableDictionaryRefByReference dictionaryRef = new CoreFoundation.CFMutableDictionaryRefByReference();
                        ioReturn = IOKIT.IORegistryEntryCreateCFProperties(entry, dictionaryRef, CoreFoundation.ALLOCATOR, 0);
                        if (ioReturn == DefaultKernReturnT.KERN_SUCCESS) {
                            CoreFoundation.CFMutableDictionaryRef dictionary = dictionaryRef.getCFMutableDictionaryRef();
                            try {
                                CoreFoundation.CFTypeRef cfType = CF.CFDictionaryGetValue(dictionaryRef.getCFMutableDictionaryRef(), CoreFoundation.CFStringRef.toCFStringRef("HIDIdleTime"));
                                if (cfType != null) {
                                    CoreFoundation.CFNumberRef cfNumber = new CoreFoundation.CFNumberRef(cfType);
                                    LongByReference nanoSeconds = new LongByReference();
                                    if (CF.CFNumberGetValue(cfNumber, CoreFoundation.CFNumberType.kCFNumberSInt64Type, nanoSeconds)) {
                                        long l = nanoSeconds.getValue() >> 20;
                                        return l;
                                    }
                                    throw new IOKitException("HIDIdleTime out of range");
                                }
                                throw new IOKitException("HIDIdleTime not found");
                            }
                            finally {
                                CF.CFRelease(dictionary);
                            }
                        }
                        throw new IOKitException("IORegistryEntryCreateCFProperties failed with error code: " + ioReturn.toStandardString());
                    }
                    finally {
                        IOKIT.IOObjectRelease(entry);
                    }
                }
                throw new IOKitException("IOHIDSystem not found");
            }
            throw new IOKitException("IOServiceGetMatchingServices failed with error code: " + ioReturn.toStandardString());
        }
        finally {
            if (iteratorRef != null) {
                IOKIT.IOObjectRelease(iteratorRef.getValue());
            }
        }
    }

    public static int disableGoToSleep(String assertionName, String assertionDetails) throws IOKitException {
        IntByReference assertionIdRef = new IntByReference();
        CoreFoundation.CFStringRef assertionType = CoreFoundation.CFStringRef.toCFStringRef("PreventUserIdleSystemSleep");
        CoreFoundation.CFStringRef name = CoreFoundation.CFStringRef.toCFStringRef(assertionName);
        CoreFoundation.CFStringRef details = CoreFoundation.CFStringRef.toCFStringRef(assertionDetails);
        if (MacUtils.isMacOsVersionEqualOrGreater("10.7.0")) {
            KernReturnT ioReturn = IOKIT.IOPMAssertionCreateWithDescription(assertionType, name, details, null, null, 0.0, null, assertionIdRef);
            if (ioReturn == DefaultKernReturnT.KERN_SUCCESS) {
                return assertionIdRef.getValue();
            }
            throw new IOKitException("IOPMAssertionCreateWithDescription failed with error code: " + ioReturn.toStandardString());
        }
        if (MacUtils.isMacOsVersionEqualOrGreater("10.6.0")) {
            KernReturnT ioReturn = IOKIT.IOPMAssertionCreateWithName(assertionType, 255, name, assertionIdRef);
            if (ioReturn == DefaultKernReturnT.KERN_SUCCESS) {
                return assertionIdRef.getValue();
            }
            throw new IOKitException("IOPMAssertionCreateWithName failed with error code: " + ioReturn.toStandardString());
        }
        if (MacUtils.isMacOsVersionEqualOrGreater("10.5.0")) {
            KernReturnT ioReturn = IOKIT.IOPMAssertionCreate(assertionType, 255, assertionIdRef);
            if (ioReturn == DefaultKernReturnT.KERN_SUCCESS) {
                return assertionIdRef.getValue();
            }
            throw new IOKitException("IOPMAssertionCreate failed with error code: " + ioReturn.toStandardString());
        }
        throw new IOKitException("Unable to disable sleep mode; maxOS " + System.getProperty("os.version") + "doesn't support sleep prevention");
    }

    public static void enableGoToSleep(int assertionId) throws IOKitException {
        if (MacUtils.isMacOsVersionEqualOrGreater("10.5.0")) {
            KernReturnT ioReturn = IOKIT.IOPMAssertionRelease(assertionId);
            if (ioReturn != DefaultKernReturnT.KERN_SUCCESS) {
                throw new IOKitException("IOPMAssertionRelease failed with error code: " + ioReturn.toStandardString());
            }
        } else {
            throw new IOKitException("Unable to enable sleep mode; macOS " + System.getProperty("os.version") + "doesn't support sleep prevention");
        }
    }

    public static int resetIdleTimer(String assertionName, int assertionId) throws IOKitException {
        if (MacUtils.isMacOsVersionEqualOrGreater("10.7.3")) {
            IntByReference assertionIdRef = new IntByReference(assertionId > 0 ? assertionId : 0);
            CoreFoundation.CFStringRef name = CoreFoundation.CFStringRef.toCFStringRef(assertionName);
            KernReturnT ioReturn = IOKIT.IOPMAssertionDeclareUserActivity(name, IOKit.IOPMUserActiveType.kIOPMUserActiveLocal, assertionIdRef);
            if (ioReturn == DefaultKernReturnT.KERN_SUCCESS) {
                return assertionIdRef.getValue();
            }
            throw new IOKitException("IOPMAssertionDeclareUserActivity failed with error code: " + ioReturn.toStandardString());
        }
        LOGGER.warn("Unable to reset sleep timer; not supported by maxOS version {}", (Object)System.getProperty("os.version"));
        return -1;
    }
}

