/*
 * Decompiled with CFR 0.152.
 */
package net.pms.platform.mac.corefoundation;

import com.sun.jna.Pointer;
import java.util.Collection;
import java.util.EnumSet;
import net.pms.platform.jna.TerminatedIntArray;
import net.pms.platform.mac.corefoundation.CoreFoundation;

public class TerminatedStringEncodingArray
extends TerminatedIntArray {
    public TerminatedStringEncodingArray() {
    }

    public TerminatedStringEncodingArray(Pointer p) {
        super(p);
    }

    public TerminatedStringEncodingArray(Collection<? extends Integer> source) {
        super(source);
    }

    public CoreFoundation.CFStringBuiltInEncodings getBuiltInEncoding(int index) {
        return CoreFoundation.CFStringBuiltInEncodings.typeOf((Integer)this.get(index));
    }

    public EnumSet<CoreFoundation.CFStringBuiltInEncodings> getBuiltInEncodings() {
        EnumSet<CoreFoundation.CFStringBuiltInEncodings> result = EnumSet.noneOf(CoreFoundation.CFStringBuiltInEncodings.class);
        if (!this.isEmpty()) {
            for (int i = 0; i < this.size(); ++i) {
                CoreFoundation.CFStringBuiltInEncodings encoding = this.getBuiltInEncoding(i);
                if (encoding == null) continue;
                result.add(encoding);
            }
        }
        return result;
    }

    public String getString(int index, boolean includeValue) {
        CoreFoundation.CFStringRef cfString = CoreFoundation.INSTANCE.CFStringGetNameOfEncoding((Integer)this.get(index));
        if (cfString == null) {
            return includeValue ? String.valueOf(this.get(index)) + ": error" : "error";
        }
        return includeValue ? String.valueOf(this.get(index)) + ": " + cfString.toString() : cfString.toString();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean includeValue) {
        if (this.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder("[");
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(this.getString(i, includeValue));
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public Integer getTerminator() {
        return CoreFoundation.CFStringBuiltInEncodings.kCFStringEncodingInvalidId.getValue();
    }
}

